/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.ActivityCreator;
import com.typewritermc.engine.paper.entry.entity.ActivityEntityDisplay;
import com.typewritermc.engine.paper.entry.entity.ActivityManager;
import com.typewritermc.engine.paper.entry.entity.DisplayEntity;
import com.typewritermc.engine.paper.entry.entity.DisplayEntityKt;
import com.typewritermc.engine.paper.entry.entity.EntityActivity;
import com.typewritermc.engine.paper.entry.entity.EntityCreator;
import com.typewritermc.engine.paper.entry.entity.EntityState;
import com.typewritermc.engine.paper.entry.entity.IndividualActivityContext;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.PositionPropertyKt;
import com.typewritermc.engine.paper.entry.entity.SharedActivityEntityDisplayKt;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.entry.entries.EntityDefinitionEntry;
import com.typewritermc.engine.paper.entry.entries.EntityInstanceEntry;
import com.typewritermc.engine.paper.entry.entries.PropertySupplier;
import com.typewritermc.engine.paper.entry.entries.TickableDisplay;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import lirand.api.extensions.server.ServerExtensionsKt;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BM\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u001c\u0010\u000b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\r0\f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010$\u001a\u00020\"H\u0016J\u0010\u0010%\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010&\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010'\u001a\u00020\"H\u0016J\u0018\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u000fH\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\u00112\u0006\u0010)\u001a\u00020\u0018H\u0016J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u0018H\u0016J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u0018H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u001a0\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001c0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/typewritermc/engine/paper/entry/entity/IndividualActivityEntityDisplay;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/TickableDisplay;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityEntityDisplay;", "ref", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityInstanceEntry;", "creator", "Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;", "activityCreator", "Lcom/typewritermc/engine/paper/entry/entity/ActivityCreator;", "suppliers", "", "Lkotlin/Pair;", "Lcom/typewritermc/engine/paper/entry/entries/PropertySupplier;", "", "spawnPosition", "Lcom/typewritermc/core/utils/point/Position;", "<init>", "(Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;Lcom/typewritermc/engine/paper/entry/entity/ActivityCreator;Ljava/util/List;Lcom/typewritermc/core/utils/point/Position;)V", "getCreator", "()Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;", "activityManagers", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityManager;", "Lcom/typewritermc/engine/paper/entry/entity/IndividualActivityContext;", "entities", "Lcom/typewritermc/engine/paper/entry/entity/DisplayEntity;", "filter", "", "player", "Lorg/bukkit/entity/Player;", "onPlayerAdd", "", "onPlayerFilterAdded", "tick", "onPlayerFilterRemoved", "onPlayerRemove", "dispose", "playerSeesEntity", "playerId", "entityId", "position", "canView", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nIndividualActivityEntityDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndividualActivityEntityDisplay.kt\ncom/typewritermc/engine/paper/entry/entity/IndividualActivityEntityDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,92:1\n1863#2,2:93\n1863#2,2:97\n1863#2,2:99\n1863#2,2:101\n216#3,2:95\n*S KotlinDebug\n*F\n+ 1 IndividualActivityEntityDisplay.kt\ncom/typewritermc/engine/paper/entry/entity/IndividualActivityEntityDisplay\n*L\n51#1:93,2\n59#1:97,2\n74#1:99,2\n76#1:101,2\n53#1:95,2\n*E\n"})
public final class IndividualActivityEntityDisplay
extends AudienceFilter
implements TickableDisplay,
ActivityEntityDisplay {
    @NotNull
    private final Ref<? extends EntityInstanceEntry> ref;
    @NotNull
    private final EntityCreator creator;
    @NotNull
    private final ActivityCreator activityCreator;
    @NotNull
    private final List<Pair<PropertySupplier<?>, Integer>> suppliers;
    @NotNull
    private final Position spawnPosition;
    @NotNull
    private final ConcurrentHashMap<UUID, ActivityManager<? super IndividualActivityContext>> activityManagers;
    @NotNull
    private final ConcurrentHashMap<UUID, DisplayEntity> entities;

    public IndividualActivityEntityDisplay(@NotNull Ref<? extends EntityInstanceEntry> ref, @NotNull EntityCreator creator, @NotNull ActivityCreator activityCreator, @NotNull List<? extends Pair<? extends PropertySupplier<?>, Integer>> suppliers, @NotNull Position spawnPosition) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        Intrinsics.checkNotNullParameter(creator, "creator");
        Intrinsics.checkNotNullParameter(activityCreator, "activityCreator");
        Intrinsics.checkNotNullParameter(suppliers, "suppliers");
        Intrinsics.checkNotNullParameter(spawnPosition, "spawnPosition");
        super(ref);
        this.ref = ref;
        this.creator = creator;
        this.activityCreator = activityCreator;
        this.suppliers = suppliers;
        this.spawnPosition = spawnPosition;
        this.activityManagers = new ConcurrentHashMap();
        this.entities = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public EntityCreator getCreator() {
        return this.creator;
    }

    @Override
    public boolean filter(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        ActivityManager<? super IndividualActivityContext> activityManager = this.activityManagers.get(player.getUniqueId());
        if (activityManager == null) {
            return false;
        }
        ActivityManager<? super IndividualActivityContext> activityManager2 = activityManager;
        PositionProperty npcPosition = activityManager2.getPosition();
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Double d = npcPosition.distanceSqrt(location);
        if (d == null) {
            return false;
        }
        double distance = d;
        return distance <= SharedActivityEntityDisplayKt.getEntityShowRange() * SharedActivityEntityDisplayKt.getEntityShowRange();
    }

    @Override
    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.activityManagers.computeIfAbsent(player.getUniqueId(), arg_0 -> IndividualActivityEntityDisplay.onPlayerAdd$lambda$1(arg_0 -> IndividualActivityEntityDisplay.onPlayerAdd$lambda$0(this, player, arg_0), arg_0));
        super.onPlayerAdd(player);
    }

    @Override
    public void onPlayerFilterAdded(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        super.onPlayerFilterAdded(player);
        ActivityManager<? super IndividualActivityContext> activityManager = this.activityManagers.get(player.getUniqueId());
        if (activityManager == null) {
            return;
        }
        ActivityManager<? super IndividualActivityContext> activityManager2 = activityManager;
        this.entities.computeIfAbsent(player.getUniqueId(), arg_0 -> IndividualActivityEntityDisplay.onPlayerFilterAdded$lambda$3(arg_0 -> IndividualActivityEntityDisplay.onPlayerFilterAdded$lambda$2(player, this, activityManager2, arg_0), arg_0));
    }

    @Override
    public void tick() {
        boolean bl;
        Object it;
        Object $this$forEach$iv = this.getConsideredPlayers();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            it = (Player)t;
            bl = false;
            this.refresh((Player)it);
        }
        $this$forEach$iv = this.activityManagers;
        $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            Player player;
            it = entry;
            bl = false;
            UUID pid = (UUID)it.getKey();
            ActivityManager manager = (ActivityManager)it.getValue();
            if (ServerExtensionsKt.getServer().getPlayer(pid) == null) continue;
            boolean isViewing = this.contains(pid);
            Object object = this.entities.get(pid);
            if (object == null || (object = ((DisplayEntity)object).getState()) == null) {
                object = new EntityState(0.0, 1, null);
            }
            Object entityState = object;
            manager.tick((ActivityContext)new IndividualActivityContext(this.ref, player, isViewing, (EntityState)entityState));
        }
        Collection<DisplayEntity> collection = this.entities.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        $this$forEach$iv = collection;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            it = (DisplayEntity)object;
            bl = false;
            ((DisplayEntity)it).tick();
        }
    }

    @Override
    public void onPlayerFilterRemoved(@NotNull Player player) {
        block0: {
            Intrinsics.checkNotNullParameter(player, "player");
            super.onPlayerFilterRemoved(player);
            DisplayEntity displayEntity = this.entities.remove(player.getUniqueId());
            if (displayEntity == null) break block0;
            displayEntity.dispose();
        }
    }

    @Override
    public void onPlayerRemove(@NotNull Player player) {
        block0: {
            Intrinsics.checkNotNullParameter(player, "player");
            super.onPlayerRemove(player);
            ActivityManager<? super IndividualActivityContext> activityManager = this.activityManagers.remove(player.getUniqueId());
            if (activityManager == null) break block0;
            activityManager.dispose((IndividualActivityContext)((ActivityContext)new IndividualActivityContext(this.ref, player, false, null, 12, null)));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        Collection<DisplayEntity> collection = this.entities.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DisplayEntity it = (DisplayEntity)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.entities.clear();
        Set<Map.Entry<UUID, ActivityManager<? super IndividualActivityContext>>> set2 = this.activityManagers.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-entries>(...)");
        $this$forEach$iv = set2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            Ref<? extends EntityInstanceEntry> ref;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(entry);
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, "component1(...)");
            UUID playerId = (UUID)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "component2(...)");
            if (ServerExtensionsKt.getServer().getPlayer(playerId) == null) continue;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 12;
            EntityState entityState = null;
            boolean bl2 = false;
            ActivityManager activityManager = (ActivityManager)v;
            activityManager.dispose((ActivityContext)new IndividualActivityContext(ref, player, bl2, entityState, n, defaultConstructorMarker));
        }
        this.activityManagers.clear();
    }

    @Override
    public boolean playerSeesEntity(@NotNull UUID playerId, int entityId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        DisplayEntity displayEntity = this.entities.get(playerId);
        return displayEntity != null ? displayEntity.contains(entityId) : false;
    }

    @Override
    @Nullable
    public Position position(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        ActivityManager<? super IndividualActivityContext> activityManager = this.activityManagers.get(playerId);
        return activityManager != null ? activityManager.getPosition() : null;
    }

    @Override
    public boolean canView(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        return this.canConsider(playerId);
    }

    @Override
    public int entityId(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        DisplayEntity displayEntity = this.entities.get(playerId);
        return displayEntity != null ? displayEntity.getEntityId() : 0;
    }

    @Override
    @Nullable
    public EntityDefinitionEntry getDefinition() {
        return ActivityEntityDisplay.DefaultImpls.getDefinition(this);
    }

    private static final ActivityManager onPlayerAdd$lambda$0(IndividualActivityEntityDisplay this$0, Player $player, UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        IndividualActivityContext context = new IndividualActivityContext(this$0.ref, $player, false, null, 12, null);
        EntityActivity<ActivityContext> activity = this$0.activityCreator.create(context, PositionPropertyKt.toProperty(this$0.spawnPosition));
        ActivityManager<ActivityContext> activityManager = new ActivityManager<ActivityContext>(activity);
        activityManager.initialize(context);
        return activityManager;
    }

    private static final ActivityManager onPlayerAdd$lambda$1(Function1 $tmp0, Object p0) {
        return (ActivityManager)$tmp0.invoke(p0);
    }

    private static final DisplayEntity onPlayerFilterAdded$lambda$2(Player $player, IndividualActivityEntityDisplay this$0, ActivityManager $activityManager, UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new DisplayEntity($player, this$0.getCreator(), $activityManager, DisplayEntityKt.toCollectors(this$0.suppliers));
    }

    private static final DisplayEntity onPlayerFilterAdded$lambda$3(Function1 $tmp0, Object p0) {
        return (DisplayEntity)$tmp0.invoke(p0);
    }
}

