/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.entity;

import com.typewritermc.engine.paper.entry.entity.ActivityManager;
import com.typewritermc.engine.paper.entry.entity.EntityCreator;
import com.typewritermc.engine.paper.entry.entity.EntityState;
import com.typewritermc.engine.paper.entry.entity.FakeEntity;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.engine.paper.entry.entries.PropertyCollector;
import com.typewritermc.engine.paper.utils.PointKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0011\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\u0006\u0010\u001e\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/typewritermc/engine/paper/entry/entity/DisplayEntity;", "", "player", "Lorg/bukkit/entity/Player;", "creator", "Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;", "activityManager", "Lcom/typewritermc/engine/paper/entry/entity/ActivityManager;", "collectors", "", "Lcom/typewritermc/engine/paper/entry/entries/PropertyCollector;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/engine/paper/entry/entity/EntityCreator;Lcom/typewritermc/engine/paper/entry/entity/ActivityManager;Ljava/util/List;)V", "entity", "Lcom/typewritermc/engine/paper/entry/entity/FakeEntity;", "lastSoundLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "state", "Lcom/typewritermc/engine/paper/entry/entity/EntityState;", "getState", "()Lcom/typewritermc/engine/paper/entry/entity/EntityState;", "entityId", "", "getEntityId", "()I", "tick", "", "applyProperties", "contains", "", "dispose", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nDisplayEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayEntity.kt\ncom/typewritermc/engine/paper/entry/entity/DisplayEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n774#2:82\n865#2:83\n2632#2,3:84\n866#2:87\n1611#2,9:88\n1863#2:97\n1864#2:99\n1620#2:100\n1#3:98\n*S KotlinDebug\n*F\n+ 1 DisplayEntity.kt\ncom/typewritermc/engine/paper/entry/entity/DisplayEntity\n*L\n50#1:82\n50#1:83\n50#1:84,3\n50#1:87\n51#1:88,9\n51#1:97\n51#1:99\n51#1:100\n51#1:98\n*E\n"})
public final class DisplayEntity {
    @NotNull
    private final Player player;
    @NotNull
    private final ActivityManager<?> activityManager;
    @NotNull
    private final List<PropertyCollector<?>> collectors;
    @NotNull
    private final FakeEntity entity;
    @NotNull
    private PositionProperty lastSoundLocation;

    public DisplayEntity(@NotNull Player player, @NotNull EntityCreator creator, @NotNull ActivityManager<?> activityManager, @NotNull List<? extends PropertyCollector<?>> collectors) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(creator, "creator");
        Intrinsics.checkNotNullParameter(activityManager, "activityManager");
        Intrinsics.checkNotNullParameter(collectors, "collectors");
        this.player = player;
        this.activityManager = activityManager;
        this.collectors = collectors;
        this.entity = creator.create(this.player);
        this.lastSoundLocation = this.activityManager.getPosition();
        this.entity.spawn(this.activityManager.getPosition());
        this.applyProperties();
    }

    @NotNull
    public final EntityState getState() {
        return this.entity.getState();
    }

    public final int getEntityId() {
        return this.entity.getEntityId();
    }

    public final void tick() {
        this.applyProperties();
        this.entity.tick();
        Double d = this.lastSoundLocation.distanceSqrt(this.activityManager.getPosition());
        double d2 = d != null ? d : 0.0;
        if (d2 > 1.7) {
            this.lastSoundLocation = this.activityManager.getPosition();
            Sound sound = PointKt.toBukkitLocation(this.lastSoundLocation).getBlock().getBlockData().getSoundGroup().getStepSound();
            Intrinsics.checkNotNullExpressionValue(sound, "getStepSound(...)");
            Sound sound2 = sound;
            this.player.playSound(PointKt.toBukkitLocation(this.lastSoundLocation), sound2, SoundCategory.NEUTRAL, 0.4f, 1.0f);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyProperties() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        List<EntityProperty> activeProperties = this.activityManager.getActiveProperties();
        Iterable $this$filter$iv = this.collectors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                PropertyCollector it = (PropertyCollector)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = activeProperties;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        EntityProperty active = (EntityProperty)element$iv;
                        boolean bl3 = false;
                        if (!it.getType().isInstance(active)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PropertyCollector it = (PropertyCollector)element$iv$iv;
            boolean bl4 = false;
            if (it.collect(this.player) == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List properties2 = (List)destination$iv$iv;
        this.entity.consumeProperties(CollectionsKt.plus((Collection)activeProperties, (Iterable)properties2));
    }

    public final boolean contains(int entityId) {
        return this.entity.contains(entityId);
    }

    public final void dispose() {
        this.entity.dispose();
    }
}

