/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry.dialogue;

import com.typewritermc.core.entries.LibraryKt;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.TriggerEntryKt;
import com.typewritermc.engine.paper.entry.TriggerableEntry;
import com.typewritermc.engine.paper.entry.dialogue.DialogueMessenger;
import com.typewritermc.engine.paper.entry.dialogue.DialogueSequenceKt;
import com.typewritermc.engine.paper.entry.dialogue.MessengerFinder;
import com.typewritermc.engine.paper.entry.dialogue.MessengerState;
import com.typewritermc.engine.paper.entry.dialogue.TickContext;
import com.typewritermc.engine.paper.entry.entries.DialogueEntry;
import com.typewritermc.engine.paper.entry.entries.SpeakerEntry;
import com.typewritermc.engine.paper.entry.entries.SystemTrigger;
import com.typewritermc.engine.paper.events.AsyncDialogueEndEvent;
import com.typewritermc.engine.paper.events.AsyncDialogueStartEvent;
import com.typewritermc.engine.paper.events.AsyncDialogueSwitchEvent;
import com.typewritermc.engine.paper.facts.FactDatabase;
import com.typewritermc.engine.paper.interaction.ActionBarBlockerKt;
import com.typewritermc.engine.paper.interaction.ChatHistoryHandlerKt;
import com.typewritermc.engine.paper.utils.ThreadType;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u00109\u001a\u00020:J\b\u0010;\u001a\u00020:H\u0002J\u000e\u0010<\u001a\u00020:2\u0006\u0010=\u001a\u00020%J\u000e\u0010>\u001a\u00020:2\u0006\u0010?\u001a\u00020\u0005J\u0010\u0010@\u001a\u00020:2\u0006\u0010A\u001a\u00020)H\u0002J\u0006\u0010B\u001a\u00020:R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\r8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011*\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0016\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010*\"\u0004\b+\u0010,R\u001f\u0010-\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020/0\n0.8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R$\u00107\u001a\u00020)2\u0006\u00106\u001a\u00020)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b7\u0010*\"\u0004\b8\u0010,\u00a8\u0006C"}, d2={"Lcom/typewritermc/engine/paper/entry/dialogue/DialogueSequence;", "Lorg/koin/core/component/KoinComponent;", "player", "Lorg/bukkit/entity/Player;", "initialEntry", "Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;)V", "_speakers", "", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/SpeakerEntry;", "speakers", "", "getSpeakers$delegate", "(Lcom/typewritermc/engine/paper/entry/dialogue/DialogueSequence;)Ljava/lang/Object;", "getSpeakers", "()Ljava/util/Set;", "messengerFinder", "Lcom/typewritermc/engine/paper/entry/dialogue/MessengerFinder;", "getMessengerFinder", "()Lcom/typewritermc/engine/paper/entry/dialogue/MessengerFinder;", "messengerFinder$delegate", "Lkotlin/Lazy;", "factDatabase", "Lcom/typewritermc/engine/paper/facts/FactDatabase;", "getFactDatabase", "()Lcom/typewritermc/engine/paper/facts/FactDatabase;", "factDatabase$delegate", "currentEntry", "getCurrentEntry$engine_paper", "()Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;", "setCurrentEntry$engine_paper", "(Lcom/typewritermc/engine/paper/entry/entries/DialogueEntry;)V", "currentMessenger", "Lcom/typewritermc/engine/paper/entry/dialogue/DialogueMessenger;", "playTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "Ljava/time/Duration;", "isActive", "", "()Z", "setActive", "(Z)V", "triggers", "", "Lcom/typewritermc/engine/paper/entry/TriggerableEntry;", "getTriggers", "()Ljava/util/List;", "priority", "", "getPriority", "()I", "value", "isCompleted", "setCompleted", "init", "", "setup", "tick", "deltaTime", "next", "nextEntry", "cleanupEntry", "final", "end", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nDialogueSequence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogueSequence.kt\ncom/typewritermc/engine/paper/entry/dialogue/DialogueSequence\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,138:1\n58#2,6:139\n58#2,6:145\n*S KotlinDebug\n*F\n+ 1 DialogueSequence.kt\ncom/typewritermc/engine/paper/entry/dialogue/DialogueSequence\n*L\n29#1:139,6\n30#1:145,6\n*E\n"})
public final class DialogueSequence
implements KoinComponent {
    @NotNull
    private final Player player;
    @NotNull
    private final Set<Ref<SpeakerEntry>> _speakers;
    @NotNull
    private final Lazy messengerFinder$delegate;
    @NotNull
    private final Lazy factDatabase$delegate;
    @NotNull
    private DialogueEntry currentEntry;
    @NotNull
    private DialogueMessenger<? extends DialogueEntry> currentMessenger;
    private Duration playTime;
    private boolean isActive;

    public DialogueSequence(@NotNull Player player, @NotNull DialogueEntry initialEntry) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(initialEntry, "initialEntry");
        this.player = player;
        this._speakers = new LinkedHashSet();
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.messengerFinder$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<MessengerFinder>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final MessengerFinder invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(MessengerFinder.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(MessengerFinder.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.factDatabase$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<FactDatabase>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FactDatabase invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(FactDatabase.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(FactDatabase.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        this.currentEntry = initialEntry;
        this.currentMessenger = this.getMessengerFinder().findMessenger(this.player, initialEntry);
        this.playTime = Duration.ZERO;
    }

    @NotNull
    public final Set<Ref<SpeakerEntry>> getSpeakers() {
        return this._speakers;
    }

    private static Object getSpeakers$delegate(DialogueSequence dialogueSequence) {
        return Reflection.property0(new PropertyReference0Impl((Object)dialogueSequence, DialogueSequence.class, "_speakers", "get_speakers()Ljava/util/Set;", 0));
    }

    private final MessengerFinder getMessengerFinder() {
        Lazy lazy = this.messengerFinder$delegate;
        return (MessengerFinder)lazy.getValue();
    }

    private final FactDatabase getFactDatabase() {
        Lazy lazy = this.factDatabase$delegate;
        return (FactDatabase)lazy.getValue();
    }

    @NotNull
    public final DialogueEntry getCurrentEntry$engine_paper() {
        return this.currentEntry;
    }

    public final void setCurrentEntry$engine_paper(@NotNull DialogueEntry dialogueEntry) {
        Intrinsics.checkNotNullParameter(dialogueEntry, "<set-?>");
        this.currentEntry = dialogueEntry;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final void setActive(boolean bl) {
        this.isActive = bl;
    }

    @NotNull
    public final List<Ref<? extends TriggerableEntry>> getTriggers() {
        return this.currentMessenger.getTriggers();
    }

    public final int getPriority() {
        return LibraryKt.getPriority(this.currentEntry);
    }

    public final boolean isCompleted() {
        return this.currentMessenger.isCompleted();
    }

    public final void setCompleted(boolean value) {
        this.currentMessenger.setCompleted(value);
    }

    public final void init() {
        this.setup();
        Duration duration = this.playTime;
        Intrinsics.checkNotNullExpressionValue(duration, "playTime");
        this.tick(duration);
        ThreadType.DISPATCHERS_ASYNC.launch((Function1<? super Continuation<? super Unit>, ? extends Object>)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DialogueSequence this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        new AsyncDialogueStartEvent(DialogueSequence.access$getPlayer$p(this.this$0)).callEvent();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final void setup() {
        this.isActive = true;
        this.playTime = Duration.ZERO;
        this.currentMessenger.init();
        this._speakers.add(this.currentEntry.getSpeaker());
        DialogueSequenceKt.playSpeakerSound(this.player, this.currentEntry.getSpeaker().get());
        ChatHistoryHandlerKt.startBlockingMessages(this.player);
        ActionBarBlockerKt.startBlockingActionBar(this.player);
    }

    public final void tick(@NotNull Duration deltaTime) {
        Intrinsics.checkNotNullParameter(deltaTime, "deltaTime");
        if (!this.isActive) {
            return;
        }
        this.playTime = this.playTime.plus(deltaTime);
        if (this.currentMessenger.getState() == MessengerState.FINISHED) {
            this.isActive = false;
            TriggerEntryKt.triggerFor(SystemTrigger.DIALOGUE_NEXT_OR_COMPLETE, this.player);
        } else if (this.currentMessenger.getState() == MessengerState.CANCELLED) {
            this.isActive = false;
            TriggerEntryKt.triggerFor(SystemTrigger.DIALOGUE_END, this.player);
        }
        Duration duration = this.playTime;
        Intrinsics.checkNotNullExpressionValue(duration, "playTime");
        this.currentMessenger.tick(new TickContext(duration, deltaTime));
    }

    public final void next(@NotNull DialogueEntry nextEntry) {
        Intrinsics.checkNotNullParameter(nextEntry, "nextEntry");
        this.cleanupEntry(false);
        this.currentEntry = nextEntry;
        this.currentMessenger = this.getMessengerFinder().findMessenger(this.player, nextEntry);
        this.setup();
        ThreadType.DISPATCHERS_ASYNC.launch((Function1<? super Continuation<? super Unit>, ? extends Object>)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DialogueSequence this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        new AsyncDialogueSwitchEvent(DialogueSequence.access$getPlayer$p(this.this$0)).callEvent();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final void cleanupEntry(boolean bl) {
        DialogueMessenger<? extends DialogueEntry> messenger = this.currentMessenger;
        if (bl) {
            ChatHistoryHandlerKt.stopBlockingMessages(this.player);
            ActionBarBlockerKt.stopBlockingActionBar(this.player);
            messenger.end();
        }
        messenger.dispose();
        this.getFactDatabase().modify(this.player, messenger.getModifiers());
    }

    public final void end() {
        this.isActive = false;
        this.cleanupEntry(true);
        ThreadType.DISPATCHERS_ASYNC.launch((Function1<? super Continuation<? super Unit>, ? extends Object>)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DialogueSequence this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        new AsyncDialogueEndEvent(DialogueSequence.access$getPlayer$p(this.this$0)).callEvent();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin(this);
    }

    public static final /* synthetic */ Player access$getPlayer$p(DialogueSequence $this) {
        return $this.player;
    }
}

