/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.entry;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.FactListener;
import com.typewritermc.engine.paper.entry.FactListenerSubscription;
import com.typewritermc.engine.paper.entry.FactWatcherKt;
import com.typewritermc.engine.paper.entry.entries.ReadableFactEntry;
import com.typewritermc.engine.paper.facts.FactData;
import io.ktor.util.collections.ConcurrentMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0014\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0016\u0010\u0014\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J:\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00182\u001e\u0010\u0019\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\u00100\u001aJ\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/typewritermc/engine/paper/entry/FactWatcher;", "", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "factCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/ReadableFactEntry;", "", "listeners", "Lio/ktor/util/collections/ConcurrentMap;", "Ljava/util/UUID;", "Lcom/typewritermc/engine/paper/entry/FactListener;", "tick", "", "refresh", "refreshFact", "ref", "notifyListeners", "addListener", "Lcom/typewritermc/engine/paper/entry/FactListenerSubscription;", "facts", "", "listener", "Lkotlin/Function2;", "removeListener", "subscription", "Companion", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nFactWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FactWatcher.kt\ncom/typewritermc/engine/paper/entry/FactWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1863#2,2:131\n774#2:133\n865#2,2:134\n1863#2,2:136\n2632#2,3:138\n*S KotlinDebug\n*F\n+ 1 FactWatcher.kt\ncom/typewritermc/engine/paper/entry/FactWatcher\n*L\n25#1:131,2\n42#1:133\n42#1:134,2\n43#1:136,2\n70#1:138,3\n*E\n"})
public final class FactWatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Player player;
    @NotNull
    private final ConcurrentHashMap<Ref<ReadableFactEntry>, Integer> factCache;
    @NotNull
    private final ConcurrentMap<UUID, FactListener> listeners;

    public FactWatcher(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.player = player;
        this.factCache = new ConcurrentHashMap();
        this.listeners = new ConcurrentMap(0, 1, null);
    }

    public final void tick() {
        this.refresh();
    }

    private final void refresh() {
        Set set2 = this.factCache.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Ref it = (Ref)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.refreshFact(it);
        }
    }

    public final void refreshFact(@NotNull Ref<ReadableFactEntry> ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        Integer n = this.factCache.get(ref);
        if (n == null) {
            return;
        }
        int old = n;
        ReadableFactEntry readableFactEntry = ref.get();
        if (readableFactEntry == null) {
            return;
        }
        ReadableFactEntry fact = readableFactEntry;
        int n2 = fact.readForPlayersGroup(this.player).getValue();
        if (old != n2) {
            Integer n3 = n2;
            ((Map)this.factCache).put(ref, n3);
            this.notifyListeners(ref);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void notifyListeners(Ref<ReadableFactEntry> ref) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.listeners.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FactListener it = (FactListener)element$iv$iv;
            boolean bl = false;
            if (!it.contains(ref)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FactListener listener2 = (FactListener)element$iv;
            boolean bl = false;
            listener2.getListener().invoke(this.player, ref);
        }
    }

    @NotNull
    public final FactListenerSubscription addListener(@NotNull List<Ref<ReadableFactEntry>> facts2, @NotNull Function2<? super Player, ? super Ref<ReadableFactEntry>, Unit> listener2) {
        Intrinsics.checkNotNullParameter(facts2, "facts");
        Intrinsics.checkNotNullParameter(listener2, "listener");
        UUID id = null;
        while (this.listeners.containsKey(id = UUID.randomUUID())) {
        }
        ((Map)this.listeners).put(id, new FactListener(id, facts2, listener2));
        for (Ref<ReadableFactEntry> fact : facts2) {
            this.factCache.computeIfAbsent(fact, arg_0 -> FactWatcher.addListener$lambda$4(arg_0 -> FactWatcher.addListener$lambda$3(fact, this, arg_0), arg_0));
        }
        return new FactListenerSubscription(id);
    }

    public final void removeListener(@NotNull FactListenerSubscription subscription) {
        Intrinsics.checkNotNullParameter(subscription, "subscription");
        this.listeners.remove(subscription.getId());
        Set set2 = this.factCache.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        for (Ref fact : CollectionsKt.toList(set2)) {
            boolean bl;
            block4: {
                Iterable $this$none$iv = this.listeners.values();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        FactListener it = (FactListener)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull(fact);
                        if (!it.contains(fact)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            this.factCache.remove(fact);
        }
    }

    private static final Integer addListener$lambda$3(Ref $fact, FactWatcher this$0, Ref it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Object object = (ReadableFactEntry)$fact.get();
        return object != null && (object = object.readForPlayersGroup(this$0.player)) != null ? Integer.valueOf(((FactData)object).getValue()) : Integer.valueOf(0);
    }

    private static final Integer addListener$lambda$4(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final FactListenerSubscription listenForFacts(@NotNull Player player, @NotNull List<Ref<ReadableFactEntry>> facts2, @NotNull Function2<? super Player, ? super Ref<ReadableFactEntry>, Unit> listener2) {
        return Companion.listenForFacts(player, facts2, listener2);
    }

    @JvmStatic
    public static final void stopListening(@NotNull Player player, @NotNull FactListenerSubscription subscription) {
        Companion.stopListening(player, subscription);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/typewritermc/engine/paper/entry/FactWatcher$Companion;", "", "<init>", "()V", "listenForFacts", "Lcom/typewritermc/engine/paper/entry/FactListenerSubscription;", "player", "Lorg/bukkit/entity/Player;", "facts", "", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/ReadableFactEntry;", "listener", "Lkotlin/Function2;", "", "stopListening", "subscription", "engine-paper"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FactListenerSubscription listenForFacts(@NotNull Player player, @NotNull List<Ref<ReadableFactEntry>> facts2, @NotNull Function2<? super Player, ? super Ref<ReadableFactEntry>, Unit> listener2) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(facts2, "facts");
            Intrinsics.checkNotNullParameter(listener2, "listener");
            return FactWatcherKt.listenForFacts(player, facts2, listener2);
        }

        @JvmStatic
        public final void stopListening(@NotNull Player player, @NotNull FactListenerSubscription subscription) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(subscription, "subscription");
            FactWatcherKt.stopListening(player, subscription);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

