/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.content.modes;

import com.typewritermc.engine.paper.content.ContentComponent;
import com.typewritermc.engine.paper.content.ContentContext;
import com.typewritermc.engine.paper.content.ContentContextKt;
import com.typewritermc.engine.paper.content.components.IntractableItem;
import com.typewritermc.engine.paper.content.components.ItemInteraction;
import com.typewritermc.engine.paper.content.components.ItemsComponent;
import com.typewritermc.engine.paper.content.components.ItemsComponentKt;
import com.typewritermc.engine.paper.content.modes.RecordingCinematicContentMode;
import com.typewritermc.engine.paper.entry.TriggerEntryKt;
import com.typewritermc.engine.paper.entry.entries.ContentModeTrigger;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004Be\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00120\u0010\u000b\u001a,\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u001eJ\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u001d\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R;\u0010\u000b\u001a,\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lcom/typewritermc/engine/paper/content/modes/RecordingCinematicComponent;", "T", "", "Lcom/typewritermc/engine/paper/content/ContentComponent;", "Lcom/typewritermc/engine/paper/content/components/ItemsComponent;", "context", "Lcom/typewritermc/engine/paper/content/ContentContext;", "slot", "", "frameFetcher", "Lkotlin/Function0;", "modeCreator", "Lkotlin/Function4;", "Lorg/bukkit/entity/Player;", "Lkotlin/reflect/KClass;", "Lcom/typewritermc/engine/paper/content/modes/RecordingCinematicContentMode;", "klass", "<init>", "(Lcom/typewritermc/engine/paper/content/ContentContext;ILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function4;Lkotlin/reflect/KClass;)V", "getSlot", "()I", "getFrameFetcher", "()Lkotlin/jvm/functions/Function0;", "getModeCreator", "()Lkotlin/jvm/functions/Function4;", "getKlass", "()Lkotlin/reflect/KClass;", "initialize", "", "player", "(Lorg/bukkit/entity/Player;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tick", "dispose", "items", "", "Lcom/typewritermc/engine/paper/content/components/IntractableItem;", "engine-paper"})
public final class RecordingCinematicComponent<T>
implements ContentComponent,
ItemsComponent {
    @NotNull
    private final ContentContext context;
    private final int slot;
    @NotNull
    private final Function0<Integer> frameFetcher;
    @NotNull
    private final Function4<ContentContext, Player, Integer, KClass<T>, RecordingCinematicContentMode<T>> modeCreator;
    @NotNull
    private final KClass<T> klass;

    public RecordingCinematicComponent(@NotNull ContentContext context, int slot, @NotNull Function0<Integer> frameFetcher, @NotNull Function4<? super ContentContext, ? super Player, ? super Integer, ? super KClass<T>, ? extends RecordingCinematicContentMode<T>> modeCreator, @NotNull KClass<T> klass) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(frameFetcher, "frameFetcher");
        Intrinsics.checkNotNullParameter(modeCreator, "modeCreator");
        Intrinsics.checkNotNullParameter(klass, "klass");
        this.context = context;
        this.slot = slot;
        this.frameFetcher = frameFetcher;
        this.modeCreator = modeCreator;
        this.klass = klass;
    }

    public final int getSlot() {
        return this.slot;
    }

    @NotNull
    public final Function0<Integer> getFrameFetcher() {
        return this.frameFetcher;
    }

    @NotNull
    public final Function4<ContentContext, Player, Integer, KClass<T>, RecordingCinematicContentMode<T>> getModeCreator() {
        return this.modeCreator;
    }

    @NotNull
    public final KClass<T> getKlass() {
        return this.klass;
    }

    @Override
    @Nullable
    public Object initialize(@NotNull Player player, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object tick(@NotNull Player player, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object dispose(@NotNull Player player, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public Map<Integer, IntractableItem> items(@NotNull Player player) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter(player, "player");
        Integer n = ContentContextKt.getEndFrame(this.context);
        if (((Number)this.frameFetcher.invoke()).intValue() > (n != null ? n : 0)) {
            ItemStack itemStack2;
            ItemStack $this$items_u24lambda_u242 = itemStack2 = new ItemStack(Material.BARRIER);
            boolean bl = false;
            $this$items_u24lambda_u242.editMeta(arg_0 -> RecordingCinematicComponent.items$lambda$2$lambda$1(RecordingCinematicComponent::items$lambda$2$lambda$0, arg_0));
            IntractableItem item = ItemsComponentKt.onInteract(itemStack2, RecordingCinematicComponent::items$lambda$3);
            return MapsKt.mapOf(TuplesKt.to(this.slot, item));
        }
        ItemStack $this$items_u24lambda_u246 = itemStack = new ItemStack(Material.BOOK);
        boolean bl = false;
        $this$items_u24lambda_u246.editMeta(arg_0 -> RecordingCinematicComponent.items$lambda$6$lambda$5(RecordingCinematicComponent::items$lambda$6$lambda$4, arg_0));
        IntractableItem item = ItemsComponentKt.onInteract(itemStack, arg_0 -> RecordingCinematicComponent.items$lambda$7(this, player, arg_0));
        return MapsKt.mapOf(TuplesKt.to(this.slot, item));
    }

    private static final Unit items$lambda$2$lambda$0(ItemMeta meta) {
        Intrinsics.checkNotNull(meta);
        ExtensionsKt.setName(meta, "<red><b>Cannot Start Recording");
        ExtensionsKt.setLoreString(meta, "<line> <gray>Recording cannot start \n<line> <gray>because the frame is out of range.\n\n<line> <gray>Make sure that the cinematic frame\n<line> <gray>is before the end frame of the segment.");
        return Unit.INSTANCE;
    }

    private static final void items$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit items$lambda$3(ItemInteraction it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final Unit items$lambda$6$lambda$4(ItemMeta meta) {
        Intrinsics.checkNotNull(meta);
        ExtensionsKt.setName(meta, "<green><b>Start Recording");
        ExtensionsKt.setLoreString(meta, "<line> <gray>Click to start recording the cinematic.");
        return Unit.INSTANCE;
    }

    private static final void items$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit items$lambda$7(RecordingCinematicComponent this$0, Player $player, ItemInteraction it) {
        Intrinsics.checkNotNullParameter(it, "it");
        TriggerEntryKt.triggerFor(new ContentModeTrigger(this$0.context, this$0.modeCreator.invoke(this$0.context, $player, this$0.frameFetcher.invoke(), this$0.klass)), $player);
        return Unit.INSTANCE;
    }
}

