/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.engine.paper.content.components;

import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.typewritermc.engine.paper.content.components.NodeDisplayBuilder;
import com.typewritermc.engine.paper.extensions.packetevents.PlayerPacketsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.tofaa.entitylib.meta.EntityMeta;
import me.tofaa.entitylib.meta.display.ItemDisplayMeta;
import me.tofaa.entitylib.meta.other.InteractionMeta;
import me.tofaa.entitylib.wrapper.WrapperEntity;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010\u0017\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/typewritermc/engine/paper/content/components/NodeDisplay;", "", "<init>", "()V", "itemDisplay", "Lme/tofaa/entitylib/wrapper/WrapperEntity;", "interaction", "onInteract", "Lkotlin/Function0;", "", "entityId", "", "getEntityId", "()I", "apply", "builder", "Lcom/typewritermc/engine/paper/content/components/NodeDisplayBuilder;", "location", "Lorg/bukkit/Location;", "show", "player", "Lorg/bukkit/entity/Player;", "interact", "dispose", "engine-paper"})
@SourceDebugExtension(value={"SMAP\nNodesComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodesComponent.kt\ncom/typewritermc/engine/paper/content/components/NodeDisplay\n+ 2 PlayerPackets.kt\ncom/typewritermc/engine/paper/extensions/packetevents/PlayerPacketsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n48#2,11:161\n48#2,11:172\n1#3:183\n*S KotlinDebug\n*F\n+ 1 NodesComponent.kt\ncom/typewritermc/engine/paper/content/components/NodeDisplay\n*L\n116#1:161,11\n123#1:172,11\n*E\n"})
final class NodeDisplay {
    @NotNull
    private final WrapperEntity itemDisplay = new WrapperEntity(EntityTypes.ITEM_DISPLAY);
    @NotNull
    private final WrapperEntity interaction = new WrapperEntity(EntityTypes.INTERACTION);
    @NotNull
    private Function0<Unit> onInteract = NodeDisplay::onInteract$lambda$0;

    public final int getEntityId() {
        return this.interaction.getEntityId();
    }

    /*
     * WARNING - void declaration
     */
    public final void apply(@NotNull NodeDisplayBuilder builder, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(location, "location");
        WrapperEntity $this$meta_u24default$iv = this.itemDisplay;
        boolean preventNotification$iv = false;
        boolean $i$f$meta = false;
        EntityMeta meta$iv = $this$meta_u24default$iv.getEntityMeta();
        if (meta$iv instanceof ItemDisplayMeta) {
            meta$iv.setNotifyAboutChanges(false);
            ItemDisplayMeta $this$apply_u24lambda_u241 = (ItemDisplayMeta)meta$iv;
            boolean bl = false;
            $this$apply_u24lambda_u241.setItem(PlayerPacketsKt.toPacketItem(builder.getItem()));
            $this$apply_u24lambda_u241.setGlowing(builder.getGlow() != null);
            TextColor textColor = builder.getGlow();
            $this$apply_u24lambda_u241.setGlowColorOverride(textColor != null ? textColor.value() : -1);
            $this$apply_u24lambda_u241.setScale(builder.getScale());
            $this$apply_u24lambda_u241.setPositionRotationInterpolationDuration(30);
            meta$iv.setNotifyAboutChanges(true);
        }
        $this$meta_u24default$iv = this.interaction;
        preventNotification$iv = false;
        $i$f$meta = false;
        meta$iv = $this$meta_u24default$iv.getEntityMeta();
        if (meta$iv instanceof InteractionMeta) {
            meta$iv.setNotifyAboutChanges(false);
            InteractionMeta $this$apply_u24lambda_u242 = (InteractionMeta)meta$iv;
            boolean bl = false;
            $this$apply_u24lambda_u242.setWidth(Math.max(builder.getScale().x, builder.getScale().z));
            $this$apply_u24lambda_u242.setHeight(builder.getScale().y);
            meta$iv.setNotifyAboutChanges(true);
        }
        this.onInteract = builder.getInteraction();
        if (this.itemDisplay.isSpawned()) {
            this.itemDisplay.teleport(PlayerPacketsKt.toPacketLocation(location));
        }
        if (!(!this.interaction.isSpawned() || this.interaction.getLocation().getX() == location.getX() && this.interaction.getLocation().getY() == location.getY() - (double)(builder.getScale().y / (float)2) && this.interaction.getLocation().getZ() == location.getZ())) {
            void $this$apply_u24lambda_u243;
            Location location2;
            Location $i$f$meta2 = location2 = location.clone();
            WrapperEntity wrapperEntity = this.interaction;
            boolean bl = false;
            $this$apply_u24lambda_u243.setY($this$apply_u24lambda_u243.getY() - (double)(builder.getScale().y / (float)2));
            Location location3 = location2;
            Intrinsics.checkNotNullExpressionValue(location3, "apply(...)");
            wrapperEntity.teleport(PlayerPacketsKt.toPacketLocation(location3));
        }
    }

    public final void show(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        this.itemDisplay.addViewer(player.getUniqueId());
        this.itemDisplay.spawn(PlayerPacketsKt.toPacketLocation(location));
        this.interaction.addViewer(player.getUniqueId());
        this.interaction.spawn(PlayerPacketsKt.toPacketLocation(location));
    }

    public final void interact() {
        this.onInteract.invoke();
    }

    public final void dispose() {
        this.itemDisplay.despawn();
        this.itemDisplay.remove();
        this.interaction.despawn();
        this.interaction.remove();
    }

    private static final Unit onInteract$lambda$0() {
        return Unit.INSTANCE;
    }
}

