/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.core.utils.point;

import com.typewritermc.core.utils.point.Point;
import java.util.function.DoubleUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b!\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\b\u0012\u0006\u0010\u0005\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J \u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0001H\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0096\u0002J \u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0001H\u0016J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0096\u0002J \u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0001H\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0096\u0002J \u0010 \u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0096\u0002J\u0006\u0010!\u001a\u00020\u0000J \u0010\u0012\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0006\u0010$\u001a\u00020\u0000J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J'\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010)\u001a\u00020*2\b\u0010\u0013\u001a\u0004\u0018\u00010+H\u00d6\u0003J\t\u0010,\u001a\u00020\bH\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\u00a8\u00060"}, d2={"Lcom/typewritermc/core/utils/point/Vector;", "Lcom/typewritermc/core/utils/point/Point;", "x", "", "y", "z", "<init>", "(DDD)V", "", "(III)V", "getX", "()D", "getY", "getZ", "lengthSquared", "getLengthSquared", "length", "getLength", "lerp", "other", "alpha", "withX", "withY", "withZ", "add", "point", "value", "plus", "sub", "minus", "mul", "times", "div", "normalize", "a", "b", "mid", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "", "Companion", "engine-core"})
public final class Vector
implements Point {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double z;
    @NotNull
    private static final Vector ZERO = new Vector(0.0, 0.0, 0.0);
    @NotNull
    private static final Vector UNIT = new Vector(1.0, 1.0, 1.0);
    @Language(value="JSON")
    @NotNull
    public static final String UNIT_JSON = "{\"x\": 1.0, \"y\": 1.0, \"z\": 1.0}";
    public static final double EPSILON = 1.0E-6;

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public /* synthetic */ Vector(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        this(d, d2, d3);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    public Vector(int x, int y, int z) {
        this((double)x, (double)y, (double)z);
    }

    public final double getLengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
    }

    public final double getLength() {
        return Math.sqrt(this.getLengthSquared());
    }

    @NotNull
    public final Vector lerp(@NotNull Vector other, double alpha) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Vector(this.lerp(this.getX(), other.getX(), alpha), this.lerp(this.getY(), other.getY(), alpha), this.lerp(this.getZ(), other.getZ(), alpha));
    }

    @Override
    @NotNull
    public Vector withX(double x) {
        return Vector.copy$default(this, x, 0.0, 0.0, 6, null);
    }

    @Override
    @NotNull
    public Vector withY(double y) {
        return Vector.copy$default(this, 0.0, y, 0.0, 5, null);
    }

    @Override
    @NotNull
    public Vector withZ(double z) {
        return Vector.copy$default(this, 0.0, 0.0, z, 3, null);
    }

    @Override
    @NotNull
    public Vector add(double x, double y, double z) {
        return new Vector(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    @Override
    @NotNull
    public Vector add(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.add(point.getX(), point.getY(), point.getZ());
    }

    @Override
    @NotNull
    public Vector add(double value) {
        return this.add(value, value, value);
    }

    @Override
    @NotNull
    public Vector plus(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.add(point);
    }

    @Override
    @NotNull
    public Vector plus(double value) {
        return this.add(value);
    }

    @Override
    @NotNull
    public Vector sub(double x, double y, double z) {
        return new Vector(this.getX() - x, this.getY() - y, this.getZ() - z);
    }

    @Override
    @NotNull
    public Vector sub(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.sub(point.getX(), point.getY(), point.getZ());
    }

    @Override
    @NotNull
    public Vector sub(double value) {
        return this.sub(value, value, value);
    }

    @Override
    @NotNull
    public Vector minus(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.sub(point);
    }

    @Override
    @NotNull
    public Vector minus(double value) {
        return this.sub(value);
    }

    @Override
    @NotNull
    public Vector mul(double x, double y, double z) {
        return new Vector(this.getX() * x, this.getY() * y, this.getZ() * z);
    }

    @Override
    @NotNull
    public Vector mul(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.mul(point.getX(), point.getY(), point.getZ());
    }

    @Override
    @NotNull
    public Vector mul(double value) {
        return this.mul(value, value, value);
    }

    @Override
    @NotNull
    public Vector times(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.mul(point);
    }

    @Override
    @NotNull
    public Vector times(double value) {
        return this.mul(value);
    }

    @Override
    @NotNull
    public Vector div(double x, double y, double z) {
        return new Vector(this.getX() / x, this.getY() / y, this.getZ() / z);
    }

    @Override
    @NotNull
    public Vector div(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.div(point.getX(), point.getY(), point.getZ());
    }

    @Override
    @NotNull
    public Vector div(double value) {
        return this.div(value, value, value);
    }

    @NotNull
    public final Vector normalize() {
        double length = this.getLength();
        return length < 1.0E-6 ? ZERO : this.div(length);
    }

    private final double lerp(double a, double b, double alpha) {
        return a + alpha * (b - a);
    }

    @NotNull
    public final Vector mid() {
        return new Vector((double)((int)this.getX()) + 0.5, (double)((int)this.getY()), (double)((int)this.getZ()) + 0.5);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final Vector copy(double x, double y, double z) {
        return new Vector(x, y, z);
    }

    public static /* synthetic */ Vector copy$default(Vector vector, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector.x;
        }
        if ((n & 2) != 0) {
            d2 = vector.y;
        }
        if ((n & 4) != 0) {
            d3 = vector.z;
        }
        return vector.copy(d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "Vector(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        result = result * 31 + Double.hashCode(this.z);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector)) {
            return false;
        }
        Vector vector = (Vector)other;
        if (Double.compare(this.x, vector.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, vector.y) != 0) {
            return false;
        }
        return Double.compare(this.z, vector.z) == 0;
    }

    @Override
    public int getBlockX() {
        return Point.DefaultImpls.getBlockX(this);
    }

    @Override
    public int getBlockY() {
        return Point.DefaultImpls.getBlockY(this);
    }

    @Override
    public int getBlockZ() {
        return Point.DefaultImpls.getBlockZ(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Point withX(@NotNull DoubleUnaryOperator operator) {
        return Point.DefaultImpls.withX(this, operator);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Point withY(@NotNull DoubleUnaryOperator operator) {
        return Point.DefaultImpls.withY(this, operator);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Point withZ(@NotNull DoubleUnaryOperator operator) {
        return Point.DefaultImpls.withZ(this, operator);
    }

    @Override
    @Contract(pure=true)
    public double distanceSquared(double x, double y, double z) {
        return Point.DefaultImpls.distanceSquared(this, x, y, z);
    }

    @Override
    @Contract(pure=true)
    public double distanceSquared(@NotNull Point point) {
        return Point.DefaultImpls.distanceSquared(this, point);
    }

    @Override
    @Contract(pure=true)
    public double distance(double x, double y, double z) {
        return Point.DefaultImpls.distance(this, x, y, z);
    }

    @Override
    @Contract(pure=true)
    public double distance(@NotNull Point point) {
        return Point.DefaultImpls.distance(this, point);
    }

    @Override
    public boolean samePoint(double x, double y, double z) {
        return Point.DefaultImpls.samePoint(this, x, y, z);
    }

    @Override
    public boolean samePoint(@NotNull Point point) {
        return Point.DefaultImpls.samePoint(this, point);
    }

    @Override
    public boolean isZero() {
        return Point.DefaultImpls.isZero(this);
    }

    @Override
    public boolean sameBlock(int blockX, int blockY, int blockZ) {
        return Point.DefaultImpls.sameBlock(this, blockX, blockY, blockZ);
    }

    @Override
    public boolean sameBlock(@NotNull Point point) {
        return Point.DefaultImpls.sameBlock(this, point);
    }

    @Override
    public boolean isInRange(@NotNull Point point, double range) {
        return Point.DefaultImpls.isInRange(this, point, range);
    }

    @Override
    public boolean isInRange(double x, double y, double z, double range) {
        return Point.DefaultImpls.isInRange(this, x, y, z, range);
    }

    public Vector() {
        this(0.0, 0.0, 0.0, 7, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/typewritermc/core/utils/point/Vector$Companion;", "", "<init>", "()V", "ZERO", "Lcom/typewritermc/core/utils/point/Vector;", "getZERO", "()Lcom/typewritermc/core/utils/point/Vector;", "UNIT", "getUNIT", "UNIT_JSON", "", "EPSILON", "", "engine-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector getZERO() {
            return ZERO;
        }

        @NotNull
        public final Vector getUNIT() {
            return UNIT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

