/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.core.utils.point;

import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.PointKt;
import com.typewritermc.core.utils.point.Rotatable;
import com.typewritermc.core.utils.point.Vector;
import com.typewritermc.core.utils.point.World;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 82\u00020\u00012\u00020\u0002:\u00018BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0018\u0010\u001f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J \u0010 \u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0001H\u0016J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0016J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0096\u0002J \u0010$\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0001H\u0016J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0016J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0096\u0002J \u0010&\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0001H\u0016J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0016J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0096\u0002J \u0010(\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0011\u0010(\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010(\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0006H\u0096\u0002J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0001H\u0016J\b\u0010*\u001a\u00020\u0000H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0016\u0010-\u001a\u00020.2\u0006\u0010!\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0006JD\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0016J\u0013\u00101\u001a\u00020.2\b\u00102\u001a\u0004\u0018\u000103H\u0096\u0002J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000207H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0014\u0010\b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u00069"}, d2={"Lcom/typewritermc/core/utils/point/Position;", "Lcom/typewritermc/core/utils/point/Point;", "Lcom/typewritermc/core/utils/point/Rotatable;", "world", "Lcom/typewritermc/core/utils/point/World;", "x", "", "y", "z", "yaw", "", "pitch", "<init>", "(Lcom/typewritermc/core/utils/point/World;DDDFF)V", "getWorld", "()Lcom/typewritermc/core/utils/point/World;", "getX", "()D", "getY", "getZ", "getYaw", "()F", "getPitch", "withX", "withY", "withZ", "withYaw", "withPitch", "rotateYaw", "angle", "rotatePitch", "rotate", "add", "point", "value", "plus", "sub", "minus", "mul", "times", "div", "lookAt", "resetRotation", "directionVector", "Lcom/typewritermc/core/utils/point/Vector;", "isInRange", "", "range", "copy", "equals", "other", "", "hashCode", "", "toString", "", "Companion", "engine-core"})
public class Position
implements Point,
Rotatable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;
    @NotNull
    private static final Position ORIGIN = new Position(new World(""), 0.0, 0.0, 0.0, 0.0f, 0.0f);

    public Position(@NotNull World world, double x, double y, double z, float yaw, float pitch) {
        Intrinsics.checkNotNullParameter(world, "world");
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public /* synthetic */ Position(World world, double d, double d2, double d3, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x10) != 0) {
            f = 0.0f;
        }
        if ((n & 0x20) != 0) {
            f2 = 0.0f;
        }
        this(world, d, d2, d3, f, f2);
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Override
    @NotNull
    public Position withX(double x) {
        return Position.copy$default(this, null, x, 0.0, 0.0, 0.0f, 0.0f, 61, null);
    }

    @Override
    @NotNull
    public Position withY(double y) {
        return Position.copy$default(this, null, 0.0, y, 0.0, 0.0f, 0.0f, 59, null);
    }

    @Override
    @NotNull
    public Position withZ(double z) {
        return Position.copy$default(this, null, 0.0, 0.0, z, 0.0f, 0.0f, 55, null);
    }

    @Override
    @NotNull
    public Position withYaw(float yaw) {
        return Position.copy$default(this, null, 0.0, 0.0, 0.0, yaw, 0.0f, 47, null);
    }

    @Override
    @NotNull
    public Position withPitch(float pitch) {
        return Position.copy$default(this, null, 0.0, 0.0, 0.0, 0.0f, pitch, 31, null);
    }

    @Override
    @NotNull
    public Position rotateYaw(float angle) {
        return Position.copy$default(this, null, 0.0, 0.0, 0.0, this.getYaw() + angle, 0.0f, 47, null);
    }

    @Override
    @NotNull
    public Position rotatePitch(float angle) {
        return Position.copy$default(this, null, 0.0, 0.0, 0.0, 0.0f, this.getPitch() + angle, 31, null);
    }

    @Override
    @NotNull
    public Position rotate(float yaw, float pitch) {
        return Position.copy$default(this, null, 0.0, 0.0, 0.0, this.getYaw() + yaw, this.getPitch() + pitch, 15, null);
    }

    @Override
    @NotNull
    public Position add(double x, double y, double z) {
        return Position.copy$default(this, null, this.getX() + x, this.getY() + y, this.getZ() + z, 0.0f, 0.0f, 49, null);
    }

    @Override
    @NotNull
    public Position add(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.add(point.getX(), point.getY(), point.getZ());
    }

    @Override
    @NotNull
    public Position add(double value) {
        return this.add(value, value, value);
    }

    @Override
    @NotNull
    public Position plus(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.add(point);
    }

    @Override
    @NotNull
    public Position plus(double value) {
        return this.add(value);
    }

    @Override
    @NotNull
    public Position sub(double x, double y, double z) {
        return Position.copy$default(this, null, this.getX() - x, this.getY() - y, this.getZ() - z, 0.0f, 0.0f, 49, null);
    }

    @Override
    @NotNull
    public Position sub(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.sub(point.getX(), point.getY(), point.getZ());
    }

    @Override
    @NotNull
    public Position sub(double value) {
        return this.sub(value, value, value);
    }

    @Override
    @NotNull
    public Position minus(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.sub(point);
    }

    @Override
    @NotNull
    public Position minus(double value) {
        return this.sub(value);
    }

    @Override
    @NotNull
    public Position mul(double x, double y, double z) {
        return Position.copy$default(this, null, this.getX() * x, this.getY() * y, this.getZ() * z, 0.0f, 0.0f, 49, null);
    }

    @Override
    @NotNull
    public Position mul(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.mul(point.getX(), point.getY(), point.getZ());
    }

    @Override
    @NotNull
    public Position mul(double value) {
        return this.mul(value, value, value);
    }

    @Override
    @NotNull
    public Position times(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.mul(point);
    }

    @Override
    @NotNull
    public Position times(double value) {
        return this.mul(value);
    }

    @Override
    @NotNull
    public Position div(double x, double y, double z) {
        return Position.copy$default(this, null, this.getX() / x, this.getY() / y, this.getZ() / z, 0.0f, 0.0f, 49, null);
    }

    @Override
    @NotNull
    public Position div(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.div(point.getX(), point.getY(), point.getZ());
    }

    @Override
    @NotNull
    public Position div(double value) {
        return this.div(value, value, value);
    }

    @Override
    @NotNull
    public Position lookAt(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        double x = point.getX() - this.getX();
        double y = point.getY() - this.getY();
        double z = point.getZ() - this.getZ();
        float yaw = (float)Math.toDegrees(Math.atan2(x, z));
        float pitch = (float)Math.toDegrees(Math.atan2(y, Math.sqrt(PointKt.squared(x) + PointKt.squared(z))));
        return Position.copy$default(this, null, 0.0, 0.0, 0.0, yaw, pitch, 15, null);
    }

    @Override
    @NotNull
    public Position resetRotation() {
        return Position.copy$default(this, null, 0.0, 0.0, 0.0, 0.0f, 0.0f, 15, null);
    }

    @Override
    @NotNull
    public Vector directionVector() {
        double radYaw = Math.toRadians(this.getYaw());
        double radPitch = Math.toRadians(this.getPitch());
        double x = -Math.cos(radPitch) * Math.sin(radYaw);
        double y = -Math.sin(radPitch);
        double z = Math.cos(radPitch) * Math.cos(radYaw);
        return new Vector(x, y, z);
    }

    public final boolean isInRange(@NotNull Position point, double range) {
        Intrinsics.checkNotNullParameter(point, "point");
        if (!Intrinsics.areEqual(this.world, point.world)) {
            return false;
        }
        return this.isInRange(point.getX(), point.getY(), point.getZ(), range);
    }

    @NotNull
    public Position copy(@NotNull World world, double x, double y, double z, float yaw, float pitch) {
        Intrinsics.checkNotNullParameter(world, "world");
        return new Position(world, x, y, z, yaw, pitch);
    }

    public static /* synthetic */ Position copy$default(Position position, World world, double d, double d2, double d3, float f, float f2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 1) != 0) {
            world = position.world;
        }
        if ((n & 2) != 0) {
            d = position.getX();
        }
        if ((n & 4) != 0) {
            d2 = position.getY();
        }
        if ((n & 8) != 0) {
            d3 = position.getZ();
        }
        if ((n & 0x10) != 0) {
            f = position.getYaw();
        }
        if ((n & 0x20) != 0) {
            f2 = position.getPitch();
        }
        return position.copy(world, d, d2, d3, f, f2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Position)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.world, ((Position)other).world)) {
            return false;
        }
        if (!(this.getX() == ((Position)other).getX())) {
            return false;
        }
        if (!(this.getY() == ((Position)other).getY())) {
            return false;
        }
        if (!(this.getZ() == ((Position)other).getZ())) {
            return false;
        }
        if (!(this.getYaw() == ((Position)other).getYaw())) {
            return false;
        }
        return this.getPitch() == ((Position)other).getPitch();
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.world, this.getX(), this.getY(), this.getZ(), Float.valueOf(this.getYaw()), Float.valueOf(this.getPitch())};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "Position(world=" + this.world + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }

    @Override
    public int getBlockX() {
        return Point.DefaultImpls.getBlockX(this);
    }

    @Override
    public int getBlockY() {
        return Point.DefaultImpls.getBlockY(this);
    }

    @Override
    public int getBlockZ() {
        return Point.DefaultImpls.getBlockZ(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Point withX(@NotNull DoubleUnaryOperator operator) {
        return Point.DefaultImpls.withX(this, operator);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Point withY(@NotNull DoubleUnaryOperator operator) {
        return Point.DefaultImpls.withY(this, operator);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Point withZ(@NotNull DoubleUnaryOperator operator) {
        return Point.DefaultImpls.withZ(this, operator);
    }

    @Override
    @Contract(pure=true)
    public double distanceSquared(double x, double y, double z) {
        return Point.DefaultImpls.distanceSquared(this, x, y, z);
    }

    @Override
    @Contract(pure=true)
    public double distanceSquared(@NotNull Point point) {
        return Point.DefaultImpls.distanceSquared(this, point);
    }

    @Override
    @Contract(pure=true)
    public double distance(double x, double y, double z) {
        return Point.DefaultImpls.distance(this, x, y, z);
    }

    @Override
    @Contract(pure=true)
    public double distance(@NotNull Point point) {
        return Point.DefaultImpls.distance(this, point);
    }

    @Override
    public boolean samePoint(double x, double y, double z) {
        return Point.DefaultImpls.samePoint(this, x, y, z);
    }

    @Override
    public boolean samePoint(@NotNull Point point) {
        return Point.DefaultImpls.samePoint(this, point);
    }

    @Override
    public boolean isZero() {
        return Point.DefaultImpls.isZero(this);
    }

    @Override
    public boolean sameBlock(int blockX, int blockY, int blockZ) {
        return Point.DefaultImpls.sameBlock(this, blockX, blockY, blockZ);
    }

    @Override
    public boolean sameBlock(@NotNull Point point) {
        return Point.DefaultImpls.sameBlock(this, point);
    }

    @Override
    public boolean isInRange(@NotNull Point point, double range) {
        return Point.DefaultImpls.isInRange(this, point, range);
    }

    @Override
    public boolean isInRange(double x, double y, double z, double range) {
        return Point.DefaultImpls.isInRange(this, x, y, z, range);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/typewritermc/core/utils/point/Position$Companion;", "", "<init>", "()V", "ORIGIN", "Lcom/typewritermc/core/utils/point/Position;", "getORIGIN", "()Lcom/typewritermc/core/utils/point/Position;", "engine-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Position getORIGIN() {
            return ORIGIN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

