/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.core.utils.point;

import com.typewritermc.core.utils.point.PointKt;
import java.util.function.DoubleUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H'J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0003H'J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0003H'J&\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H'J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H'J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u00a6\u0002J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H'J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u00a6\u0002J&\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H'J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H'J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u00a6\u0002J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H'J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u00a6\u0002J&\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H'J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H'J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u00a6\u0002J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H'J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u00a6\u0002J&\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H'J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u00a7\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u00a7\u0002J \u0010 \u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0017J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0000H\u0017J \u0010!\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0017J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0000H\u0017J \u0010\"\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u0000H\u0016J \u0010&\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010&\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u0000H\u0016J\u0018\u0010'\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0003H\u0016J(\u0010'\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0014\u0010$\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lcom/typewritermc/core/utils/point/Point;", "", "x", "", "getX", "()D", "y", "getY", "z", "getZ", "blockX", "", "getBlockX", "()I", "blockY", "getBlockY", "blockZ", "getBlockZ", "withX", "operator", "Ljava/util/function/DoubleUnaryOperator;", "withY", "withZ", "add", "point", "plus", "value", "sub", "minus", "mul", "times", "div", "distanceSquared", "distance", "samePoint", "", "isZero", "()Z", "sameBlock", "isInRange", "range", "engine-core"})
public interface Point {
    public double getX();

    public double getY();

    public double getZ();

    public int getBlockX();

    public int getBlockY();

    public int getBlockZ();

    @Contract(pure=true)
    @NotNull
    public Point withX(@NotNull DoubleUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public Point withX(double var1);

    @Contract(pure=true)
    @NotNull
    public Point withY(@NotNull DoubleUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public Point withY(double var1);

    @Contract(pure=true)
    @NotNull
    public Point withZ(@NotNull DoubleUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public Point withZ(double var1);

    @Contract(pure=true)
    @NotNull
    public Point add(double var1, double var3, double var5);

    @Contract(pure=true)
    @NotNull
    public Point add(@NotNull Point var1);

    @NotNull
    public Point plus(@NotNull Point var1);

    @Contract(pure=true)
    @NotNull
    public Point add(double var1);

    @NotNull
    public Point plus(double var1);

    @Contract(pure=true)
    @NotNull
    public Point sub(double var1, double var3, double var5);

    @Contract(pure=true)
    @NotNull
    public Point sub(@NotNull Point var1);

    @NotNull
    public Point minus(@NotNull Point var1);

    @Contract(pure=true)
    @NotNull
    public Point sub(double var1);

    @NotNull
    public Point minus(double var1);

    @Contract(pure=true)
    @NotNull
    public Point mul(double var1, double var3, double var5);

    @Contract(pure=true)
    @NotNull
    public Point mul(@NotNull Point var1);

    @NotNull
    public Point times(@NotNull Point var1);

    @Contract(pure=true)
    @NotNull
    public Point mul(double var1);

    @NotNull
    public Point times(double var1);

    @Contract(pure=true)
    @NotNull
    public Point div(double var1, double var3, double var5);

    @Contract(pure=true)
    @NotNull
    public Point div(@NotNull Point var1);

    @Contract(pure=true)
    @NotNull
    public Point div(double var1);

    @Contract(pure=true)
    public double distanceSquared(double var1, double var3, double var5);

    @Contract(pure=true)
    public double distanceSquared(@NotNull Point var1);

    @Contract(pure=true)
    public double distance(double var1, double var3, double var5);

    @Contract(pure=true)
    public double distance(@NotNull Point var1);

    public boolean samePoint(double var1, double var3, double var5);

    public boolean samePoint(@NotNull Point var1);

    public boolean isZero();

    public boolean sameBlock(int var1, int var2, int var3);

    public boolean sameBlock(@NotNull Point var1);

    public boolean isInRange(@NotNull Point var1, double var2);

    public boolean isInRange(double var1, double var3, double var5, double var7);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static int getBlockX(@NotNull Point $this) {
            return (int)Math.floor($this.getX());
        }

        public static int getBlockY(@NotNull Point $this) {
            return (int)Math.floor($this.getY());
        }

        public static int getBlockZ(@NotNull Point $this) {
            return (int)Math.floor($this.getZ());
        }

        @Contract(pure=true)
        @NotNull
        public static Point withX(@NotNull Point $this, @NotNull DoubleUnaryOperator operator) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            return $this.withX(operator.applyAsDouble($this.getX()));
        }

        @Contract(pure=true)
        @NotNull
        public static Point withY(@NotNull Point $this, @NotNull DoubleUnaryOperator operator) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            return $this.withY(operator.applyAsDouble($this.getY()));
        }

        @Contract(pure=true)
        @NotNull
        public static Point withZ(@NotNull Point $this, @NotNull DoubleUnaryOperator operator) {
            Intrinsics.checkNotNullParameter(operator, "operator");
            return $this.withZ(operator.applyAsDouble($this.getZ()));
        }

        public static /* synthetic */ Point add$default(Point point, double d, double d2, double d3, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
            }
            if ((n & 1) != 0) {
                d = 0.0;
            }
            if ((n & 2) != 0) {
                d2 = 0.0;
            }
            if ((n & 4) != 0) {
                d3 = 0.0;
            }
            return point.add(d, d2, d3);
        }

        public static /* synthetic */ Point sub$default(Point point, double d, double d2, double d3, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sub");
            }
            if ((n & 1) != 0) {
                d = 0.0;
            }
            if ((n & 2) != 0) {
                d2 = 0.0;
            }
            if ((n & 4) != 0) {
                d3 = 0.0;
            }
            return point.sub(d, d2, d3);
        }

        public static /* synthetic */ Point mul$default(Point point, double d, double d2, double d3, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: mul");
            }
            if ((n & 1) != 0) {
                d = 1.0;
            }
            if ((n & 2) != 0) {
                d2 = 1.0;
            }
            if ((n & 4) != 0) {
                d3 = 1.0;
            }
            return point.mul(d, d2, d3);
        }

        public static /* synthetic */ Point div$default(Point point, double d, double d2, double d3, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: div");
            }
            if ((n & 1) != 0) {
                d = 1.0;
            }
            if ((n & 2) != 0) {
                d2 = 1.0;
            }
            if ((n & 4) != 0) {
                d3 = 1.0;
            }
            return point.div(d, d2, d3);
        }

        @Contract(pure=true)
        public static double distanceSquared(@NotNull Point $this, double x, double y, double z) {
            return PointKt.squared($this.getX() - x) + PointKt.squared($this.getY() - y) + PointKt.squared($this.getZ() - z);
        }

        @Contract(pure=true)
        public static double distanceSquared(@NotNull Point $this, @NotNull Point point) {
            Intrinsics.checkNotNullParameter(point, "point");
            return $this.distanceSquared(point.getX(), point.getY(), point.getZ());
        }

        @Contract(pure=true)
        public static double distance(@NotNull Point $this, double x, double y, double z) {
            return Math.sqrt($this.distanceSquared(x, y, z));
        }

        @Contract(pure=true)
        public static double distance(@NotNull Point $this, @NotNull Point point) {
            Intrinsics.checkNotNullParameter(point, "point");
            return $this.distance(point.getX(), point.getY(), point.getZ());
        }

        public static boolean samePoint(@NotNull Point $this, double x, double y, double z) {
            return Double.compare(x, $this.getX()) == 0 && Double.compare(y, $this.getY()) == 0 && Double.compare(z, $this.getZ()) == 0;
        }

        public static boolean samePoint(@NotNull Point $this, @NotNull Point point) {
            Intrinsics.checkNotNullParameter(point, "point");
            return $this.samePoint(point.getX(), point.getY(), point.getZ());
        }

        public static boolean isZero(@NotNull Point $this) {
            return $this.getX() == 0.0 && $this.getY() == 0.0 && $this.getZ() == 0.0;
        }

        public static boolean sameBlock(@NotNull Point $this, int blockX, int blockY, int blockZ) {
            return $this.getBlockX() == blockX && $this.getBlockY() == blockY && $this.getBlockZ() == blockZ;
        }

        public static boolean sameBlock(@NotNull Point $this, @NotNull Point point) {
            Intrinsics.checkNotNullParameter(point, "point");
            return $this.sameBlock(point.getBlockX(), point.getBlockY(), point.getBlockZ());
        }

        public static boolean isInRange(@NotNull Point $this, @NotNull Point point, double range) {
            Intrinsics.checkNotNullParameter(point, "point");
            return $this.isInRange(point.getX(), point.getY(), point.getZ(), range);
        }

        public static boolean isInRange(@NotNull Point $this, double x, double y, double z, double range) {
            return $this.distanceSquared(x, y, z) <= range * range;
        }
    }
}

