/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.core.utils.point;

import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.PointKt;
import com.typewritermc.core.utils.point.Rotatable;
import com.typewritermc.core.utils.point.Vector;
import java.util.function.DoubleUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B9\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0018\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J \u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0016J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0004H\u0096\u0002J \u0010 \u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0016J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0004H\u0096\u0002J \u0010\"\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0016J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0004H\u0096\u0002J \u0010$\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0004H\u0096\u0002J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0016J\b\u0010&\u001a\u00020\u0000H\u0016J\b\u0010'\u001a\u00020(H\u0016J\t\u0010)\u001a\u00020\u0004H\u00c6\u0003J\t\u0010*\u001a\u00020\u0004H\u00c6\u0003J\t\u0010+\u001a\u00020\u0004H\u00c6\u0003J\t\u0010,\u001a\u00020\bH\u00c6\u0003J\t\u0010-\u001a\u00020\bH\u00c6\u0003J;\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u00d6\u0003J\t\u00103\u001a\u000204H\u00d6\u0001J\t\u00105\u001a\u000206H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u00068"}, d2={"Lcom/typewritermc/core/utils/point/Coordinate;", "Lcom/typewritermc/core/utils/point/Point;", "Lcom/typewritermc/core/utils/point/Rotatable;", "x", "", "y", "z", "yaw", "", "pitch", "<init>", "(DDDFF)V", "getX", "()D", "getY", "getZ", "getYaw", "()F", "getPitch", "withX", "withY", "withZ", "withYaw", "withPitch", "rotateYaw", "angle", "rotatePitch", "rotate", "add", "point", "value", "plus", "sub", "minus", "mul", "times", "div", "lookAt", "resetRotation", "directionVector", "Lcom/typewritermc/core/utils/point/Vector;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "engine-core"})
public final class Coordinate
implements Point,
Rotatable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;
    @NotNull
    private static final Coordinate ORIGIN = new Coordinate(0.0, 0.0, 0.0, 0.0f, 0.0f);

    public Coordinate(double x, double y, double z, float yaw, float pitch) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public /* synthetic */ Coordinate(double d, double d2, double d3, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        if ((n & 8) != 0) {
            f = 0.0f;
        }
        if ((n & 0x10) != 0) {
            f2 = 0.0f;
        }
        this(d, d2, d3, f, f2);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Override
    @NotNull
    public Coordinate withX(double x) {
        return Coordinate.copy$default(this, x, 0.0, 0.0, 0.0f, 0.0f, 30, null);
    }

    @Override
    @NotNull
    public Coordinate withY(double y) {
        return Coordinate.copy$default(this, 0.0, y, 0.0, 0.0f, 0.0f, 29, null);
    }

    @Override
    @NotNull
    public Coordinate withZ(double z) {
        return Coordinate.copy$default(this, 0.0, 0.0, z, 0.0f, 0.0f, 27, null);
    }

    @Override
    @NotNull
    public Coordinate withYaw(float yaw) {
        return Coordinate.copy$default(this, 0.0, 0.0, 0.0, yaw, 0.0f, 23, null);
    }

    @Override
    @NotNull
    public Coordinate withPitch(float pitch) {
        return Coordinate.copy$default(this, 0.0, 0.0, 0.0, 0.0f, pitch, 15, null);
    }

    @Override
    @NotNull
    public Coordinate rotateYaw(float angle) {
        return Coordinate.copy$default(this, 0.0, 0.0, 0.0, this.getYaw() + angle, 0.0f, 23, null);
    }

    @Override
    @NotNull
    public Coordinate rotatePitch(float angle) {
        return Coordinate.copy$default(this, 0.0, 0.0, 0.0, 0.0f, this.getPitch() + angle, 15, null);
    }

    @Override
    @NotNull
    public Coordinate rotate(float yaw, float pitch) {
        return Coordinate.copy$default(this, 0.0, 0.0, 0.0, this.getYaw() + yaw, this.getPitch() + pitch, 7, null);
    }

    @Override
    @NotNull
    public Coordinate add(double x, double y, double z) {
        return Coordinate.copy$default(this, this.getX() + x, this.getY() + y, this.getZ() + z, 0.0f, 0.0f, 24, null);
    }

    @Override
    @NotNull
    public Coordinate add(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.add(point.getX(), point.getY(), point.getZ());
    }

    @Override
    @NotNull
    public Coordinate add(double value) {
        return this.add(value, value, value);
    }

    @Override
    @NotNull
    public Coordinate plus(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.add(point);
    }

    @Override
    @NotNull
    public Coordinate plus(double value) {
        return this.add(value);
    }

    @Override
    @NotNull
    public Coordinate sub(double x, double y, double z) {
        return Coordinate.copy$default(this, this.getX() - x, this.getY() - y, this.getZ() - z, 0.0f, 0.0f, 24, null);
    }

    @Override
    @NotNull
    public Coordinate sub(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.sub(point.getX(), point.getY(), point.getZ());
    }

    @Override
    @NotNull
    public Coordinate sub(double value) {
        return this.sub(value, value, value);
    }

    @Override
    @NotNull
    public Coordinate minus(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.sub(point);
    }

    @Override
    @NotNull
    public Coordinate minus(double value) {
        return this.sub(value);
    }

    @Override
    @NotNull
    public Coordinate mul(double x, double y, double z) {
        return Coordinate.copy$default(this, this.getX() * x, this.getY() * y, this.getZ() * z, 0.0f, 0.0f, 24, null);
    }

    @Override
    @NotNull
    public Coordinate mul(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.mul(point.getX(), point.getY(), point.getZ());
    }

    @Override
    @NotNull
    public Coordinate mul(double value) {
        return this.mul(value, value, value);
    }

    @Override
    @NotNull
    public Coordinate times(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.mul(point);
    }

    @Override
    @NotNull
    public Coordinate times(double value) {
        return this.mul(value);
    }

    @Override
    @NotNull
    public Coordinate div(double x, double y, double z) {
        return Coordinate.copy$default(this, this.getX() / x, this.getY() / y, this.getZ() / z, 0.0f, 0.0f, 24, null);
    }

    @Override
    @NotNull
    public Coordinate div(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return this.div(point.getX(), point.getY(), point.getZ());
    }

    @Override
    @NotNull
    public Coordinate div(double value) {
        return this.div(value, value, value);
    }

    @Override
    @NotNull
    public Coordinate lookAt(@NotNull Point point) {
        Intrinsics.checkNotNullParameter(point, "point");
        double x = point.getX() - this.getX();
        double y = point.getY() - this.getY();
        double z = point.getZ() - this.getZ();
        float yaw = (float)Math.toDegrees(Math.atan2(x, z));
        float pitch = (float)Math.toDegrees(Math.atan2(y, Math.sqrt(PointKt.squared(x) + PointKt.squared(z))));
        return Coordinate.copy$default(this, 0.0, 0.0, 0.0, yaw, pitch, 7, null);
    }

    @Override
    @NotNull
    public Coordinate resetRotation() {
        return Coordinate.copy$default(this, 0.0, 0.0, 0.0, 0.0f, 0.0f, 7, null);
    }

    @Override
    @NotNull
    public Vector directionVector() {
        double radYaw = Math.toRadians(this.getYaw());
        double radPitch = Math.toRadians(this.getPitch());
        double x = -Math.cos(radPitch) * Math.sin(radYaw);
        double y = -Math.sin(radPitch);
        double z = Math.cos(radPitch) * Math.cos(radYaw);
        return new Vector(x, y, z);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    public final float component4() {
        return this.yaw;
    }

    public final float component5() {
        return this.pitch;
    }

    @NotNull
    public final Coordinate copy(double x, double y, double z, float yaw, float pitch) {
        return new Coordinate(x, y, z, yaw, pitch);
    }

    public static /* synthetic */ Coordinate copy$default(Coordinate coordinate, double d, double d2, double d3, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            d = coordinate.x;
        }
        if ((n & 2) != 0) {
            d2 = coordinate.y;
        }
        if ((n & 4) != 0) {
            d3 = coordinate.z;
        }
        if ((n & 8) != 0) {
            f = coordinate.yaw;
        }
        if ((n & 0x10) != 0) {
            f2 = coordinate.pitch;
        }
        return coordinate.copy(d, d2, d3, f, f2);
    }

    @NotNull
    public String toString() {
        return "Coordinate(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        result = result * 31 + Double.hashCode(this.z);
        result = result * 31 + Float.hashCode(this.yaw);
        result = result * 31 + Float.hashCode(this.pitch);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Coordinate)) {
            return false;
        }
        Coordinate coordinate = (Coordinate)other;
        if (Double.compare(this.x, coordinate.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, coordinate.y) != 0) {
            return false;
        }
        if (Double.compare(this.z, coordinate.z) != 0) {
            return false;
        }
        if (Float.compare(this.yaw, coordinate.yaw) != 0) {
            return false;
        }
        return Float.compare(this.pitch, coordinate.pitch) == 0;
    }

    @Override
    public int getBlockX() {
        return Point.DefaultImpls.getBlockX(this);
    }

    @Override
    public int getBlockY() {
        return Point.DefaultImpls.getBlockY(this);
    }

    @Override
    public int getBlockZ() {
        return Point.DefaultImpls.getBlockZ(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Point withX(@NotNull DoubleUnaryOperator operator) {
        return Point.DefaultImpls.withX(this, operator);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Point withY(@NotNull DoubleUnaryOperator operator) {
        return Point.DefaultImpls.withY(this, operator);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Point withZ(@NotNull DoubleUnaryOperator operator) {
        return Point.DefaultImpls.withZ(this, operator);
    }

    @Override
    @Contract(pure=true)
    public double distanceSquared(double x, double y, double z) {
        return Point.DefaultImpls.distanceSquared(this, x, y, z);
    }

    @Override
    @Contract(pure=true)
    public double distanceSquared(@NotNull Point point) {
        return Point.DefaultImpls.distanceSquared(this, point);
    }

    @Override
    @Contract(pure=true)
    public double distance(double x, double y, double z) {
        return Point.DefaultImpls.distance(this, x, y, z);
    }

    @Override
    @Contract(pure=true)
    public double distance(@NotNull Point point) {
        return Point.DefaultImpls.distance(this, point);
    }

    @Override
    public boolean samePoint(double x, double y, double z) {
        return Point.DefaultImpls.samePoint(this, x, y, z);
    }

    @Override
    public boolean samePoint(@NotNull Point point) {
        return Point.DefaultImpls.samePoint(this, point);
    }

    @Override
    public boolean isZero() {
        return Point.DefaultImpls.isZero(this);
    }

    @Override
    public boolean sameBlock(int blockX, int blockY, int blockZ) {
        return Point.DefaultImpls.sameBlock(this, blockX, blockY, blockZ);
    }

    @Override
    public boolean sameBlock(@NotNull Point point) {
        return Point.DefaultImpls.sameBlock(this, point);
    }

    @Override
    public boolean isInRange(@NotNull Point point, double range) {
        return Point.DefaultImpls.isInRange(this, point, range);
    }

    @Override
    public boolean isInRange(double x, double y, double z, double range) {
        return Point.DefaultImpls.isInRange(this, x, y, z, range);
    }

    public Coordinate() {
        this(0.0, 0.0, 0.0, 0.0f, 0.0f, 31, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/typewritermc/core/utils/point/Coordinate$Companion;", "", "<init>", "()V", "ORIGIN", "Lcom/typewritermc/core/utils/point/Coordinate;", "getORIGIN", "()Lcom/typewritermc/core/utils/point/Coordinate;", "engine-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Coordinate getORIGIN() {
            return ORIGIN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

