/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.core.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.typewritermc.core.extension.annotations.AlgebraicTypeInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KAnnotatedElements;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00070\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/typewritermc/core/serialization/AlgebraicTypeAdapter;", "T", "", "Lcom/google/gson/TypeAdapter;", "gson", "Lcom/google/gson/Gson;", "klass", "Lkotlin/reflect/KClass;", "subclasses", "", "<init>", "(Lcom/google/gson/Gson;Lkotlin/reflect/KClass;Ljava/util/List;)V", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "(Lcom/google/gson/stream/JsonWriter;Ljava/lang/Object;)V", "read", "in", "Lcom/google/gson/stream/JsonReader;", "(Lcom/google/gson/stream/JsonReader;)Ljava/lang/Object;", "typeName", "", "getTypeName", "(Lkotlin/reflect/KClass;)Ljava/lang/String;", "engine-core"})
@SourceDebugExtension(value={"SMAP\nAlgebraicSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlgebraicSerialization.kt\ncom/typewritermc/core/serialization/AlgebraicTypeAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n295#2,2:59\n*S KotlinDebug\n*F\n+ 1 AlgebraicSerialization.kt\ncom/typewritermc/core/serialization/AlgebraicTypeAdapter\n*L\n47#1:59,2\n*E\n"})
final class AlgebraicTypeAdapter<T>
extends TypeAdapter<T> {
    @NotNull
    private final Gson gson;
    @NotNull
    private final KClass<T> klass;
    @NotNull
    private final List<KClass<? extends T>> subclasses;

    public AlgebraicTypeAdapter(@NotNull Gson gson, @NotNull KClass<T> klass, @NotNull List<? extends KClass<? extends T>> subclasses) {
        Intrinsics.checkNotNullParameter(gson, "gson");
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(subclasses, "subclasses");
        this.gson = gson;
        this.klass = klass;
        this.subclasses = subclasses;
    }

    public void write(@NotNull JsonWriter out2, @NotNull T value) {
        Intrinsics.checkNotNullParameter(out2, "out");
        Intrinsics.checkNotNullParameter(value, "value");
        out2.beginObject();
        out2.name("case");
        KClass klass = Reflection.getOrCreateKotlinClass(value.getClass());
        if (!this.subclasses.contains(klass)) {
            throw new IllegalArgumentException("Value of type " + klass.getQualifiedName() + " is not a valid value for " + this.klass.getQualifiedName());
        }
        String name = this.getTypeName(klass);
        out2.value(name);
        out2.name("value");
        Streams.write((JsonElement)this.gson.toJsonTree(value), (JsonWriter)out2);
        out2.endObject();
    }

    @NotNull
    public T read(@NotNull JsonReader in) {
        Object v1;
        String name;
        JsonElement element;
        block6: {
            Intrinsics.checkNotNullParameter(in, "in");
            element = Streams.parse((JsonReader)in);
            if (!(element instanceof JsonObject)) {
                throw new IllegalArgumentException("Expected JsonObject but got " + Reflection.getOrCreateKotlinClass(element.getClass()).getQualifiedName());
            }
            JsonElement jsonElement = ((JsonObject)element).get("case");
            if (jsonElement == null) {
                throw new IllegalArgumentException("Expected case but got null in " + element);
            }
            JsonElement jsonElement2 = jsonElement;
            if (!(jsonElement2 instanceof JsonPrimitive)) {
                throw new IllegalArgumentException("Expected JsonPrimitive but got " + Reflection.getOrCreateKotlinClass(jsonElement2.getClass()).getQualifiedName());
            }
            name = ((JsonPrimitive)jsonElement2).getAsString();
            Iterable $this$firstOrNull$iv = this.subclasses;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KClass it = (KClass)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(this.getTypeName(it), name)) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        KClass kClass = v1;
        if (kClass == null) {
            throw new IllegalArgumentException("Could not find subclass for " + name);
        }
        KClass klass = kClass;
        JsonElement jsonElement = ((JsonObject)element).get("value");
        if (jsonElement == null) {
            throw new IllegalArgumentException("Expected value but got null");
        }
        JsonElement value = jsonElement;
        Object object = this.gson.fromJson(value, JvmClassMappingKt.getJavaClass(klass));
        Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
        return (T)object;
    }

    private final String getTypeName(KClass<?> $this$typeName) {
        Object object = (AlgebraicTypeInfo)CollectionsKt.firstOrNull(KAnnotatedElements.findAnnotations($this$typeName, Reflection.getOrCreateKotlinClass(AlgebraicTypeInfo.class)));
        if (object == null || (object = object.name()) == null) {
            throw new IllegalArgumentException("Could not find `@AlgebraicTypeInfo` annotation for " + $this$typeName.getQualifiedName());
        }
        return object;
    }
}

