/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.linalg.mutable;

import com.extollit.linalg.ISpatialRegion;
import com.extollit.linalg.immutable.VertexOffset;
import com.extollit.linalg.mutable.Vec3d;
import java.text.MessageFormat;

public final class Vec3i
implements ISpatialRegion {
    public int x;
    public int y;
    public int z;

    public Vec3i(Vec3i copy2) {
        this.x = copy2.x;
        this.y = copy2.y;
        this.z = copy2.z;
    }

    public Vec3i(com.extollit.linalg.immutable.Vec3i copy2) {
        this.x = copy2.x;
        this.y = copy2.y;
        this.z = copy2.z;
    }

    public Vec3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3i(VertexOffset offset) {
        this.x = offset.dx;
        this.y = offset.dy;
        this.z = offset.dz;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec3i vec3i = (Vec3i)o;
        if (this.x != vec3i.x) {
            return false;
        }
        if (this.y != vec3i.y) {
            return false;
        }
        return this.z == vec3i.z;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public String toString() {
        return MessageFormat.format("<{0,number,#}, {1,number,#}, {2,number,#}>", this.x, this.y, this.z);
    }

    public void add(VertexOffset other) {
        this.x += other.dx;
        this.y += other.dy;
        this.z += other.dz;
    }

    public void sub(VertexOffset other) {
        this.x -= other.dx;
        this.y -= other.dy;
        this.z -= other.dz;
    }

    public void add(Vec3i other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
    }

    public void sub(Vec3i other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
    }

    public void add(com.extollit.linalg.immutable.Vec3i other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
    }

    public void sub(com.extollit.linalg.immutable.Vec3i other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
    }

    public int dot(Vec3i other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return (double)this.x == x && (double)this.y == y && (double)this.z == z;
    }

    @Override
    public boolean contains(com.extollit.linalg.immutable.Vec3d coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public boolean contains(Vec3d coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z;
    }

    @Override
    public boolean contains(com.extollit.linalg.immutable.Vec3i coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public boolean contains(Vec3i coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public final void accept(ISpatialRegion.Visitor visitor2) {
        visitor2.visit(this);
    }

    public int taxiTo(Vec3i other) {
        return other.x - this.x + (other.y - this.y) + (other.z - this.z);
    }
}

