/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.linalg.immutable;

import com.extollit.linalg.ISpatialRegion;
import com.extollit.linalg.immutable.Vec3i;
import com.extollit.linalg.immutable.VertexOffset;
import java.text.MessageFormat;

public final class Vec3d
implements ISpatialRegion {
    public final double x;
    public final double y;
    public final double z;

    public Vec3d(Vec3d copy2) {
        this.x = copy2.x;
        this.y = copy2.y;
        this.z = copy2.z;
    }

    public Vec3d(com.extollit.linalg.mutable.Vec3d copy2) {
        this.x = copy2.x;
        this.y = copy2.y;
        this.z = copy2.z;
    }

    public Vec3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3d(VertexOffset offset) {
        this.x = offset.dx;
        this.y = offset.dy;
        this.z = offset.dz;
    }

    public Vec3d(Vec3i copy2) {
        this.x = copy2.x;
        this.y = copy2.y;
        this.z = copy2.z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec3d vec3d = (Vec3d)o;
        if (Double.compare(vec3d.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(vec3d.y, this.y) != 0) {
            return false;
        }
        return Double.compare(vec3d.z, this.z) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return MessageFormat.format("<{0,number,#.#}, {1,number,#.#}, {2,number,#.#}>", this.x, this.y, this.z);
    }

    public final Vec3d proj(com.extollit.linalg.mutable.Vec3d other) {
        return this.mulOf(this.dot(other) / this.mg2());
    }

    public final Vec3d proj(Vec3d other) {
        return this.mulOf(this.dot(other) / this.mg2());
    }

    public final double mg2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vec3d subOf(Vec3d other) {
        return new Vec3d(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public Vec3d subOf(com.extollit.linalg.mutable.Vec3d other) {
        return this.subOf(other.x, other.y, other.z);
    }

    public Vec3d subOf(double x, double y, double z) {
        return new Vec3d(this.x - x, this.y - y, this.z - z);
    }

    public Vec3d plusOf(Vec3d other) {
        return new Vec3d(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vec3d plusOf(com.extollit.linalg.mutable.Vec3d other) {
        return this.plusOf(other.x, other.y, other.z);
    }

    public Vec3d plusOf(double dx, double dy, double dz) {
        return new Vec3d(this.x + dx, this.y + dy, this.z + dz);
    }

    public double dot(Vec3d other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public double dot(com.extollit.linalg.mutable.Vec3d other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vec3d mulOf(double s) {
        return this.mulOf(s, s, s);
    }

    public Vec3d mulOf(double x, double y, double z) {
        return new Vec3d(this.x * x, this.y * y, this.z * z);
    }

    public Vec3d mulOf(Vec3i other) {
        return new Vec3d(this.x * (double)other.x, this.y * (double)other.y, this.z * (double)other.z);
    }

    public Vec3d mulOf(com.extollit.linalg.mutable.Vec3i other) {
        return new Vec3d(this.x * (double)other.x, this.y * (double)other.y, this.z * (double)other.z);
    }

    public final com.extollit.linalg.mutable.Vec3d mutableCrossOf(Vec3d other) {
        return new com.extollit.linalg.mutable.Vec3d(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public final void cross(com.extollit.linalg.mutable.Vec3d other) {
        double x = this.y * other.z - this.z * other.y;
        double y = this.z * other.x - this.x * other.z;
        double z = this.x * other.y - this.y * other.x;
        other.x = x;
        other.y = y;
        other.z = z;
    }

    public double mg() {
        return Math.sqrt(this.mg2());
    }

    public Vec3d squared() {
        return new Vec3d(this.x * this.x, this.y * this.y, this.z * this.z);
    }

    public Vec3d negated() {
        return new Vec3d(-this.x, -this.y, -this.z);
    }

    public Vec3d normalized() {
        double mg = this.mg();
        return new Vec3d(this.x / mg, this.y / mg, this.z / mg);
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return this.x == x && this.y == y && this.z == z;
    }

    @Override
    public boolean contains(Vec3d coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public boolean contains(com.extollit.linalg.mutable.Vec3d coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return this.x == (double)x && this.y == (double)y && this.z == (double)z;
    }

    @Override
    public boolean contains(Vec3i coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public boolean contains(com.extollit.linalg.mutable.Vec3i coordinates) {
        return this.contains(coordinates.x, coordinates.y, coordinates.z);
    }

    @Override
    public final void accept(ISpatialRegion.Visitor visitor2) {
        visitor2.visit(this);
    }
}

