/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.linalg.immutable;

import com.extollit.linalg.AbstractSpatialRegion;
import com.extollit.linalg.ISpatialRegion;
import com.extollit.linalg.immutable.Vec3d;
import com.extollit.linalg.immutable.Vec3i;

public class IntAxisAlignedBox
extends AbstractSpatialRegion
implements ISpatialRegion {
    public final Vec3i min;
    public final Vec3i max;

    public IntAxisAlignedBox(int x0, int y0, int z0, int xN, int yN, int zN) {
        this.min = Vec3i.min(x0, y0, z0, xN, yN, zN);
        this.max = Vec3i.max(x0, y0, z0, xN, yN, zN);
    }

    public IntAxisAlignedBox(Vec3i min, Vec3i max) {
        this.min = Vec3i.min(min, max);
        this.max = Vec3i.max(min, max);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntAxisAlignedBox that = (IntAxisAlignedBox)o;
        if (!this.min.equals(that.min)) {
            return false;
        }
        return this.max.equals(that.max);
    }

    public int hashCode() {
        int result = this.min.hashCode();
        result = 31 * result + this.max.hashCode();
        return result;
    }

    public String toString() {
        return this.min + " to " + this.max;
    }

    @Override
    public final boolean contains(int x, int y, int z) {
        return x >= this.min.x && x <= this.max.x && y >= this.min.y && y <= this.max.y && z >= this.min.z && z <= this.max.z;
    }

    public Vec3d center() {
        Vec3i min = this.min;
        Vec3i max = this.max;
        return new Vec3d((float)(max.x + min.x) / 2.0f, (float)(max.y + min.y) / 2.0f, (float)(max.z + min.z) / 2.0f);
    }

    @Override
    public void accept(ISpatialRegion.Visitor visitor2) {
        visitor2.visit(this);
    }

    public boolean valid() {
        return this.min.x <= this.max.x && this.min.y <= this.max.y && this.min.z <= this.max.z;
    }

    @Override
    public final boolean contains(double x, double y, double z) {
        return x >= (double)this.min.x && x <= (double)this.max.x && y >= (double)this.min.y && y <= (double)this.max.y && z >= (double)this.min.z && z <= (double)this.max.z;
    }

    public final boolean contains(IntAxisAlignedBox other) {
        return this.contains(other.min) && this.contains(other.max);
    }

    public boolean intersects(IntAxisAlignedBox other) {
        return this.intersects(other.min, other.max);
    }

    public boolean intersects(Vec3i min, Vec3i max) {
        return this.intersects(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public boolean intersects(int x0, int y0, int z0, int xN, int yN, int zN) {
        return (IntAxisAlignedBox.lineDeltaFactor(this.min.x, this.max.x, x0, xN) | IntAxisAlignedBox.lineDeltaFactor(this.min.y, this.max.y, y0, yN) | IntAxisAlignedBox.lineDeltaFactor(this.min.z, this.max.z, z0, zN)) == 0;
    }

    private static int lineDeltaFactor(int leftMin, int leftMax, int rightMin, int rightMax) {
        int leftWidth = leftMax - leftMin + 1;
        int rightWidth = rightMax - rightMin + 1;
        int leftMid = leftMin + (leftMax - leftMin >> 1);
        int rightMid = rightMin + (rightMax - rightMin >> 1);
        return (Math.abs(leftMid - rightMid) << 1) / (leftWidth + rightWidth);
    }

    public IntAxisAlignedBox intersection(IntAxisAlignedBox other) {
        return new IntAxisAlignedBox(Math.max(this.min.x, other.min.x), Math.max(this.min.y, other.min.y), Math.max(this.min.z, other.min.z), Math.min(this.max.x, other.max.x), Math.min(this.max.y, other.max.y), Math.min(this.max.z, other.max.z));
    }

    public Vec3i midpoint() {
        return new Vec3i((this.max.x + this.min.x) / 2, (this.max.y + this.min.y) / 2, (this.max.z + this.min.z) / 2);
    }

    public IntAxisAlignedBox union(IntAxisAlignedBox other) {
        return new IntAxisAlignedBox(Math.min(this.min.x, other.min.x), Math.min(this.min.y, other.min.y), Math.min(this.min.z, other.min.z), Math.max(this.max.x, other.max.x), Math.max(this.max.y, other.max.y), Math.max(this.max.z, other.max.z));
    }

    public IntAxisAlignedBox union(int x, int y, int z) {
        return new IntAxisAlignedBox(Math.min(this.min.x, x), Math.min(this.min.y, y), Math.min(this.min.z, z), Math.max(this.max.x, x), Math.max(this.max.y, y), Math.max(this.max.z, z));
    }
}

