/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.persistence.internal;

import com.extollit.gaming.ai.path.persistence.internal.LinkableReader;
import com.extollit.gaming.ai.path.persistence.internal.LinkableWriter;
import com.extollit.gaming.ai.path.persistence.internal.PartialObjectReader;
import com.extollit.gaming.ai.path.persistence.internal.PartialObjectWriter;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectInput;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IdentityMapper<T, RW extends PartialObjectReader<T> & PartialObjectWriter<T>> {
    private final Map<T, Short> reverseMap = new IdentityHashMap<T, Short>();
    private final List<T> map = new ArrayList<T>();
    private final RW readerWriter;

    public IdentityMapper(RW readerWriter) {
        this.readerWriter = readerWriter;
    }

    public void initialize(LinkableWriter<T, T> writer, Collection<T> iterable, ObjectOutput out2) throws IOException {
        List<T> map2 = this.map;
        if (!map2.isEmpty()) {
            throw new IllegalStateException("Already initialized");
        }
        RW readerWriter = this.readerWriter;
        ReferenceRecorder<T> recorder = new ReferenceRecorder<T>();
        Map<T, Short> reverseMap = this.reverseMap;
        Collection<T> source = iterable;
        do {
            for (T object : source) {
                this.register(object);
                writer.writeLinkages(object, recorder);
            }
        } while (!(source = recorder.popRecorded(reverseMap.keySet())).isEmpty());
        if (map2.size() > Short.MAX_VALUE) {
            throw new IOException("Too many objects");
        }
        out2.writeShort(map2.size());
        for (T object : map2) {
            ((PartialObjectWriter)readerWriter).writePartialObject(object, out2);
        }
        this.writeLinksInternal(writer, map2, out2);
    }

    public Iterable<T> readAll(ObjectInput in) throws IOException {
        this.clear();
        short count = in.readShort();
        RW readerWriter = this.readerWriter;
        while (true) {
            short s = count;
            count = (short)(count - 1);
            if (s <= 0) break;
            Object object = readerWriter.readPartialObject(in);
            this.register(object);
        }
        return new ArrayList<T>(this.map);
    }

    public <A, W extends PartialObjectWriter<A> & LinkableWriter<A, T>> void writeWith(W writer, Iterable<A> source, ObjectOutput out2) throws IOException {
        LinkedList<A> list = new LinkedList<A>();
        for (A elem : source) {
            list.add(elem);
        }
        out2.writeInt(list.size());
        ReferenceWriter refOut = new ReferenceWriter(out2);
        for (Object object : list) {
            writer.writePartialObject(object, out2);
            ((LinkableWriter)writer).writeLinkages(object, refOut);
        }
        this.writeLinksInternal(writer, list, out2);
    }

    private <A, W extends LinkableWriter<A, T>> void writeLinksInternal(W writer, Iterable<A> source, ObjectOutput out2) throws IOException {
        ReferenceWriter refOut = new ReferenceWriter(out2);
        for (A object : source) {
            writer.writeLinkages(object, refOut);
        }
    }

    public <A, W extends LinkableWriter<A, T>> void writeLinks(W writer, A object, ObjectOutput out2) throws IOException {
        writer.writeLinkages(object, new ReferenceWriter(out2));
    }

    public <A, R extends PartialObjectReader<A> & LinkableReader<A, T>> List<A> readWith(R reader, ObjectInput in) throws IOException {
        int count = in.readInt();
        ArrayList<A> results = new ArrayList<A>(count);
        ReferenceReader refIn = new ReferenceReader(in);
        while (count-- > 0) {
            A object = reader.readPartialObject(in);
            results.add(object);
            ((LinkableReader<A, T>)reader).readLinkages(object, refIn);
        }
        this.readLinks(reader, (Iterable<A>)results, in);
        return results;
    }

    public <A, R extends LinkableReader<A, T>> void readLinks(R reader, A object, ObjectInput in) throws IOException {
        reader.readLinkages(object, new ReferenceReader(in));
    }

    public <A, R extends LinkableReader<A, T>> void readLinks(R reader, Iterable<A> results, ObjectInput in) throws IOException {
        ReferenceReader refIn = new ReferenceReader(in);
        for (A object : results) {
            reader.readLinkages(object, refIn);
        }
    }

    private void register(T object) throws IOException {
        List<T> map2 = this.map;
        if (map2.size() >= Short.MAX_VALUE) {
            throw new IOException("Too many objects");
        }
        Map<T, Short> reverseMap = this.reverseMap;
        if (!reverseMap.containsKey(object)) {
            reverseMap.put(object, (short)map2.size());
            map2.add(object);
        }
    }

    public void clear() {
        this.reverseMap.clear();
        this.map.clear();
    }

    private final class ReferenceReader
    implements ReferableObjectInput<T> {
        private final ObjectInput delegate;

        private ReferenceReader(ObjectInput delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object readObject() throws ClassNotFoundException, IOException {
            return this.delegate.readObject();
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b2) throws IOException {
            return this.delegate.read(b2);
        }

        @Override
        public int read(byte[] b2, int off, int len) throws IOException {
            return this.delegate.read(b2, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void readFully(byte[] b2) throws IOException {
            this.delegate.readFully(b2);
        }

        @Override
        public void readFully(byte[] b2, int off, int len) throws IOException {
            this.delegate.readFully(b2, off, len);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return this.delegate.skipBytes(n);
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.delegate.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            return this.delegate.readByte();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.delegate.readUnsignedByte();
        }

        @Override
        public short readShort() throws IOException {
            return this.delegate.readShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.delegate.readUnsignedShort();
        }

        @Override
        public char readChar() throws IOException {
            return this.delegate.readChar();
        }

        @Override
        public int readInt() throws IOException {
            return this.delegate.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.delegate.readLong();
        }

        @Override
        public float readFloat() throws IOException {
            return this.delegate.readFloat();
        }

        @Override
        public double readDouble() throws IOException {
            return this.delegate.readDouble();
        }

        @Override
        public String readLine() throws IOException {
            return this.delegate.readLine();
        }

        @Override
        public String readUTF() throws IOException {
            return this.delegate.readUTF();
        }

        @Override
        public T readRef() throws IOException {
            short id = this.delegate.readShort();
            if (id >= IdentityMapper.this.map.size() || id < 0) {
                throw new IOException("Invalid object reference received in stream: " + id);
            }
            return IdentityMapper.this.map.get(id);
        }

        @Override
        public T readNullableRef() throws IOException {
            if (this.delegate.readBoolean()) {
                return this.readRef();
            }
            return null;
        }
    }

    private final class ReferenceWriter
    implements ReferableObjectOutput<T> {
        private final ObjectOutput delegate;

        public ReferenceWriter(ObjectOutput delegate) {
            this.delegate = delegate;
        }

        @Override
        public void writeObject(Object obj) throws IOException {
            this.delegate.writeObject(obj);
        }

        @Override
        public void write(int b2) throws IOException {
            this.delegate.write(b2);
        }

        @Override
        public void write(byte[] b2) throws IOException {
            this.delegate.write(b2);
        }

        @Override
        public void write(byte[] b2, int off, int len) throws IOException {
            this.delegate.write(b2, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.delegate.writeBoolean(v);
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.delegate.writeByte(v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.delegate.writeShort(v);
        }

        @Override
        public void writeChar(int v) throws IOException {
            this.delegate.writeChar(v);
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.delegate.writeInt(v);
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.delegate.writeLong(v);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.delegate.writeFloat(v);
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.delegate.writeDouble(v);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            this.delegate.writeBytes(s);
        }

        @Override
        public void writeChars(String s) throws IOException {
            this.delegate.writeChars(s);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            this.delegate.writeUTF(s);
        }

        @Override
        public void writeRef(T object) throws IOException {
            Short id = (Short)IdentityMapper.this.reverseMap.get(object);
            if (id == null) {
                throw new IOException(MessageFormat.format("Missing instance for object {0}", object));
            }
            this.delegate.writeShort(id.shortValue());
        }

        @Override
        public void writeNullableRef(T object) throws IOException {
            boolean nonNull = object != null;
            this.writeBoolean(nonNull);
            if (nonNull) {
                this.writeRef(object);
            }
        }
    }

    private static final class ReferenceRecorder<T>
    implements ReferableObjectOutput<T> {
        private final Set<T> recorded = new HashSet<T>();

        private ReferenceRecorder() {
        }

        public final Set<T> popRecorded(Collection<T> pop) {
            Set<T> recorded = this.recorded;
            recorded.removeAll(pop);
            return Collections.unmodifiableSet(recorded);
        }

        @Override
        public void writeRef(T object) throws IOException {
            this.recorded.add(object);
        }

        @Override
        public void writeNullableRef(T object) throws IOException {
            if (object != null) {
                this.writeRef(object);
            }
        }

        @Override
        public void writeObject(Object obj) throws IOException {
        }

        @Override
        public void write(int b2) throws IOException {
        }

        @Override
        public void write(byte[] b2) throws IOException {
        }

        @Override
        public void write(byte[] b2, int off, int len) throws IOException {
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
        }

        @Override
        public void writeByte(int v) throws IOException {
        }

        @Override
        public void writeShort(int v) throws IOException {
        }

        @Override
        public void writeChar(int v) throws IOException {
        }

        @Override
        public void writeInt(int v) throws IOException {
        }

        @Override
        public void writeLong(long v) throws IOException {
        }

        @Override
        public void writeFloat(float v) throws IOException {
        }

        @Override
        public void writeDouble(double v) throws IOException {
        }

        @Override
        public void writeBytes(String s) throws IOException {
        }

        @Override
        public void writeChars(String s) throws IOException {
        }

        @Override
        public void writeUTF(String s) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

