/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.model;

import com.extollit.gaming.ai.path.model.Node;
import com.extollit.gaming.ai.path.model.SortedPointQueue;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

final class TreeTransitional {
    private final Node nextRoot;
    private final Deque<RotateNodeOp> dq;

    public TreeTransitional(Node nextRoot) {
        LinkedList<RotateNodeOp> dq = new LinkedList<RotateNodeOp>();
        this.nextRoot = nextRoot;
        Node curr = this.nextRoot.up();
        byte length = nextRoot.length();
        int newLength0 = 0;
        while (curr != null) {
            Node up = curr.up();
            byte length0 = length;
            length = curr.length();
            curr.orphan();
            curr.dirty(true);
            int dl = newLength0 + (length0 - length) - length;
            dq.add(new RotateNodeOp(curr, dl));
            newLength0 = length + dl;
            curr = up;
        }
        this.dq = dq;
        this.nextRoot.orphan();
    }

    public boolean queue(Node head2, Node root) {
        for (RotateNodeOp op : this.dq) {
            if (op.root != root) continue;
            op.heads.add(head2);
            return true;
        }
        return false;
    }

    public void finish(SortedPointQueue queue) {
        Deque<RotateNodeOp> dq = this.dq;
        Node prev = this.nextRoot;
        while (!dq.isEmpty()) {
            RotateNodeOp op = dq.pop();
            Node next2 = op.root;
            next2.bindParent(prev);
            for (Node head2 : op.heads) {
                if (head2.dirty()) {
                    queue.addLength(head2, op.diff);
                }
                for (Node curr = head2.up(); curr != null && curr != next2 && curr.dirty(); curr = curr.up()) {
                    curr.addLength(op.diff);
                }
                if (!next2.dirty()) continue;
                next2.addLength(op.diff);
            }
            prev = next2;
        }
    }

    private static final class RotateNodeOp {
        public final Node root;
        public final int diff;
        public final List<Node> heads = new LinkedList<Node>();

        public RotateNodeOp(Node root, int diff) {
            this.root = root;
            this.diff = diff;
        }

        public String toString() {
            return this.diff + ": " + this.root;
        }
    }
}

