/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.model;

import com.extollit.gaming.ai.path.IConfigModel;
import com.extollit.gaming.ai.path.model.Coords;
import com.extollit.gaming.ai.path.model.INode;
import com.extollit.gaming.ai.path.model.IPath;
import com.extollit.gaming.ai.path.model.IPathingEntity;
import com.extollit.gaming.ai.path.model.IncompletePath;
import com.extollit.gaming.ai.path.model.Node;
import com.extollit.gaming.ai.path.persistence.internal.LinkableReader;
import com.extollit.gaming.ai.path.persistence.internal.LinkableWriter;
import com.extollit.gaming.ai.path.persistence.internal.PartialObjectReader;
import com.extollit.gaming.ai.path.persistence.internal.PartialObjectWriter;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectInput;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectOutput;
import com.extollit.linalg.mutable.Vec3d;
import com.extollit.num.FloatRange;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;

public final class PathObject
implements IPath {
    private static final double PATHPOINT_SNAP_MARGIN_SQ = 0.25;
    private static FloatRange DIRECT_LINE_TIME_LIMIT = new FloatRange(1.0f, 2.0f);
    final Node[] nodes;
    private final float speed;
    private final Random random;
    public int i;
    private int taxiUntil = 0;
    private int adjacentIndex = 0;
    private int length;
    private float nextDirectLineTimeout;
    private float lastMutationTime = -1.0f;

    public static void configureFrom(IConfigModel configModel) {
        DIRECT_LINE_TIME_LIMIT = configModel.directLineTimeLimit();
    }

    PathObject(float speed, Node ... nodes) {
        this(speed, new Random(), nodes);
    }

    protected PathObject(float speed, Random random, Node ... nodes) {
        this.nodes = nodes;
        this.length = nodes.length;
        this.speed = speed;
        this.random = random;
        this.nextDirectLineTimeout = DIRECT_LINE_TIME_LIMIT.next(random);
    }

    public static IPath fromHead(float speed, Random random, Node head2) {
        int i = 1;
        Node p = head2;
        while (p.up() != null) {
            ++i;
            p = p.up();
        }
        Node[] result = new Node[i];
        result[--i] = head2;
        Node p2 = head2;
        while (p2.up() != null) {
            p2 = p2.up();
            result[--i] = p2;
        }
        if (result.length <= 1) {
            return new IncompletePath(result[0]);
        }
        return new PathObject(speed, random, result);
    }

    @Override
    public void truncateTo(int length) {
        if (length < 0 || length >= this.nodes.length) {
            throw new ArrayIndexOutOfBoundsException(MessageFormat.format("Length is out of bounds 0 <= length < {0} but length = {1}", this.nodes.length, length));
        }
        this.length = length;
    }

    @Override
    public void untruncate() {
        this.length = this.nodes.length;
    }

    @Override
    public Iterator<INode> iterator() {
        return Arrays.stream(this.nodes).limit(this.length).iterator();
    }

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public final int cursor() {
        return this.i;
    }

    @Override
    public final INode at(int i) {
        return this.nodes[i];
    }

    @Override
    public final INode current() {
        return this.nodes[this.i];
    }

    @Override
    public final INode last() {
        Node[] nodes = this.nodes;
        int length = this.length;
        if (length > 0) {
            return nodes[length - 1];
        }
        return null;
    }

    public static boolean active(IPath path2) {
        return path2 != null && !path2.done();
    }

    @Override
    public final boolean done() {
        return this.i >= this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(IPathingEntity subject) {
        boolean mutated = false;
        try {
            INode node;
            float fy;
            int unlevelIndex;
            boolean grounded;
            if (this.done()) {
                return;
            }
            IPathingEntity.Capabilities capabilities = subject.capabilities();
            boolean bl = grounded = !capabilities.avian() && (!capabilities.aquatic() || !capabilities.swimmer());
            if (grounded) {
                unlevelIndex = this.unlevelIndex(this.i, subject.coordinates());
                fy = 0.0f;
            } else {
                unlevelIndex = this.length;
                fy = 1.0f;
            }
            int adjacentIndex0 = this.adjacentIndex;
            double minDistanceSquared = this.updateNearestAdjacentIndex(subject, unlevelIndex, fy);
            int adjacentIndex = this.adjacentIndex;
            int targetIndex = this.i;
            if (minDistanceSquared <= 0.25) {
                int advanceTargetIndex;
                targetIndex = adjacentIndex;
                targetIndex = targetIndex >= this.taxiUntil && (advanceTargetIndex = this.directLine(targetIndex, unlevelIndex, grounded)) > targetIndex ? advanceTargetIndex : adjacentIndex + 1;
            } else if (minDistanceSquared > 0.5 || targetIndex < this.taxiUntil) {
                targetIndex = adjacentIndex;
            }
            mutated = adjacentIndex > adjacentIndex0;
            this.adjacentIndex = adjacentIndex;
            this.i = Math.max(adjacentIndex, targetIndex);
            if (this.stagnantFor(subject) > this.nextDirectLineTimeout) {
                this.taxiUntil = this.taxiUntil < adjacentIndex ? adjacentIndex + 1 : ++this.taxiUntil;
                this.nextDirectLineTimeout += DIRECT_LINE_TIME_LIMIT.next(this.random);
            }
            INode iNode = node = this.done() ? this.last() : this.current();
            if (node != null) {
                this.moveSubjectTo(subject, node);
            }
        }
        finally {
            if (mutated || this.lastMutationTime < 0.0f) {
                this.lastMutationTime = (float)subject.age() * this.speed;
                if (this.nextDirectLineTimeout > PathObject.DIRECT_LINE_TIME_LIMIT.max) {
                    this.nextDirectLineTimeout = DIRECT_LINE_TIME_LIMIT.next(this.random);
                }
            }
        }
    }

    private double updateNearestAdjacentIndex(IPathingEntity subject, int unlevelIndex, float fy) {
        int nextAdjacentIndex;
        double minDistanceSquared = Double.MAX_VALUE;
        com.extollit.linalg.immutable.Vec3d currentPosition = subject.coordinates();
        float width = subject.width();
        double offset = PathObject.pointToPositionOffset(width);
        Vec3d d2 = new Vec3d(currentPosition);
        int end2 = unlevelIndex + 1;
        for (int i = nextAdjacentIndex = this.adjacentIndex; i < this.length && i < end2; ++i) {
            Node node = this.nodes[i];
            Coords pp = node.key;
            d2.sub(pp.x, pp.y, pp.z);
            d2.sub(offset, 0.0, offset);
            d2.y *= (double)fy;
            double distanceSquared = d2.mg2();
            if (distanceSquared < minDistanceSquared) {
                nextAdjacentIndex = i;
                minDistanceSquared = distanceSquared;
            }
            d2.set(currentPosition);
        }
        this.adjacentIndex = nextAdjacentIndex;
        return minDistanceSquared;
    }

    private void moveSubjectTo(IPathingEntity subject, INode pathPoint) {
        Vec3d d2 = new Vec3d(subject.coordinates());
        com.extollit.linalg.immutable.Vec3d position = PathObject.positionFor(subject, pathPoint.coordinates());
        d2.sub(position);
        if (d2.mg2() > 0.25) {
            subject.moveTo(position, pathPoint.passibility(), pathPoint.gravitation());
        }
    }

    @Override
    public boolean taxiing() {
        return this.taxiUntil >= this.adjacentIndex;
    }

    @Override
    public void taxiUntil(int index) {
        this.taxiUntil = index;
    }

    public static com.extollit.linalg.immutable.Vec3d positionFor(IPathingEntity subject, Coords point) {
        double offset = PathObject.pointToPositionOffset(subject.width());
        return new com.extollit.linalg.immutable.Vec3d((double)point.x + offset, point.y, (double)point.z + offset);
    }

    private static double pointToPositionOffset(float subjectWidth) {
        double dw = Math.ceil(subjectWidth) / 2.0;
        return dw - Math.floor(dw);
    }

    @Override
    public float stagnantFor(IPathingEntity pathingEntity) {
        return this.lastMutationTime < 0.0f ? 0.0f : (float)pathingEntity.age() * this.speed - this.lastMutationTime;
    }

    protected int directLine(int from, int until, boolean grounded) {
        int i;
        int[] xis = new int[4];
        int[] yis = new int[4];
        int[] zis = new int[4];
        int ii = 0;
        int i0 = i = from;
        int xi00 = 0;
        int yi00 = 0;
        int zi00 = 0;
        boolean bdx = false;
        boolean bdy = false;
        boolean bdz = false;
        int n = until - 1;
        Node[] nodes = this.nodes;
        Node node0 = nodes[i];
        Coords p0 = node0.key;
        while (i++ < n) {
            Node node = nodes[i];
            Coords p = node.key;
            int dx = p.x - p0.x;
            int dy = p.y - p0.y;
            int dz = p.z - p0.z;
            if (grounded && dy != 0) {
                return i - 1;
            }
            int xi = xis[ii];
            int yi = yis[ii];
            int zi = zis[ii];
            if (((xi += dx) * (zi += dz) | zi * (yi += dy) | yi * xi) != 0) {
                int xi0 = xis[ii];
                int yi0 = yis[ii];
                int zi0 = zis[ii];
                xi00 = xi0;
                yi00 = yi0;
                zi00 = zi0;
                xi -= xi0;
                yi -= yi0;
                zi -= zi0;
                boolean bdx0 = bdx;
                boolean bdy0 = bdy;
                boolean bdz0 = bdz;
                if (!(bdx ^= dx != 0) && bdx0 || !(bdy ^= dy != 0) && bdy0 || !(bdz ^= dz != 0) && bdz0) break;
                ++ii;
                i0 = i - 1;
            }
            xis[ii] = xi;
            yis[ii] = yi;
            zis[ii] = zi;
            int sq = xi * zi00 + xi * yi00 + (zi * xi00 + zi * yi00) + (yi * xi00 + yi * zi00);
            if ((sq *= sq) > (zi00 + yi00 + xi00) * (zi00 + yi00 + xi00)) break;
            p0 = p;
        }
        i = i0;
        xi00 = xis[0];
        yi00 = yis[0];
        zi00 = zis[0];
        int iiN = ii;
        int xi = 0;
        int yi = 0;
        int zi = 0;
        int axi00 = Math.abs(xi00);
        int ayi00 = Math.abs(yi00);
        int azi00 = Math.abs(zi00);
        ii = 0;
        p0 = nodes[i].key;
        while (i++ < n) {
            Node node = nodes[i];
            Coords p = node.key;
            int dx = p.x - p0.x;
            int dy = p.y - p0.y;
            int dz = p.z - p0.z;
            int xi0 = xi;
            int yi0 = yi;
            int zi0 = zi;
            xi += dx;
            yi += dy;
            zi += dz;
            if (Math.abs(xi0) > axi00 || Math.abs(yi0) > ayi00 || Math.abs(zi0) > azi00) {
                --i;
                break;
            }
            if ((xi * zi | zi * yi | yi * xi) != 0) {
                if (xi0 != xi00 || yi0 != yi00 || zi0 != zi00) break;
                xi -= xi00;
                yi -= yi00;
                zi -= zi00;
                ii = (ii + 1) % iiN;
                xi00 = xis[ii];
                yi00 = yis[ii];
                zi00 = zis[ii];
                axi00 = Math.abs(xi00);
                ayi00 = Math.abs(yi00);
                azi00 = Math.abs(zi00);
            }
            if (dx * xi00 < 0 || dy * yi00 < 0 || dz * zi00 < 0) break;
            p0 = p;
        }
        return --i;
    }

    private int unlevelIndex(int from, com.extollit.linalg.immutable.Vec3d position) {
        int y0 = (int)Math.floor(position.y);
        Node[] nodes = this.nodes;
        int levelIndex = this.length();
        for (int i = from; i < this.length(); ++i) {
            Node node = nodes[i];
            if (node.key.y - y0 == 0) continue;
            levelIndex = i;
            break;
        }
        return levelIndex;
    }

    @Override
    public boolean sameAs(IPath other) {
        int c2;
        Node[] thisNodes = this.nodes;
        int length = this.length;
        Iterator i = other.iterator();
        for (c2 = 0; c2 < length && i.hasNext(); ++c2) {
            if (thisNodes[c2].key.equals(((INode)i.next()).coordinates())) continue;
            return false;
        }
        return c2 >= length && !i.hasNext();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathObject that = (PathObject)o;
        return this.i == that.i && this.sameAs(that);
    }

    public int hashCode() {
        INode last = this.last();
        return last == null ? 0 : last.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        sb.append("Last Mutation: ");
        sb.append(this.lastMutationTime);
        sb.append(System.lineSeparator());
        for (Node pp : this.nodes) {
            if (index++ == this.i) {
                sb.append('*');
            }
            sb.append(pp.key);
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public void adjustPathPosition(IPath formerPath, IPathingEntity pathingEntity) {
        double pointOffset = PathObject.pointToPositionOffset(pathingEntity.width());
        int length = this.length;
        Node[] nodes = this.nodes;
        INode lastPointVisited = formerPath.current();
        com.extollit.linalg.immutable.Vec3d coordinates = pathingEntity.coordinates();
        double x = coordinates.x;
        double y = coordinates.y;
        double z = coordinates.z;
        double minSquareDistFromSource = Double.MAX_VALUE;
        int c2 = -1;
        while (++c2 < formerPath.cursor() && c2 < length && nodes[c2].key.equals(formerPath.at(c2).coordinates())) {
        }
        --c2;
        while (++c2 < length) {
            Node node = nodes[c2];
            Coords p = node.coordinates();
            if (p.equals(lastPointVisited.coordinates())) {
                this.i = c2;
                break;
            }
            double dx = (double)p.x - x + pointOffset;
            double dy = (double)p.y - y;
            double dz = (double)p.z - z + pointOffset;
            double squareDelta = dx * dx + dy * dy + dz * dz;
            if (!(squareDelta < minSquareDistFromSource)) continue;
            minSquareDistFromSource = squareDelta;
            this.i = c2;
        }
    }

    public boolean reachableFrom(PathObject otherPath) {
        INode pivot = otherPath.current();
        for (Node node : this.nodes) {
            if (!node.key.equals(pivot.coordinates())) continue;
            return true;
        }
        return false;
    }

    public static final class Writer
    implements PartialObjectWriter<PathObject>,
    LinkableWriter<PathObject, Node> {
        public static final Writer INSTANCE = new Writer();

        private Writer() {
        }

        @Override
        public void writeLinkages(PathObject path2, ReferableObjectOutput<Node> out2) throws IOException {
            out2.writeShort(path2.nodes.length);
            for (Node node : path2.nodes) {
                out2.writeRef(node);
            }
        }

        @Override
        public void writePartialObject(PathObject path2, ObjectOutput out2) throws IOException {
            out2.writeShort(path2.nodes.length);
            out2.writeFloat(path2.speed);
            out2.writeShort(path2.i);
            out2.writeShort(path2.taxiUntil);
            out2.writeShort(path2.adjacentIndex);
            out2.writeShort(path2.length);
            out2.writeFloat(path2.nextDirectLineTimeout);
            out2.writeFloat(path2.lastMutationTime);
        }
    }

    public static class Reader
    implements PartialObjectReader<PathObject>,
    LinkableReader<PathObject, Node> {
        private Reader() {
        }

        public static Reader forVersion(byte version2) {
            if (version2 == 1) {
                return new V1();
            }
            return new Reader();
        }

        @Override
        public void readLinkages(PathObject path2, ReferableObjectInput<Node> in) throws IOException {
            Node[] nodes = path2.nodes;
            if (nodes.length != in.readShort()) {
                throw new IOException("Stream corruption detected");
            }
            for (int c2 = 0; c2 < nodes.length; ++c2) {
                nodes[c2] = in.readRef();
            }
        }

        @Override
        public PathObject readPartialObject(ObjectInput in) throws IOException {
            short count = in.readShort();
            PathObject path2 = new PathObject(in.readFloat(), new Node[count]);
            path2.i = in.readShort();
            path2.taxiUntil = in.readShort();
            path2.adjacentIndex = in.readShort();
            path2.length = in.readShort();
            path2.nextDirectLineTimeout = in.readFloat();
            path2.lastMutationTime = in.readFloat();
            return path2;
        }

        private static final class V1
        extends Reader {
            private V1() {
            }

            @Override
            public PathObject readPartialObject(ObjectInput in) throws IOException {
                short count = in.readShort();
                PathObject path2 = new PathObject(in.readFloat(), new Node[count]);
                path2.i = in.readInt();
                path2.taxiUntil = in.readInt();
                path2.adjacentIndex = in.readInt();
                path2.length = in.readInt();
                path2.nextDirectLineTimeout = in.readFloat();
                path2.lastMutationTime = in.readFloat();
                return path2;
            }
        }
    }
}

