/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.model;

import com.extollit.gaming.ai.path.model.Node;
import java.util.Iterator;

public final class NodeLinkedList
implements Iterable<Node> {
    public final Node self;
    private NodeLinkedList next;

    public NodeLinkedList(Node self) {
        this(self, null);
    }

    private NodeLinkedList(Node self, NodeLinkedList next2) {
        this.next = next2;
        this.self = self;
    }

    public int size() {
        NodeLinkedList curr = this;
        int count = 0;
        do {
            ++count;
        } while ((curr = curr.next) != null);
        return count;
    }

    @Override
    public Iterator<Node> iterator() {
        return new Iter(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeLinkedList nodes = (NodeLinkedList)o;
        if (this.next != null ? !this.next.equals(nodes.next) : nodes.next != null) {
            return false;
        }
        return this.self.equals(nodes.self);
    }

    public NodeLinkedList remove(Node child) {
        NodeLinkedList e = this;
        NodeLinkedList last = null;
        do {
            if (e.self == child) {
                NodeLinkedList tail = e.next;
                NodeLinkedList head2 = this;
                if (last == null) {
                    head2 = tail;
                } else {
                    last.next = tail;
                }
                return head2;
            }
            last = e;
        } while ((e = e.next) != null);
        return this;
    }

    public boolean add(Node child) {
        NodeLinkedList e = this;
        do {
            if (e.self == child) {
                return false;
            }
            NodeLinkedList last = e;
        } while ((e = e.next) != null);
        last.next = new NodeLinkedList(child);
        return true;
    }

    public static boolean contains(NodeLinkedList list, Node other) {
        while (list != null) {
            if (list.self == other) {
                return true;
            }
            list = list.next;
        }
        return false;
    }

    public int hashCode() {
        return this.self.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        for (Node element : this) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(element);
        }
        sb.append(']');
        return sb.toString();
    }

    private static class Iter
    implements Iterator<Node> {
        private NodeLinkedList head;

        public Iter(NodeLinkedList head2) {
            this.head = head2;
        }

        @Override
        public boolean hasNext() {
            return this.head != null;
        }

        @Override
        public Node next() {
            NodeLinkedList head2 = this.head;
            this.head = head2.next;
            return head2.self;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

