/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path.model;

import com.extollit.gaming.ai.path.model.Coords;
import com.extollit.gaming.ai.path.model.Gravitation;
import com.extollit.gaming.ai.path.model.INode;
import com.extollit.gaming.ai.path.model.NodeLinkedList;
import com.extollit.gaming.ai.path.model.Passibility;
import com.extollit.gaming.ai.path.persistence.internal.LinkableReader;
import com.extollit.gaming.ai.path.persistence.internal.LinkableWriter;
import com.extollit.gaming.ai.path.persistence.internal.PartialObjectReader;
import com.extollit.gaming.ai.path.persistence.internal.PartialObjectWriter;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectInput;
import com.extollit.gaming.ai.path.persistence.internal.ReferableObjectOutput;
import com.extollit.gaming.ai.path.persistence.internal.Vec3iReaderWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Objects;

public class Node
implements INode {
    private static final byte BitWidth_512 = 9;
    private static final byte BitWidth_128 = 7;
    private static final byte Mask_Passibility = 3;
    private static final byte Mask_Gravitation = 3;
    private static final byte Index_BitOffs = 2;
    private static final byte Volatile_BitOffs = 11;
    private static final byte Length_BitOffs = 12;
    private static final byte Remain_BitOffs = 19;
    private static final byte Visited_BitOffs = 26;
    private static final byte Gravitation_BitOffs = 27;
    private static final byte LengthDirty_BitOffs = 29;
    public static final short MAX_PATH_DISTANCE = 127;
    private static final int Mask_128 = 127;
    private static final int Mask_512 = 511;
    static final int MAX_INDICES = 511;
    public final Coords key;
    private int word;
    private Node previous;
    private NodeLinkedList children;

    Node(Coords key2) {
        this.key = key2;
        this.unassign();
    }

    Node(Coords key2, Passibility passibility) {
        this(key2, passibility, false);
    }

    Node(Coords key2, Passibility passibility, boolean volatility) {
        this(key2, passibility, volatility, Gravitation.grounded);
    }

    Node(Coords key2, Passibility passibility, boolean volatility, Gravitation gravitation) {
        this.key = key2;
        this.word = 0x7FC | (gravitation.ordinal() & 3) << 27 | passibility.ordinal() & 3 | (volatility ? 1 : 0) << 11;
    }

    public Node(int x, int y, int z) {
        this(new Coords(x, y, z));
    }

    public Node(int x, int y, int z, Passibility passibility) {
        this(new Coords(x, y, z), passibility);
    }

    public Node(int x, int y, int z, Passibility passibility, boolean volatility) {
        this(new Coords(x, y, z), passibility, volatility);
    }

    public Node(int x, int y, int z, Passibility passibility, boolean volatility, Gravitation gravitation) {
        this(new Coords(x, y, z), passibility, volatility, gravitation);
    }

    @Override
    public Coords coordinates() {
        return this.key;
    }

    private static int wordReset(Node copy2) {
        return copy2.word & 0x18000803 | 0x200007FC;
    }

    public final byte length() {
        return (byte)(this.word >> 12 & 0x7F);
    }

    public final byte remaining() {
        return (byte)(this.word >> 19 & 0x7F);
    }

    public final byte journey() {
        return (byte)(this.length() + this.remaining());
    }

    public final Node up() {
        return this.previous;
    }

    public Node root() {
        Node node = this;
        while (!node.orphaned()) {
            node = node.up();
        }
        return node;
    }

    @Override
    public final Passibility passibility() {
        return Passibility.of(this.word & 3);
    }

    public final void passibility(Passibility passibility) {
        Node previous = this.up();
        if (previous != null) {
            passibility = passibility.between(previous.passibility());
        }
        this.word = this.word & 0xFFFFFFFC | passibility.ordinal();
    }

    @Override
    public final Gravitation gravitation() {
        return Gravitation.values()[this.word >> 27 & 3];
    }

    public final void gravitation(Gravitation gravitation) {
        this.word = this.word & 0xE7FFFFFF | gravitation.ordinal() << 27;
    }

    public final boolean length(int length) {
        if (length > 127 || length < 0) {
            return false;
        }
        this.word = this.word & 0xDFF80FFF | length << 12;
        return true;
    }

    void addLength(int dl) {
        this.length(this.length() + dl);
    }

    final boolean remaining(int delta) {
        if (delta > 127 || delta < 0) {
            return false;
        }
        this.word = this.word & 0xFC07FFFF | delta << 19;
        return true;
    }

    final void reset() {
        this.word = Node.wordReset(this);
    }

    final void rollback() {
        this.reset();
    }

    final short index() {
        short index = (short)(this.word >> 2 & 0x1FF);
        return index == 511 ? (short)-1 : (short)index;
    }

    final boolean index(int index) {
        if (index >= 511 || index < -1) {
            return false;
        }
        this.word = this.word & 0xFFFFF803 | (index & 0x1FF) << 2;
        return true;
    }

    public final boolean dirty() {
        return (this.word >> 29 & 1) == 1;
    }

    public final void dirty(boolean flag) {
        this.word = this.word & 0xDFFFFFFF | (flag ? 0x20000000 : 0);
    }

    public final boolean visited() {
        return (this.word >> 26 & 1) == 1;
    }

    public final void visited(boolean flag) {
        this.word = this.word & 0xFBFFFFFF | (flag ? 0x4000000 : 0);
    }

    public final boolean volatile_() {
        return (this.word >> 11 & 1) == 1;
    }

    public final void volatile_(boolean flag) {
        this.word = this.word & 0xFFFFF7FF | (flag ? 2048 : 0);
    }

    public final boolean assigned() {
        return this.index() != -1;
    }

    public boolean target(Coords targetPoint) {
        int distance = (int)Math.sqrt(Node.squareDelta(this, targetPoint));
        if (distance > 127) {
            return false;
        }
        this.word = this.word & 0xFC07FFFF | distance << 19;
        return true;
    }

    public boolean contains(Node node) {
        Node curr = this;
        do {
            if (curr != node) continue;
            return true;
        } while ((curr = curr.previous) != null);
        return false;
    }

    public boolean orphaned() {
        return this.up() == null;
    }

    public void orphan() {
        if (this.previous != null) {
            this.previous.removeChild(this);
        }
        this.previous = null;
    }

    public void isolate() {
        this.orphan();
        this.sterilize();
    }

    public void sterilize() {
        if (this.children != null) {
            for (Node child : this.children) {
                assert (child.previous == this);
                child.previous = null;
            }
            this.children = null;
        }
    }

    boolean infecund() {
        return this.children == null;
    }

    private void removeChild(Node child) {
        if (this.children != null) {
            this.children = this.children.remove(child);
        }
        assert (!NodeLinkedList.contains(this.children, child));
    }

    final void unassign() {
        this.index(-1);
    }

    final boolean appendTo(Node parent, int delta, int remaining) {
        this.bindParent(parent);
        if (!this.length(parent.length() + delta)) {
            return false;
        }
        return this.remaining(remaining);
    }

    void bindParent(Node parent) {
        assert (!this.cyclic(parent));
        this.orphan();
        this.previous = parent;
        parent.addChild(this);
        this.passibility(this.passibility());
    }

    private void addChild(Node child) {
        if (this.children == null) {
            this.children = new NodeLinkedList(child);
        } else {
            this.children.add(child);
        }
        assert (NodeLinkedList.contains(this.children, child));
    }

    Iterable<Node> children() {
        return this.children == null ? Collections.emptyList() : this.children;
    }

    public static int squareDelta(Node left, Node right) {
        return Node.squareDelta(left, right.key);
    }

    public static int squareDelta(Node left, Coords rightCoords) {
        Coords leftCoords = left.key;
        int dx = leftCoords.x - rightCoords.x;
        int dy = leftCoords.y - rightCoords.y;
        int dz = leftCoords.z - rightCoords.z;
        return dx * dx + dy * dy + dz * dz;
    }

    private boolean cyclic(Node parent) {
        for (Node p = parent; p != null; p = p.up()) {
            if (p != this && !p.key.equals(this.key)) continue;
            return true;
        }
        return false;
    }

    public static boolean passible(Node node) {
        return node != null && node.passibility().betterThan(Passibility.impassible);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.key.toString());
        short index = this.index();
        if (this.volatile_()) {
            sb.append('!');
        }
        if (this.visited()) {
            sb.insert(0, '|');
        }
        switch (this.gravitation()) {
            case airborne: {
                sb.append('^');
                break;
            }
            case buoyant: {
                sb.append('~');
            }
        }
        if (index == -1) {
            sb.append(" (unassigned)");
        } else {
            sb.append(" @ ");
            sb.append(index);
        }
        String length = Byte.toString(this.length());
        if (this.dirty()) {
            length = length + '*';
        }
        return sb.toString() + MessageFormat.format(" ({0}) : length={1}, remaining={2}, journey={3}", new Object[]{this.passibility(), length, this.remaining(), this.journey()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node pathPoint = (Node)o;
        return Objects.equals(this.key, pathPoint.key);
    }

    public final int hashCode() {
        Coords key2 = this.key;
        int result = key2.x >> 4;
        result = 31 * result + (key2.y >> 4);
        result = 31 * result + (key2.z >> 4);
        return result;
    }

    public static final class ReaderWriter
    implements PartialObjectWriter<Node>,
    PartialObjectReader<Node>,
    LinkableWriter<Node, Node>,
    LinkableReader<Node, Node> {
        public static final ReaderWriter INSTANCE = new ReaderWriter();

        private ReaderWriter() {
        }

        @Override
        public void readLinkages(Node node, ReferableObjectInput<Node> in) throws IOException {
            byte count;
            if (in.readBoolean()) {
                node.previous = in.readRef();
            }
            byte by = count = in.readByte();
            count = (byte)(count - 1);
            if (by > 0) {
                NodeLinkedList children2 = node.children = new NodeLinkedList(in.readRef());
                while (true) {
                    byte by2 = count;
                    count = (byte)(count - 1);
                    if (by2 <= 0) break;
                    children2.add(in.readRef());
                }
            }
        }

        @Override
        public void writeLinkages(Node node, ReferableObjectOutput<Node> out2) throws IOException {
            Node previous = node.previous;
            out2.writeBoolean(previous != null);
            if (previous != null) {
                out2.writeRef(previous);
            }
            if (node.children == null) {
                out2.writeByte(0);
            } else {
                out2.writeByte(node.children.size());
                for (Node child : node.children) {
                    out2.writeRef(child);
                }
            }
        }

        @Override
        public Node readPartialObject(ObjectInput in) throws IOException {
            Coords key2 = Vec3iReaderWriter.INSTANCEz.readPartialObject(in);
            Node node = new Node(key2);
            node.word = in.readInt();
            return node;
        }

        @Override
        public void writePartialObject(Node node, ObjectOutput out2) throws IOException {
            Vec3iReaderWriter.INSTANCEz.writePartialObject(node.key, out2);
            out2.writeInt(node.word);
        }
    }
}

