/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path;

import com.extollit.gaming.ai.path.AbstractNodeCalculator;
import com.extollit.gaming.ai.path.PassibilityHelpers;
import com.extollit.gaming.ai.path.model.Coords;
import com.extollit.gaming.ai.path.model.FlagSampler;
import com.extollit.gaming.ai.path.model.Gravitation;
import com.extollit.gaming.ai.path.model.IInstanceSpace;
import com.extollit.gaming.ai.path.model.INodeCalculator;
import com.extollit.gaming.ai.path.model.IPathingEntity;
import com.extollit.gaming.ai.path.model.Node;
import com.extollit.gaming.ai.path.model.Passibility;

class FluidicNodeCalculator
extends AbstractNodeCalculator
implements INodeCalculator {
    public FluidicNodeCalculator(IInstanceSpace instanceSpace) {
        super(instanceSpace);
    }

    @Override
    public Node passibleNodeNear(int x0, int y0, int z0, Coords origin, FlagSampler flagSampler) {
        int dz;
        int dy;
        int dx;
        IPathingEntity.Capabilities capabilities = this.capabilities;
        if (origin != null) {
            dx = x0 - origin.x;
            dy = y0 - origin.y;
            dz = z0 - origin.z;
        } else {
            dz = 0;
            dy = 0;
            dx = 0;
        }
        boolean hasOrigin = dx != 0 || dy != 0 || dz != 0;
        Passibility passibility = Passibility.passible;
        Gravitation gravitation = Gravitation.airborne;
        int minY = Integer.MIN_VALUE;
        float minPartY = 0.0f;
        int r = this.discreteSize / 2;
        int xN = x0 + this.discreteSize - r;
        for (int x = x0 - r; x < xN; ++x) {
            int zN = z0 + this.discreteSize - r;
            for (int z = z0 - r; z < zN; ++z) {
                byte flags = flagSampler.flagsAt(x, y0, z);
                int yb = y0 - 1;
                byte flagsBeneath = flagSampler.flagsAt(x, yb, z);
                gravitation = gravitation.between(PassibilityHelpers.gravitationFrom(flags));
                gravitation = gravitation.between(PassibilityHelpers.gravitationFrom(flagsBeneath));
                if (PassibilityHelpers.impedesMovement(flags, capabilities)) {
                    return new Node(x0, y0, z0, Passibility.impassible, flagSampler.volatility() > 0, gravitation);
                }
                passibility = passibility.between(PassibilityHelpers.passibilityFrom(flags, capabilities));
                float partY0 = this.topOffsetAt(flagSampler, x - dx, y0 - dy - 1, z - dz);
                float partY = this.topOffsetAt(flagsBeneath, x, yb, z);
                passibility = this.verticalClearanceAt(flagSampler, this.tall, flags, passibility, dy, x, y0, z, Math.min(partY, partY0));
                if (y0 > minY) {
                    minY = y0;
                    minPartY = partY;
                } else if (partY > minPartY) {
                    minPartY = partY;
                }
                if (!passibility.impassible(capabilities)) continue;
                return new Node(x0, y0, z0, Passibility.impassible, flagSampler.volatility() > 0, gravitation);
            }
        }
        if (passibility.impassible(capabilities)) {
            passibility = Passibility.impassible;
        } else if (hasOrigin) {
            passibility = this.originHeadClearance(flagSampler, passibility, origin, minY, minPartY);
        }
        Node point = new Node(x0, minY + Math.round(minPartY), z0);
        point.passibility(passibility);
        point.gravitation(gravitation);
        point.volatile_(flagSampler.volatility() > 0);
        return point;
    }

    @Override
    public boolean omnidirectional() {
        return true;
    }
}

