/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.gaming.ai.path;

import com.extollit.gaming.ai.path.PassibilityHelpers;
import com.extollit.gaming.ai.path.model.Coords;
import com.extollit.gaming.ai.path.model.Element;
import com.extollit.gaming.ai.path.model.FlagSampler;
import com.extollit.gaming.ai.path.model.IBlockObject;
import com.extollit.gaming.ai.path.model.IInstanceSpace;
import com.extollit.gaming.ai.path.model.INodeCalculator;
import com.extollit.gaming.ai.path.model.IPathingEntity;
import com.extollit.gaming.ai.path.model.Logic;
import com.extollit.gaming.ai.path.model.Passibility;
import com.extollit.linalg.immutable.AxisAlignedBBox;

abstract class AbstractNodeCalculator
implements INodeCalculator {
    protected final IInstanceSpace instanceSpace;
    protected IPathingEntity.Capabilities capabilities;
    protected int discreteSize;
    protected int tall;
    protected float actualSize;

    public AbstractNodeCalculator(IInstanceSpace instanceSpace) {
        this.instanceSpace = instanceSpace;
    }

    protected static boolean swimmingRequiredFor(byte flags) {
        return Element.water.in(flags) || Element.fire.in(flags) && !Logic.fuzzy.in(flags);
    }

    @Override
    public final void applySubject(IPathingEntity subject) {
        this.actualSize = subject.width();
        this.discreteSize = (int)Math.floor(subject.width() + 1.0f);
        this.tall = (int)Math.floor(subject.height() + 1.0f);
        this.capabilities = subject.capabilities();
    }

    protected final Passibility verticalClearanceAt(FlagSampler sampler, int max, byte flags, Passibility passibility, int dy, int x, int y, int z, float minPartY) {
        byte clearanceFlags = flags;
        int yMax = y + max;
        int yN = Math.max(y, y - dy) + this.tall;
        int yNa = yN - 1;
        int yt = y;
        while (yt < yNa && yt < yMax) {
            passibility = passibility.between(this.clearance(clearanceFlags));
            clearanceFlags = sampler.flagsAt(x, ++yt, z);
        }
        if (yt >= yNa) {
            passibility = this.headClearance(passibility, minPartY, x, yt, z, clearanceFlags);
        }
        return passibility;
    }

    protected final Passibility headClearance(Passibility passibility, float partyY, int x, int y, int z, byte flags) {
        if (this.insufficientHeadClearance(flags, partyY, x, y, z)) {
            passibility = Passibility.impassible;
        } else if (partyY >= 0.0f) {
            passibility = passibility.between(this.clearance(flags));
        }
        return passibility;
    }

    protected final boolean insufficientHeadClearance(byte flags, float partialY0, int x, int y, int z) {
        return this.bottomOffsetAt(flags, x, y, z) + partialY0 > 0.0f;
    }

    private float bottomOffsetAt(byte flags, int x, int y, int z) {
        if (!PassibilityHelpers.impedesMovement(flags, this.capabilities) || AbstractNodeCalculator.swimmingRequiredFor(flags)) {
            return 0.0f;
        }
        if (Element.earth.in(flags) && Logic.nothing.in(flags)) {
            return 1.0f;
        }
        IBlockObject block2 = this.instanceSpace.blockObjectAt(x, y, z);
        if (!block2.isImpeding()) {
            return 0.0f;
        }
        if (block2.isFullyBounded()) {
            return 1.0f;
        }
        AxisAlignedBBox bounds = block2.bounds();
        return (float)(1.0 - bounds.min.y);
    }

    private final Passibility clearance(byte flags) {
        return PassibilityHelpers.clearance(flags, this.capabilities);
    }

    protected final float topOffsetAt(FlagSampler sampler, int x, int y, int z) {
        return this.topOffsetAt(sampler.flagsAt(x, y, z), x, y, z);
    }

    protected final float topOffsetAt(byte flags, int x, int y, int z) {
        if (Element.air.in(flags) || Logic.climbable(flags) || Element.earth.in(flags) && Logic.nothing.in(flags) || AbstractNodeCalculator.swimmingRequiredFor(flags) && (this.capabilities.aquatic() || !this.capabilities.swimmer())) {
            return 0.0f;
        }
        if (AbstractNodeCalculator.swimmingRequiredFor(flags)) {
            return -0.5f;
        }
        IBlockObject block2 = this.instanceSpace.blockObjectAt(x, y, z);
        if (!block2.isImpeding()) {
            IBlockObject blockBelow;
            if (Element.earth.in(flags) && !(blockBelow = this.instanceSpace.blockObjectAt(x, y - 1, z)).isFullyBounded()) {
                float offset = (float)blockBelow.bounds().max.y - 2.0f;
                if (offset < -1.0f) {
                    offset = 0.0f;
                }
                return offset;
            }
            return 0.0f;
        }
        return (float)block2.bounds().max.y - 1.0f;
    }

    protected final Passibility originHeadClearance(FlagSampler sampler, Passibility passibility, Coords origin, int minY, float minPartY) {
        int z;
        int zN;
        int x;
        int yN0 = origin.y + this.tall;
        int yN = Math.max(minY, origin.y) + this.tall;
        int yNa = yN - 1;
        int xN = origin.x + this.discreteSize;
        for (x = origin.x; x < xN; ++x) {
            zN = origin.z + this.discreteSize;
            for (z = origin.z; z < zN; ++z) {
                for (int y = yN0; y < yNa; ++y) {
                    passibility = passibility.between(this.clearance(sampler.flagsAt(x, y, z)));
                }
            }
        }
        if (yN > yN0) {
            xN = origin.x + this.discreteSize;
            for (x = origin.x; x < xN; ++x) {
                zN = origin.z + this.discreteSize;
                for (z = origin.z; z < zN; ++z) {
                    byte flags = sampler.flagsAt(x, yNa, z);
                    if ((passibility = this.headClearance(passibility, minPartY, x, yNa, z, flags)) != Passibility.impassible) continue;
                    return Passibility.impassible;
                }
            }
        }
        return passibility;
    }
}

