/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.helpers;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.mvplugins.multiverse.core.config.handle.StringPropertyHandle;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
public interface DataStore<T> {
    public DataStore<T> copyFrom(T var1);

    public DataStore<T> pasteTo(T var1);

    public static class WorldBorderStore
    implements DataStore<LoadedMultiverseWorld> {
        private double borderCenterX;
        private double borderCenterZ;
        private double borderDamageAmount;
        private double borderDamageBuffer;
        private double borderSize;
        private int borderTimeRemaining;

        public WorldBorderStore copyFrom(LoadedMultiverseWorld world) {
            world.getBukkitWorld().peek(bukkitWorld -> {
                this.borderCenterX = bukkitWorld.getWorldBorder().getCenter().getX();
                this.borderCenterZ = bukkitWorld.getWorldBorder().getCenter().getZ();
                this.borderDamageAmount = bukkitWorld.getWorldBorder().getDamageAmount();
                this.borderDamageBuffer = bukkitWorld.getWorldBorder().getDamageBuffer();
                this.borderSize = bukkitWorld.getWorldBorder().getSize();
                this.borderTimeRemaining = bukkitWorld.getWorldBorder().getWarningTime();
            });
            return this;
        }

        public WorldBorderStore pasteTo(LoadedMultiverseWorld world) {
            world.getBukkitWorld().peek(bukkitWorld -> {
                bukkitWorld.getWorldBorder().setCenter(this.borderCenterX, this.borderCenterZ);
                bukkitWorld.getWorldBorder().setDamageAmount(this.borderDamageAmount);
                bukkitWorld.getWorldBorder().setDamageBuffer(this.borderDamageBuffer);
                bukkitWorld.getWorldBorder().setSize(this.borderSize);
                bukkitWorld.getWorldBorder().setWarningTime(this.borderTimeRemaining);
            });
            return this;
        }
    }

    public static class WorldConfigStore
    implements DataStore<LoadedMultiverseWorld> {
        private Map<String, Object> configMap;

        public WorldConfigStore copyFrom(LoadedMultiverseWorld world) {
            this.configMap = new HashMap<String, Object>();
            StringPropertyHandle worldPropertyHandler = world.getStringPropertyHandle();
            worldPropertyHandler.getAllPropertyNames().forEach(name -> worldPropertyHandler.getProperty((String)name).peek(value -> this.configMap.put((String)name, value)).onFailure(e -> CoreLogging.warning("Failed to get property " + name + " from world " + world.getName() + ": " + e.getMessage(), new Object[0])));
            return this;
        }

        public WorldConfigStore pasteTo(LoadedMultiverseWorld world) {
            if (this.configMap == null) {
                return this;
            }
            StringPropertyHandle worldPropertyHandler = world.getStringPropertyHandle();
            this.configMap.forEach((name, value) -> worldPropertyHandler.setProperty((String)name, value).onFailure(e -> CoreLogging.warning("Failed to set property %s to %s for world %s: %s", name, value, world.getName(), e.getMessage())));
            return this;
        }
    }

    public static class GameRulesStore
    implements DataStore<LoadedMultiverseWorld> {
        private Map<GameRule<?>, Object> gameRuleMap;

        public GameRulesStore copyFrom(LoadedMultiverseWorld world) {
            this.gameRuleMap = new HashMap();
            world.getBukkitWorld().peek(bukkitWorld -> {
                for (String gameRule : bukkitWorld.getGameRules()) {
                    GameRule gameRuleEnum = GameRule.getByName((String)gameRule);
                    if (gameRuleEnum == null) continue;
                    this.gameRuleMap.put(gameRuleEnum, bukkitWorld.getGameRuleValue(gameRuleEnum));
                }
            });
            CoreLogging.finer("Copied " + this.gameRuleMap.size() + " game rules from world " + world.getName(), new Object[0]);
            return this;
        }

        public GameRulesStore pasteTo(LoadedMultiverseWorld world) {
            if (this.gameRuleMap == null) {
                return this;
            }
            world.getBukkitWorld().peek(bukkitWorld -> {
                for (String gameRule : bukkitWorld.getGameRules()) {
                    GameRule gameRuleEnum = GameRule.getByName((String)gameRule);
                    if (gameRuleEnum == null) continue;
                    this.setGameRuleValue((World)bukkitWorld, (GameRule)gameRuleEnum, this.gameRuleMap.get(gameRuleEnum)).onFailure(e -> {
                        CoreLogging.warning("Failed to set game rule " + gameRuleEnum.getName() + " to " + String.valueOf(this.gameRuleMap.get(gameRuleEnum)), new Object[0]);
                        e.printStackTrace();
                    });
                }
            });
            return this;
        }

        private <T> Try<Void> setGameRuleValue(World world, GameRule<T> gameRule, Object value) {
            return Try.run(() -> world.setGameRule(gameRule, value));
        }
    }
}

