/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.entity;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpawnCategory;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
public final class EntityPurger {
    public int purgeEntities(LoadedMultiverseWorld world) {
        AtomicInteger purgeCount = new AtomicInteger(0);
        world.getBukkitWorld().peek(bukkitWorld -> {
            for (Entity entity : bukkitWorld.getEntities()) {
                if (world.getEntitySpawnConfig().shouldAllowSpawn(entity)) continue;
                entity.remove();
                purgeCount.incrementAndGet();
            }
        });
        return purgeCount.get();
    }

    public int purgeEntities(LoadedMultiverseWorld world, SpawnCategory spawnCategory) {
        AtomicInteger purgeCount = new AtomicInteger(0);
        world.getBukkitWorld().peek(bukkitWorld -> {
            for (Entity entity : bukkitWorld.getEntities()) {
                if (entity.getSpawnCategory() != spawnCategory) continue;
                entity.remove();
                purgeCount.incrementAndGet();
            }
        });
        return purgeCount.get();
    }

    public int purgeEntities(LoadedMultiverseWorld world, SpawnCategory ... spawnCategories) {
        Set<SpawnCategory> spawnCategoriesSet = Set.of(spawnCategories);
        AtomicInteger purgeCount = new AtomicInteger(0);
        world.getBukkitWorld().peek(bukkitWorld -> {
            for (Entity entity : bukkitWorld.getEntities()) {
                if (!spawnCategoriesSet.contains(entity.getSpawnCategory())) continue;
                entity.remove();
                purgeCount.incrementAndGet();
            }
        });
        return purgeCount.get();
    }

    public int purgeAllEntities(LoadedMultiverseWorld world) {
        AtomicInteger purgeCount = new AtomicInteger(0);
        world.getBukkitWorld().peek(bukkitWorld -> {
            for (Entity entity : bukkitWorld.getEntities()) {
                entity.remove();
                purgeCount.incrementAndGet();
            }
        });
        return purgeCount.get();
    }
}

