/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.NewAndRemovedWorlds;
import org.mvplugins.multiverse.core.world.WorldConfig;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
final class WorldsConfigManager {
    private static final String CONFIG_FILENAME = "worlds.yml";
    private final SortedMap<String, WorldConfig> worldConfigMap = new TreeMap<String, WorldConfig>();
    private final File worldConfigFile;
    private YamlConfiguration worldsConfig;
    private final MultiverseCore multiverseCore;

    @Inject
    WorldsConfigManager(@NotNull MultiverseCore core, @NotNull MultiverseCore multiverseCore) {
        this.worldConfigFile = core.getDataFolder().toPath().resolve(CONFIG_FILENAME).toFile();
        this.multiverseCore = multiverseCore;
    }

    public Try<NewAndRemovedWorlds> load() {
        return Try.of(() -> {
            this.loadWorldYmlFile();
            return this.parseNewAndRemovedWorlds();
        }).onFailure(e -> CoreLogging.severe("Failed to load worlds.yml file: %s", e.getMessage()));
    }

    private void loadWorldYmlFile() throws IOException, InvalidConfigurationException {
        boolean exists = this.worldConfigFile.exists();
        if (!exists && !this.worldConfigFile.createNewFile()) {
            throw new IllegalStateException("Could not create worlds.yml config file");
        }
        if (exists) {
            this.migrateRemoveOldConfigSerializable();
        }
        this.worldsConfig = new YamlConfiguration();
        this.worldsConfig.load(this.worldConfigFile);
    }

    private void migrateRemoveOldConfigSerializable() {
        Try.of(() -> Files.readString(this.worldConfigFile.toPath())).mapTry(configData -> {
            if (!configData.contains("==: MVWorld")) {
                throw new ConfigMigratedException();
            }
            Path oldWorldConfig = this.worldConfigFile.toPath().getParent().resolve("worlds.yml.old." + System.currentTimeMillis());
            Files.copy(this.worldConfigFile.toPath(), oldWorldConfig, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            return configData.replace("==: MVWorld", "w@: world").replace("==: MVSpawnSettings", "").replace("==: MVSpawnSubSettings", "").replace("==: MVEntryFee", "");
        }).andThenTry(configData -> Files.writeString(this.worldConfigFile.toPath(), (CharSequence)configData, new OpenOption[0])).andThenTry(() -> {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.worldConfigFile);
            ConfigurationSection worldsSection = config.getConfigurationSection("worlds");
            if (worldsSection == null) {
                worldsSection = config.createSection("worlds");
            }
            List<String> worldNames = this.getOldConfigWorldNames(worldsSection);
            HashMap<String, ConfigurationSection> worldConfigMap = new HashMap<String, ConfigurationSection>();
            for (String string : worldNames) {
                ConfigurationSection worldSection = worldsSection.getConfigurationSection(string);
                if (worldSection == null) continue;
                worldConfigMap.put(string, worldSection);
            }
            config.set("worlds", null);
            for (Map.Entry entry : worldConfigMap.entrySet()) {
                config.set(this.encodeWorldName((String)entry.getKey()), entry.getValue());
            }
            config.save(this.worldConfigFile);
        }).onFailure(e -> {
            if (e instanceof ConfigMigratedException) {
                CoreLogging.fine("Config already migrated", new Object[0]);
                return;
            }
            CoreLogging.warning("Failed to migrate old worlds.yml file: %s", e.getMessage());
            e.printStackTrace();
        });
    }

    @NotNull
    private List<String> getOldConfigWorldNames(ConfigurationSection worldsSection) {
        ArrayList<String> worldNames = new ArrayList<String>();
        this.recursiveGetOldConfigWorldNames(worldsSection, worldNames);
        return worldNames;
    }

    private void recursiveGetOldConfigWorldNames(ConfigurationSection section, List<String> worldNames) {
        Set keys = section.getKeys(false);
        if (keys.isEmpty()) {
            return;
        }
        if (keys.contains("w@")) {
            worldNames.add(section.getCurrentPath().substring(7));
            return;
        }
        for (String key : keys) {
            ConfigurationSection dataSection = section.getConfigurationSection(key);
            if (dataSection == null) continue;
            this.recursiveGetOldConfigWorldNames(dataSection, worldNames);
        }
    }

    private NewAndRemovedWorlds parseNewAndRemovedWorlds() {
        List<String> allWorldsInConfig = this.worldsConfig.getKeys(false).stream().map(this::decodeWorldName).toList();
        ArrayList<WorldConfig> newWorldsAdded = new ArrayList<WorldConfig>();
        for (String worldName2 : allWorldsInConfig) {
            this.getWorldConfig(worldName2).peek(config -> config.load(this.getWorldConfigSection(worldName2))).orElse(() -> {
                WorldConfig newWorldConfig = new WorldConfig(worldName2, this.getWorldConfigSection(worldName2), this.multiverseCore);
                this.worldConfigMap.put(worldName2, newWorldConfig);
                newWorldsAdded.add(newWorldConfig);
                return Option.of(newWorldConfig);
            }).peek(WorldConfig::save);
        }
        List<String> worldsRemoved = this.worldConfigMap.keySet().stream().filter(worldName -> !allWorldsInConfig.contains(worldName)).toList();
        for (String s : worldsRemoved) {
            this.worldConfigMap.remove(s);
        }
        return new NewAndRemovedWorlds(newWorldsAdded, worldsRemoved);
    }

    public boolean isLoaded() {
        return this.worldsConfig != null;
    }

    public Try<Void> save() {
        return Try.run(() -> {
            if (!this.isLoaded()) {
                throw new IllegalStateException("WorldsConfigManager is not loaded!");
            }
            this.worldsConfig = new YamlConfiguration();
            this.worldConfigMap.forEach((worldName, worldConfig) -> {
                worldConfig.save().onFailure(e -> {
                    throw new RuntimeException("Failed to save world config: " + worldName, (Throwable)e);
                });
                this.worldsConfig.set(this.encodeWorldName((String)worldName), (Object)worldConfig.getConfigurationSection());
            });
            this.worldsConfig.save(this.worldConfigFile);
        }).onFailure(e -> CoreLogging.severe("Failed to save worlds.yml file: %s", e.getMessage()));
    }

    @NotNull
    public Option<WorldConfig> getWorldConfig(@NotNull String worldName) {
        return Option.of((WorldConfig)this.worldConfigMap.get(worldName));
    }

    @NotNull
    public WorldConfig addWorldConfig(@NotNull String worldName) {
        if (this.worldConfigMap.containsKey(worldName)) {
            throw new IllegalArgumentException("WorldConfig for world " + worldName + " already exists.");
        }
        WorldConfig worldConfig = new WorldConfig(worldName, this.getWorldConfigSection(worldName), this.multiverseCore);
        this.worldConfigMap.put(worldName, worldConfig);
        return worldConfig;
    }

    public void deleteWorldConfig(@NotNull String worldName) {
        this.worldConfigMap.remove(worldName);
        this.worldsConfig.set(this.encodeWorldName(worldName), null);
    }

    private ConfigurationSection getWorldConfigSection(String worldName) {
        return this.worldsConfig.isConfigurationSection(worldName = this.encodeWorldName(worldName)) ? this.worldsConfig.getConfigurationSection(worldName) : this.worldsConfig.createSection(worldName);
    }

    private String encodeWorldName(String worldName) {
        return worldName.replace(".", "[dot]");
    }

    private String decodeWorldName(String worldName) {
        return worldName.replace("[dot]", ".");
    }

    private static final class ConfigMigratedException
    extends RuntimeException {
        private ConfigMigratedException() {
            super("Config migrated");
        }
    }
}

