/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.result;

import com.google.common.collect.Iterables;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.core.utils.result.Result;
import org.mvplugins.multiverse.core.utils.result.SuccessReason;
import org.mvplugins.multiverse.external.vavr.control.Option;

public class ResultChain {
    private final boolean isSuccess;
    private final List<Result<?, ?>> results;

    public static Builder builder() {
        return new Builder(true);
    }

    public static Builder builder(boolean stopOnFailure) {
        return new Builder(stopOnFailure);
    }

    ResultChain(boolean isSuccess, List<Result<?, ?>> results) {
        this.isSuccess = isSuccess;
        this.results = results;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public boolean isFailure() {
        return !this.isSuccess;
    }

    public ResultChain onSuccess(Runnable successRunnable) {
        if (this.isSuccess) {
            successRunnable.run();
        }
        return this;
    }

    public ResultChain onFailure(Runnable failureRunnable) {
        if (this.isFailure()) {
            failureRunnable.run();
        }
        return this;
    }

    public ResultChain onSuccess(Consumer<ResultChain> successRunnable) {
        if (this.isSuccess) {
            successRunnable.accept(this);
        }
        return this;
    }

    public ResultChain onFailure(Consumer<ResultChain> failureRunnable) {
        if (this.isFailure()) {
            failureRunnable.accept(this);
        }
        return this;
    }

    public <S extends SuccessReason> ResultChain onSuccessReason(Class<S> successReasonClass, Consumer<S> successConsumer) {
        this.getSuccessReason(successReasonClass).peek((Consumer)successConsumer);
        return this;
    }

    public <F extends FailureReason> ResultChain onFailureReason(Class<F> failureReasonClass, Consumer<F> failureConsumer) {
        this.getFailureReason(failureReasonClass).peek((Consumer)failureConsumer);
        return this;
    }

    public <S extends SuccessReason> ResultChain onSuccessReason(S successReason, Runnable successRunnable) {
        this.getSuccessReason(successReason.getClass()).filter((Predicate<SuccessReason>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/mvplugins/multiverse/core/utils/result/SuccessReason;)Z)(successReason)).peek(reason -> successRunnable.run());
        return this;
    }

    public <S extends SuccessReason> Option<S> getSuccessReason(Class<S> successReasonClass) {
        if (this.isFailure()) {
            return Option.none();
        }
        return Option.ofOptional(this.results.stream().map(Result::getSuccessReason).filter(successReasonClass::isInstance).map(successReasonClass::cast).findFirst());
    }

    public <F extends FailureReason> Option<F> getFailureReason(Class<F> failureReasonClass) {
        if (this.isSuccess()) {
            return Option.none();
        }
        return Option.ofOptional(this.results.stream().map(Result::getFailureReason).filter(failureReasonClass::isInstance).map(failureReasonClass::cast).findFirst());
    }

    public Message getLastResultMessage() {
        return ((Result)Iterables.getLast(this.results)).getReasonMessage();
    }

    public String toString() {
        return "ResultGroup{isSuccess=" + this.isSuccess + ", results={" + this.results.stream().map(Objects::toString).collect(Collectors.joining(", ")) + "}}";
    }

    public static class Builder {
        private final boolean stopOnFailure;
        private final List<Result<?, ?>> results;
        private boolean isSuccess = true;

        public Builder(boolean stopOnFailure) {
            this.stopOnFailure = stopOnFailure;
            this.results = new ArrayList();
        }

        public Builder then(Supplier<Result<?, ?>> resultSupplier) {
            if (!this.isSuccess && this.stopOnFailure) {
                return this;
            }
            Result<?, ?> result = resultSupplier.get();
            if (result.isFailure()) {
                this.isSuccess = false;
            }
            this.results.add(result);
            return this;
        }

        public ResultChain build() {
            return new ResultChain(this.isSuccess, this.results);
        }
    }
}

