/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.result;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mvplugins.multiverse.core.utils.result.AsyncAttempt;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.AttemptsAggregate;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;

public final class AsyncAttemptsAggregate<T, F extends FailureReason> {
    private final List<AsyncAttempt<T, F>> attempts;
    private final CompletableFuture<AttemptsAggregate<T, F>> future;

    public static <T, F extends FailureReason> AsyncAttemptsAggregate<T, F> allOf(List<AsyncAttempt<T, F>> attempts) {
        return new AsyncAttemptsAggregate<T, F>(attempts);
    }

    public static <T, F extends FailureReason> AsyncAttemptsAggregate<T, F> allOf(AsyncAttempt<T, F> ... attempts) {
        return AsyncAttemptsAggregate.allOf(List.of(attempts));
    }

    @ApiStatus.AvailableSince(value="5.1")
    public static <T, F extends FailureReason> AsyncAttemptsAggregate<T, F> allOfAggregate(List<AsyncAttemptsAggregate<T, F>> attempts) {
        return new AsyncAttemptsAggregate<T, F>(attempts.stream().flatMap(a -> a.attempts.stream()).toList());
    }

    @ApiStatus.AvailableSince(value="5.1")
    public static <T, F extends FailureReason> AsyncAttemptsAggregate<T, F> allOfAggregate(AsyncAttemptsAggregate<T, F> ... attempts) {
        return AsyncAttemptsAggregate.allOfAggregate(List.of(attempts));
    }

    public static <T, F extends FailureReason> AsyncAttemptsAggregate<T, F> emptySuccess() {
        return new AsyncAttemptsAggregate<T, F>(Collections.emptyList(), CompletableFuture.completedFuture(AttemptsAggregate.emptySuccess()));
    }

    private AsyncAttemptsAggregate(List<AsyncAttempt<T, F>> attempts) {
        this.attempts = attempts;
        this.future = CompletableFuture.allOf((CompletableFuture[])attempts.stream().map(AsyncAttempt::getFuture).toArray(CompletableFuture[]::new)).thenApply(v -> AttemptsAggregate.allOf(attempts.stream().map(AsyncAttempt::getFuture).map(CompletableFuture::join).toList()));
    }

    private AsyncAttemptsAggregate(List<AsyncAttempt<T, F>> attempts, CompletableFuture<AttemptsAggregate<T, F>> future) {
        this.attempts = attempts;
        this.future = future;
    }

    @ApiStatus.AvailableSince(value="5.1")
    public List<AsyncAttempt<T, F>> getAttempts() {
        return this.attempts.stream().toList();
    }

    public AsyncAttemptsAggregate<T, F> onSuccess(Runnable runnable) {
        return this.newFuture((CompletableFuture<AttemptsAggregate<T, F>>)this.future.thenApply(aggregate -> aggregate.onSuccess(runnable)));
    }

    public AsyncAttemptsAggregate<T, F> onFailure(Runnable runnable) {
        return this.newFuture((CompletableFuture<AttemptsAggregate<T, F>>)this.future.thenApply(aggregate -> aggregate.onFailure(runnable)));
    }

    public AsyncAttemptsAggregate<T, F> onSuccess(Consumer<List<Attempt<T, F>>> successConsumer) {
        return this.newFuture((CompletableFuture<AttemptsAggregate<T, F>>)this.future.thenApply(aggregate -> aggregate.onSuccess(successConsumer)));
    }

    public AsyncAttemptsAggregate<T, F> onFailure(Consumer<List<Attempt<T, F>>> failureConsumer) {
        return this.newFuture((CompletableFuture<AttemptsAggregate<T, F>>)this.future.thenApply(aggregate -> aggregate.onFailure(failureConsumer)));
    }

    public AsyncAttemptsAggregate<T, F> onSuccessCount(Consumer<Integer> successConsumer) {
        return this.newFuture((CompletableFuture<AttemptsAggregate<T, F>>)this.future.thenApply(aggregate -> aggregate.onSuccessCount(successConsumer)));
    }

    public AsyncAttemptsAggregate<T, F> onFailureCount(Consumer<Map<F, Long>> failureConsumer) {
        return this.newFuture((CompletableFuture<AttemptsAggregate<T, F>>)this.future.thenApply(aggregate -> aggregate.onFailureCount(failureConsumer)));
    }

    @ApiStatus.AvailableSince(value="5.1")
    public AsyncAttemptsAggregate<T, F> thenRun(Runnable runnable) {
        return this.newFuture((CompletableFuture<AttemptsAggregate<T, F>>)this.future.thenApply(aggregate -> {
            runnable.run();
            return aggregate;
        }));
    }

    private AsyncAttemptsAggregate<T, F> newFuture(CompletableFuture<AttemptsAggregate<T, F>> future) {
        return new AsyncAttemptsAggregate<T, F>(this.attempts, future);
    }
}

