/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.position;

import org.bukkit.Location;
import org.mvplugins.multiverse.core.exceptions.utils.position.PositionParseException;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.utils.position.FaceDirection;
import org.mvplugins.multiverse.core.utils.position.VectorPosition;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="5.3")
public class EntityPosition {
    private final VectorPosition vector;
    private final FaceDirection direction;

    @ApiStatus.AvailableSince(value="5.3")
    public static EntityPosition ofAbsolute(double x, double y, double z, double pitch, double yaw) {
        return new EntityPosition(VectorPosition.ofAbsolute(x, y, z), FaceDirection.ofAbsolute(pitch, yaw));
    }

    @ApiStatus.AvailableSince(value="5.3")
    public static EntityPosition ofLocation(Location location) {
        return new EntityPosition(VectorPosition.ofLocation(location), FaceDirection.ofLocation(location));
    }

    @ApiStatus.AvailableSince(value="5.3")
    public static EntityPosition fromString(String positionStr) throws PositionParseException {
        String[] parts = REPatterns.COLON.split(positionStr, 2);
        return parts.length == 2 ? new EntityPosition(VectorPosition.fromString(parts[0]), FaceDirection.fromString(parts[1])) : new EntityPosition(VectorPosition.fromString(parts[0]), FaceDirection.ofAbsolute(0.0, 0.0));
    }

    @ApiStatus.AvailableSince(value="5.3")
    public EntityPosition(VectorPosition vector, FaceDirection direction) {
        this.vector = vector;
        this.direction = direction;
    }

    @ApiStatus.AvailableSince(value="5.3")
    public VectorPosition getVector() {
        return this.vector;
    }

    @ApiStatus.AvailableSince(value="5.3")
    public FaceDirection getDirection() {
        return this.direction;
    }

    @ApiStatus.AvailableSince(value="5.3")
    public void augmentBukkitLocation(Location base) {
        this.vector.augmentBukkitLocation(base);
        this.direction.augmentBukkitLocation(base);
    }

    @ApiStatus.AvailableSince(value="5.3")
    public Location toBukkitLocation(Location base) {
        return new Location(base.getWorld(), this.vector.getX().getValue(base.getX()), this.vector.getY().getValue(base.getY()), this.vector.getZ().getValue(base.getZ()), (float)this.direction.getYaw().getValue(base.getYaw()), (float)this.direction.getPitch().getValue(base.getPitch()));
    }

    public String toString() {
        return String.valueOf(this.vector) + ":" + String.valueOf(this.direction);
    }
}

