/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Try;

public final class PlayerFinder {
    private static final List<String> VANILLA_SELECTORS = List.of("@a", "@e", "@r", "@p", "@s");

    @Nullable
    public static Player get(@Nullable String playerIdentifier) {
        return PlayerFinder.get(playerIdentifier, (CommandSender)Bukkit.getConsoleSender());
    }

    @Nullable
    public static Player get(@Nullable String playerIdentifier, @NotNull CommandSender sender) {
        if (playerIdentifier == null) {
            return null;
        }
        Player targetPlayer = PlayerFinder.getByName(playerIdentifier);
        if (targetPlayer != null) {
            return targetPlayer;
        }
        targetPlayer = PlayerFinder.getByUuid(playerIdentifier);
        if (targetPlayer != null) {
            return targetPlayer;
        }
        return PlayerFinder.getBySelector(playerIdentifier, sender);
    }

    @NotNull
    public static List<Player> getMulti(@Nullable String playerIdentifiers) {
        return PlayerFinder.getMulti(playerIdentifiers, (CommandSender)Bukkit.getConsoleSender());
    }

    @NotNull
    public static List<Player> getMulti(@Nullable String playerIdentifiers, @NotNull CommandSender sender) {
        return PlayerFinder.tryGetMulti(playerIdentifiers, sender).getOrElse(Collections.emptyList());
    }

    @ApiStatus.AvailableSince(value="5.4")
    @NotNull
    public static @NotNull Try<@NotNull List<Player>> tryGetMulti(@Nullable String playerIdentifiers, @NotNull CommandSender sender) {
        String[] playerIdentifierArray;
        if (playerIdentifiers == null || Strings.isNullOrEmpty((String)playerIdentifiers)) {
            return Try.success(Collections.emptyList());
        }
        if (PlayerFinder.isSelector(playerIdentifiers)) {
            return PlayerFinder.tryGetMultiBySelector(playerIdentifiers, sender);
        }
        ArrayList<Player> playerResults = new ArrayList<Player>();
        for (String playerIdentifier : playerIdentifierArray = REPatterns.COMMA.split(playerIdentifiers)) {
            Player targetPlayer = PlayerFinder.getByName(playerIdentifier);
            if (targetPlayer != null) {
                playerResults.add(targetPlayer);
                continue;
            }
            targetPlayer = PlayerFinder.getByUuid(playerIdentifier);
            if (targetPlayer != null) {
                playerResults.add(targetPlayer);
                continue;
            }
            Try<@NotNull List<Player>> selectorParseResult = PlayerFinder.tryGetMultiBySelector(playerIdentifier, sender);
            if (selectorParseResult.isFailure()) {
                return Try.failure(selectorParseResult.getCause());
            }
            playerResults.addAll(selectorParseResult.getOrElse(Collections.emptyList()));
        }
        return Try.success(playerResults);
    }

    @ApiStatus.AvailableSince(value="5.4")
    public static boolean isSelector(@NotNull String playerIdentifier) {
        return VANILLA_SELECTORS.stream().anyMatch(playerIdentifier::startsWith);
    }

    @Nullable
    public static Player getByName(@NotNull String playerName) {
        return Bukkit.getPlayerExact((String)playerName);
    }

    @Nullable
    public static Player getByUuid(@NotNull String playerUuid) {
        UUID uuid;
        if (!REPatterns.UUID.matcher(playerUuid).matches()) {
            return null;
        }
        try {
            uuid = UUID.fromString(playerUuid);
        }
        catch (Exception e) {
            return null;
        }
        return PlayerFinder.getByUuid(uuid);
    }

    @Nullable
    public static Player getByUuid(@NotNull UUID playerUuid) {
        return Bukkit.getPlayer((UUID)playerUuid);
    }

    @Nullable
    public static Player getBySelector(@NotNull String playerSelector, @NotNull CommandSender sender) {
        List<Player> matchedPlayers = PlayerFinder.getMultiBySelector(playerSelector, sender);
        if (matchedPlayers.isEmpty()) {
            CoreLogging.fine("No player found with selector '%s' for %s.", playerSelector, sender.getName());
            return null;
        }
        if (matchedPlayers.size() > 1) {
            CoreLogging.warning("Ambiguous selector result '%s' for %s (more than one player matched) - %s", playerSelector, sender.getName(), matchedPlayers.toString());
            return null;
        }
        return matchedPlayers.get(0);
    }

    @NotNull
    public static List<Player> getMultiBySelector(@NotNull String playerSelector, @NotNull CommandSender sender) {
        return PlayerFinder.tryGetMultiBySelector(playerSelector, sender).onFailure(throwable -> CoreLogging.warning("Error selecting entities with selector '%s' for %s: %s", playerSelector, sender.getName(), throwable.getMessage())).getOrElse(Collections::emptyList);
    }

    @ApiStatus.AvailableSince(value="5.4")
    @NotNull
    public static @NotNull Try<@NotNull List<Player>> tryGetMultiBySelector(@NotNull String playerSelector, @NotNull CommandSender sender) {
        if (playerSelector.charAt(0) != '@') {
            return Try.success(Collections.emptyList());
        }
        return Try.of(() -> Bukkit.selectEntities((CommandSender)sender, (String)playerSelector).stream().filter(e -> e instanceof Player).map(e -> (Player)e).collect(Collectors.toList()));
    }
}

