/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.vavr.control.Try;

@ApiStatus.AvailableSince(value="5.1")
public final class MinecraftTimeFormatter {
    private static final double TIME_MULTIPLIER = 3.6;
    private static final long DAY_SECONDS = 86400L;
    private static final long START_OFFSET = 21600L;

    @ApiStatus.AvailableSince(value="5.1")
    public static String format12h(long time) {
        return MinecraftTimeFormatter.formatTime(time, "hh:mm a");
    }

    @ApiStatus.AvailableSince(value="5.1")
    public static String format24h(long time) {
        return MinecraftTimeFormatter.formatTime(time, "HH:mm");
    }

    @ApiStatus.AvailableSince(value="5.1")
    public static String formatTime(long time, String format) {
        long realTime = (long)((double)time * 3.6 + 21600.0) % 86400L;
        LocalTime localTime = LocalTime.ofSecondOfDay(realTime);
        return (String)((Object)Try.of(() -> DateTimeFormatter.ofPattern(format)).map(localTime::format).getOrElse("invalid time format: " + format));
    }

    private MinecraftTimeFormatter() {
        throw new UnsupportedOperationException();
    }
}

