/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.teleportation;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.event.MVTeleportDestinationEvent;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.teleportation.BlockSafety;
import org.mvplugins.multiverse.core.teleportation.PassengerMode;
import org.mvplugins.multiverse.core.teleportation.PassengerModes;
import org.mvplugins.multiverse.core.teleportation.TeleportFailureReason;
import org.mvplugins.multiverse.core.teleportation.TeleportQueue;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.result.AsyncAttempt;
import org.mvplugins.multiverse.core.utils.result.AsyncAttemptsAggregate;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.external.acf.commands.BukkitCommandIssuer;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.paperlib.PaperLib;
import org.mvplugins.multiverse.external.vavr.control.Either;
import org.mvplugins.multiverse.external.vavr.control.Try;

public final class AsyncSafetyTeleporterAction {
    @NotNull
    private final MultiverseCore multiverseCore;
    private final BlockSafety blockSafety;
    private final TeleportQueue teleportQueue;
    private final PluginManager pluginManager;
    @NotNull
    private final Either<Location, DestinationInstance<?, ?>> locationOrDestination;
    private boolean checkSafety;
    private PassengerMode passengerMode = PassengerModes.DEFAULT;
    @Nullable
    private CommandSender teleporter = null;

    AsyncSafetyTeleporterAction(@NotNull MultiverseCore multiverseCore, @NotNull BlockSafety blockSafety, @NotNull TeleportQueue teleportQueue, @NotNull PluginManager pluginManager, @NotNull Either<Location, DestinationInstance<?, ?>> locationOrDestination) {
        this.multiverseCore = multiverseCore;
        this.blockSafety = blockSafety;
        this.teleportQueue = teleportQueue;
        this.pluginManager = pluginManager;
        this.locationOrDestination = locationOrDestination;
        this.checkSafety = locationOrDestination.fold(location -> true, destination -> destination != null && destination.checkTeleportSafety());
    }

    public AsyncSafetyTeleporterAction checkSafety(boolean checkSafety) {
        this.checkSafety = checkSafety;
        return this;
    }

    @ApiStatus.AvailableSince(value="5.1")
    public AsyncSafetyTeleporterAction passengerMode(@NotNull PassengerMode passengerMode) {
        this.passengerMode = passengerMode;
        return this;
    }

    public AsyncSafetyTeleporterAction by(@NotNull BukkitCommandIssuer issuer) {
        return this.by(issuer.getIssuer());
    }

    public AsyncSafetyTeleporterAction by(@NotNull CommandSender teleporter) {
        this.teleporter = teleporter;
        return this;
    }

    public <T extends Entity> AsyncAttemptsAggregate<Void, TeleportFailureReason> teleport(@NotNull List<T> teleportees) {
        return AsyncAttemptsAggregate.allOfAggregate(teleportees.stream().map(this::teleportSingle).toList());
    }

    @ApiStatus.AvailableSince(value="5.1")
    public AsyncAttemptsAggregate<Void, TeleportFailureReason> teleportSingle(@NotNull Entity teleportee) {
        Entity localTeleporter = this.teleporter == null ? teleportee : this.teleporter;
        return this.getLocation(teleportee).mapAttempt(this::doSafetyCheck).onSuccess(() -> this.lambda$teleportSingle$2(teleportee, (CommandSender)localTeleporter)).transform(location -> this.doAsyncTeleport(teleportee, (Location)location), failure -> AsyncAttemptsAggregate.allOf(AsyncAttempt.failure(failure, new MessageReplacement[0]))).thenRun(() -> {
            if (teleportee instanceof Player) {
                Player player = (Player)teleportee;
                this.teleportQueue.popFromQueue(player.getName());
            }
        });
    }

    @Deprecated(forRemoval=true, since="5.1")
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public AsyncAttempt<Void, TeleportFailureReason> teleport(@NotNull Entity teleportee) {
        return this.teleportSingle(teleportee).getAttempts().get(0);
    }

    private Attempt<Location, TeleportFailureReason> getLocation(@NotNull Entity teleportee) {
        return this.locationOrDestination.fold(this::parseLocation, destination -> this.parseDestination(teleportee, (DestinationInstance<?, ?>)destination));
    }

    private Attempt<Location, TeleportFailureReason> parseLocation(@Nullable Location location) {
        if (location == null) {
            return Attempt.failure(TeleportFailureReason.NULL_LOCATION, new MessageReplacement[0]);
        }
        return Try.of(() -> location.getWorld().getName()).map(ignore -> Attempt.success(location)).getOrElse(Attempt.failure(TeleportFailureReason.NULL_WORLD, new MessageReplacement[0]));
    }

    private Attempt<Location, TeleportFailureReason> parseDestination(@NotNull Entity teleportee, @Nullable DestinationInstance<?, ?> destination) {
        if (destination == null) {
            return Attempt.failure(TeleportFailureReason.NULL_DESTINATION, new MessageReplacement[0]);
        }
        MVTeleportDestinationEvent event = new MVTeleportDestinationEvent(destination, teleportee, this.teleporter);
        this.pluginManager.callEvent((Event)event);
        if (event.isCancelled()) {
            return Attempt.failure(TeleportFailureReason.EVENT_CANCELLED, new MessageReplacement[0]);
        }
        return this.parseLocation((Location)destination.getLocation(teleportee).getOrNull());
    }

    private Attempt<Location, TeleportFailureReason> doSafetyCheck(@NotNull Location location) {
        if (!this.checkSafety) {
            return Attempt.success(location);
        }
        Location safeLocation = this.blockSafety.findSafeSpawnLocation(location);
        if (safeLocation == null) {
            return Attempt.failure(TeleportFailureReason.UNSAFE_LOCATION, new MessageReplacement[0]);
        }
        return Attempt.success(safeLocation);
    }

    private AsyncAttemptsAggregate<Void, TeleportFailureReason> doAsyncTeleport(@NotNull Entity teleportee, @NotNull Location location) {
        Entity vehicle;
        if (this.passengerMode.isDismountVehicle() && teleportee.isInsideVehicle() && (vehicle = teleportee.getVehicle()) != null) {
            return this.doVehicleTeleport(teleportee, location, vehicle);
        }
        List passengers = teleportee.getPassengers();
        if (this.passengerMode.isDismountPassengers() && !passengers.isEmpty()) {
            passengers.forEach(arg_0 -> ((Entity)teleportee).removePassenger(arg_0));
            if (this.passengerMode.isPassengersFollow()) {
                return this.doPassengersTeleport(teleportee, location, passengers);
            }
        }
        return AsyncAttemptsAggregate.allOf(this.doSingleTeleport(teleportee, location));
    }

    private AsyncAttemptsAggregate<Void, TeleportFailureReason> doVehicleTeleport(@NotNull Entity teleportee, @NotNull Location location, @NotNull Entity vehicle) {
        if (this.passengerMode.isVehicleFollow()) {
            return this.doPassengersTeleport(vehicle, location, vehicle.getPassengers());
        }
        teleportee.leaveVehicle();
        return this.doAsyncTeleport(teleportee, location);
    }

    private AsyncAttemptsAggregate<Void, TeleportFailureReason> doPassengersTeleport(@NotNull Entity teleportee, @NotNull Location location, @NotNull List<Entity> passengers) {
        ArrayList<Entity> toTeleport = new ArrayList<Entity>(passengers);
        toTeleport.addFirst(teleportee);
        return AsyncAttemptsAggregate.allOfAggregate(toTeleport.stream().map(passenger -> this.doAsyncTeleport((Entity)passenger, location)).toList()).onSuccess(() -> Bukkit.getScheduler().runTask((Plugin)this.multiverseCore, () -> {
            passengers.forEach(arg_0 -> ((Entity)teleportee).addPassenger(arg_0));
            CoreLogging.finer("Mounted %d passengers to %s", passengers.size(), teleportee.getName());
        }));
    }

    private AsyncAttempt<Void, TeleportFailureReason> doSingleTeleport(@NotNull Entity teleportee, @NotNull Location location) {
        return AsyncAttempt.of(PaperLib.teleportAsync(teleportee, location), exception -> {
            CoreLogging.warning("Failed to teleport %s to %s: %s", teleportee.getName(), location, exception.getMessage());
            return Attempt.failure(TeleportFailureReason.TELEPORT_FAILED_EXCEPTION, new MessageReplacement[0]);
        }).mapAttempt(success -> {
            if (success.booleanValue()) {
                this.applyPostTeleportVelocity(teleportee);
                CoreLogging.finer("Teleported async %s to %s", teleportee.getName(), location);
                return Attempt.success(null);
            }
            CoreLogging.warning("Failed to async teleport %s to %s", teleportee.getName(), location);
            return Attempt.failure(TeleportFailureReason.TELEPORT_FAILED, new MessageReplacement[0]);
        });
    }

    private void applyPostTeleportVelocity(@NotNull Entity teleportee) {
        this.locationOrDestination.peek(destination -> destination.getVelocity(teleportee).peek(velocity -> Bukkit.getScheduler().runTaskLater((Plugin)this.multiverseCore, () -> teleportee.setVelocity(velocity), 1L)));
    }

    private /* synthetic */ void lambda$teleportSingle$2(Entity teleportee, CommandSender localTeleporter) {
        if (teleportee instanceof Player) {
            Player player = (Player)teleportee;
            this.teleportQueue.addToQueue(localTeleporter, player);
        }
    }
}

