/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.economy;

import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

final class VaultHandler
implements Listener {
    private Economy economy;
    private final MVCommandManager commandManager;

    VaultHandler(Plugin plugin, @NotNull MVCommandManager commandManager) {
        this.commandManager = commandManager;
        Bukkit.getPluginManager().registerEvents((Listener)new VaultListener(), plugin);
        this.setupVaultEconomy();
    }

    private boolean setupVaultEconomy() {
        if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
            RegisteredServiceProvider economyProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
            if (economyProvider != null) {
                CoreLogging.fine("Vault economy enabled.", new Object[0]);
                this.economy = (Economy)economyProvider.getProvider();
            } else {
                CoreLogging.finer("Vault economy not detected.", new Object[0]);
                this.economy = null;
            }
        } else {
            CoreLogging.finer("Vault was not found.", new Object[0]);
            this.economy = null;
        }
        return this.economy != null;
    }

    public boolean hasEconomy() {
        return this.economy != null;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    void showReceipt(Player player, double price) {
        if (price > 0.0) {
            this.commandManager.getCommandIssuer(player).sendInfo((MessageKeyProvider)MVCorei18n.ECONOMY_VAULT_WITHDRAW, MessageReplacement.replace("{price}").with(this.economy.format(price)));
        } else if (price < 0.0) {
            this.commandManager.getCommandIssuer(player).sendInfo((MessageKeyProvider)MVCorei18n.ECONOMY_VAULT_DEPOSIT, MessageReplacement.replace("{price}").with(this.economy.format(price)));
        }
    }

    private final class VaultListener
    implements Listener {
        private VaultListener() {
        }

        @EventHandler
        private void vaultEnabled(PluginEnableEvent event) {
            if (event.getPlugin().getName().equals("Vault")) {
                VaultHandler.this.setupVaultEconomy();
            }
        }

        @EventHandler
        private void vaultDisabled(PluginDisableEvent event) {
            if (event.getPlugin().getName().equals("Vault")) {
                CoreLogging.fine("Vault economy disabled", new Object[0]);
                VaultHandler.this.economy = null;
            }
        }
    }
}

