/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination.core;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.core.ExactDestination;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.position.EntityPosition;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Option;

public final class ExactDestinationInstance
extends DestinationInstance<ExactDestinationInstance, ExactDestination> {
    private final WorldManager worldManager;
    private final String worldName;
    private final EntityPosition position;

    ExactDestinationInstance(@NotNull ExactDestination destination, @NotNull WorldManager worldManager, @NotNull String worldName, @NotNull EntityPosition position) {
        super(destination);
        this.worldManager = worldManager;
        this.worldName = worldName;
        this.position = position;
    }

    @Override
    @NotNull
    public Option<Location> getLocation(@NotNull Entity teleportee) {
        World world = Bukkit.getWorld((String)this.worldName);
        if (world == null) {
            return Option.none();
        }
        Location destinationLocation = this.position.toBukkitLocation(teleportee.getLocation());
        destinationLocation.setWorld(world);
        return Option.of(destinationLocation);
    }

    @Override
    @NotNull
    public Option<Vector> getVelocity(@NotNull Entity teleportee) {
        return Option.none();
    }

    @Override
    public boolean checkTeleportSafety() {
        return false;
    }

    @Override
    @NotNull
    public Option<String> getFinerPermissionSuffix() {
        return Option.of(this.worldName);
    }

    @Override
    @NotNull
    public Message getDisplayMessage() {
        String displayWorldName = this.worldManager.getWorld(this.worldName).map(MultiverseWorld::getAliasOrName).getOrElse(this.worldName);
        return Message.of(displayWorldName + " at " + this.position.toString(), new MessageReplacement[0]);
    }

    @Override
    @NotNull
    public String serialise() {
        return this.worldName + ":" + this.position.toString();
    }
}

