/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.anchor.AnchorManager;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Single;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class AnchorSetCommand
extends CoreCommand {
    private final AnchorManager anchorManager;
    private final LocationManipulation locationManipulation;

    @Inject
    AnchorSetCommand(@NotNull AnchorManager anchorManager, @NotNull LocationManipulation locationManipulation) {
        this.anchorManager = anchorManager;
        this.locationManipulation = locationManipulation;
    }

    @Subcommand(value="anchor set")
    @CommandPermission(value="multiverse.core.anchor.create")
    @CommandCompletion(value="@empty @locations")
    @Syntax(value="<name> [location]")
    @Description(value="")
    void onAnchorSetCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerOnly") Player player, @Single @Syntax(value="<name>") @Description(value="") String anchorName) {
        Location anchorLocation = player.getLocation();
        if (this.anchorManager.setAnchor(anchorName, anchorLocation).isSuccess()) {
            this.sendAnchorSetSuccessMessage(issuer, anchorName, this.locationManipulation.locationToString(anchorLocation));
        } else {
            this.sendAnchorSetFailedMessage(issuer, anchorName);
        }
    }

    @Subcommand(value="anchor set")
    @CommandPermission(value="multiverse.core.anchor.create")
    @CommandCompletion(value="@anchornames @locations")
    @Syntax(value="<name> [location]")
    @Description(value="")
    void onAnchorSetCommand(MVCommandIssuer issuer, @Syntax(value="<name>") @Description(value="") String anchorName, @Single @Syntax(value="[location]") @Description(value="") String locationString) {
        if (this.anchorManager.setAnchor(anchorName, locationString).isSuccess()) {
            this.sendAnchorSetSuccessMessage(issuer, anchorName, locationString);
        } else {
            this.sendAnchorSetFailedMessage(issuer, anchorName);
        }
    }

    private void sendAnchorSetSuccessMessage(MVCommandIssuer issuer, String anchorName, String locationString) {
        issuer.sendMessage("&aAnchor &f" + anchorName + "&a set to &f" + locationString);
    }

    private void sendAnchorSetFailedMessage(MVCommandIssuer issuer, String anchorName) {
        issuer.sendMessage("&cFailed to set anchor &f" + anchorName + ".");
    }
}

