/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.bukkit.command.CommandSender;
import org.mvplugins.multiverse.core.permissions.CorePermissionsChecker;
import org.mvplugins.multiverse.core.permissions.PermissionUtils;
import org.mvplugins.multiverse.external.acf.commands.CommandIssuer;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;

@Service
public class MVCommandPermissions {
    private final Map<String, Predicate<CommandIssuer>> permissionsCheckMap = new HashMap<String, Predicate<CommandIssuer>>();

    @Inject
    MVCommandPermissions(@NotNull CorePermissionsChecker permissionsChecker) {
        this.registerPermissionChecker("mvteleport", issuer -> permissionsChecker.hasAnyTeleportPermission((CommandSender)issuer.getIssuer()));
        this.registerPermissionChecker("mvteleportother", issuer -> permissionsChecker.hasAnyTeleportPermission((CommandSender)issuer.getIssuer(), CorePermissionsChecker.Scope.OTHER));
        this.registerPermissionChecker("mvspawn", issuer -> permissionsChecker.hasAnySpawnPermission((CommandSender)issuer.getIssuer()));
        this.registerPermissionChecker("mvspawnother", issuer -> permissionsChecker.hasAnySpawnPermission((CommandSender)issuer.getIssuer(), CorePermissionsChecker.Scope.OTHER));
    }

    public void registerPermissionChecker(String id, Predicate<CommandIssuer> checker) {
        this.permissionsCheckMap.put(MVCommandPermissions.prepareId(id), checker);
    }

    @NotNull
    private static String prepareId(String id) {
        return (id.startsWith("@") ? "" : "@") + id.toLowerCase(Locale.ENGLISH);
    }

    boolean hasPermission(CommandIssuer issuer, String permission) {
        return Option.of(this.permissionsCheckMap.get(permission)).map(checker -> checker.test(issuer)).getOrElse(() -> PermissionUtils.hasPermission((CommandSender)issuer.getIssuer(), permission));
    }
}

