/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.hikari.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uhfinn.dailyrewardsplus.hikari.HikariConfig;

public final class PropertyElf {
    private PropertyElf() {
    }

    public static void setTargetFromProperties(Object object, Properties properties) {
        if (object == null || properties == null) {
            return;
        }
        List<Method> list = Arrays.asList(object.getClass().getMethods());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object2, object3) -> {
            String string = object2.toString();
            if (object instanceof HikariConfig && string.startsWith("dataSource.")) {
                ((HikariConfig)object).addDataSourceProperty(string.substring("dataSource.".length()), object3);
            } else {
                PropertyElf.setProperty(object, string, object3, list);
            }
        }));
    }

    public static Set<String> getPropertyNames(Class<?> clazz) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Method method : clazz.getMethods()) {
            String string = PropertyElf.propertyNameFromGetterName(method.getName());
            try {
                if (method.getParameterTypes().length != 0 || string == null) continue;
                clazz.getMethod("set" + PropertyElf.capitalizedPropertyName(string), method.getReturnType());
                hashSet.add(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashSet;
    }

    public static Object getProperty(String string, Object object) {
        try {
            String string2 = "get" + PropertyElf.capitalizedPropertyName(string);
            Method method = object.getClass().getMethod(string2, new Class[0]);
            return method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            try {
                String string3 = "is" + PropertyElf.capitalizedPropertyName(string);
                Method method = object.getClass().getMethod(string3, new Class[0]);
                return method.invoke(object, new Object[0]);
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static Properties copyProperties(Properties properties) {
        Properties properties2 = new Properties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> properties2.setProperty(object.toString(), object2.toString())));
        return properties2;
    }

    private static String propertyNameFromGetterName(String string) {
        String string2 = null;
        if (string.startsWith("get") && string.length() > 3) {
            string2 = string.substring(3);
        } else if (string.startsWith("is") && string.length() > 2) {
            string2 = string.substring(2);
        }
        if (string2 != null) {
            return Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
        }
        return null;
    }

    private static void setProperty(Object object, String string, Object object2, List<Method> list) {
        Object object3;
        Logger logger = LoggerFactory.getLogger(PropertyElf.class);
        String string2 = "set" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
        Method method2 = list.stream().filter(method -> method.getName().equals(string2) && method.getParameterCount() == 1).findFirst().orElse(null);
        if (method2 == null) {
            object3 = "set" + string.toUpperCase(Locale.ENGLISH);
            method2 = list.stream().filter(arg_0 -> PropertyElf.lambda$setProperty$3((String)object3, arg_0)).findFirst().orElse(null);
        }
        if (method2 == null) {
            logger.error("Property {} does not exist on target {}", (Object)string, (Object)object.getClass());
            throw new RuntimeException(String.format("Property %s does not exist on target %s", string, object.getClass()));
        }
        try {
            object3 = method2.getParameterTypes()[0];
            if (object3 == Integer.TYPE) {
                method2.invoke(object, Integer.parseInt(object2.toString()));
            } else if (object3 == Long.TYPE) {
                method2.invoke(object, Long.parseLong(object2.toString()));
            } else if (object3 == Short.TYPE) {
                method2.invoke(object, Short.parseShort(object2.toString()));
            } else if (object3 == Boolean.TYPE || object3 == Boolean.class) {
                method2.invoke(object, Boolean.parseBoolean(object2.toString()));
            } else if (((Class)object3).isArray() && Character.TYPE.isAssignableFrom(((Class)object3).getComponentType())) {
                method2.invoke(object, new Object[]{object2.toString().toCharArray()});
            } else if (object3 == String.class) {
                method2.invoke(object, object2.toString());
            } else {
                try {
                    logger.debug("Try to create a new instance of \"{}\"", object2);
                    method2.invoke(object, Class.forName(object2.toString()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ClassNotFoundException | InstantiationException reflectiveOperationException) {
                    logger.debug("Class \"{}\" not found or could not instantiate it (Default constructor)", object2);
                    method2.invoke(object, object2);
                }
            }
        }
        catch (Exception exception) {
            logger.error("Failed to set property {} on target {}", string, object.getClass(), exception);
            throw new RuntimeException(exception);
        }
    }

    private static String capitalizedPropertyName(String string) {
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    private static /* synthetic */ boolean lambda$setProperty$3(String string, Method method) {
        return method.getName().equals(string) && method.getParameterCount() == 1;
    }
}

