/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.hikari.pool;

import java.util.concurrent.ScheduledExecutorService;
import uhfinn.dailyrewardsplus.hikari.pool.PoolEntry;
import uhfinn.dailyrewardsplus.hikari.pool.ProxyLeakTask;

class ProxyLeakTaskFactory {
    private ScheduledExecutorService executorService;
    private long leakDetectionThreshold;

    ProxyLeakTaskFactory(long l, ScheduledExecutorService scheduledExecutorService) {
        this.executorService = scheduledExecutorService;
        this.leakDetectionThreshold = l;
    }

    ProxyLeakTask schedule(PoolEntry poolEntry) {
        return this.leakDetectionThreshold == 0L ? ProxyLeakTask.NO_LEAK : this.scheduleNewTask(poolEntry);
    }

    void updateLeakDetectionThreshold(long l) {
        this.leakDetectionThreshold = l;
    }

    private ProxyLeakTask scheduleNewTask(PoolEntry poolEntry) {
        ProxyLeakTask proxyLeakTask = new ProxyLeakTask(poolEntry);
        proxyLeakTask.schedule(this.executorService, this.leakDetectionThreshold);
        return proxyLeakTask;
    }
}

