/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.hikari.pool;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uhfinn.dailyrewardsplus.hikari.pool.PoolEntry;

class ProxyLeakTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyLeakTask.class);
    static final ProxyLeakTask NO_LEAK = new ProxyLeakTask(){

        @Override
        void schedule(ScheduledExecutorService scheduledExecutorService, long l) {
        }

        @Override
        public void run() {
        }

        @Override
        public void cancel() {
        }
    };
    private ScheduledFuture<?> scheduledFuture;
    private String connectionName;
    private Exception exception;
    private String threadName;
    private boolean isLeaked;

    ProxyLeakTask(PoolEntry poolEntry) {
        this.exception = new Exception("Apparent connection leak detected");
        this.threadName = Thread.currentThread().getName();
        this.connectionName = poolEntry.connection.toString();
    }

    private ProxyLeakTask() {
    }

    void schedule(ScheduledExecutorService scheduledExecutorService, long l) {
        this.scheduledFuture = scheduledExecutorService.schedule(this, l, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        this.isLeaked = true;
        StackTraceElement[] stackTraceElementArray = this.exception.getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length - 5];
        System.arraycopy(stackTraceElementArray, 5, stackTraceElementArray2, 0, stackTraceElementArray2.length);
        this.exception.setStackTrace(stackTraceElementArray2);
        LOGGER.warn("Connection leak detection triggered for {} on thread {}, stack trace follows", this.connectionName, this.threadName, this.exception);
    }

    void cancel() {
        this.scheduledFuture.cancel(false);
        if (this.isLeaked) {
            LOGGER.info("Previously reported leaked connection {} on thread {} was returned to the pool (unleaked)", (Object)this.connectionName, (Object)this.threadName);
        }
    }
}

