/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.hikari.metrics.dropwizard;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import uhfinn.dailyrewardsplus.hikari.HikariConfig;
import uhfinn.dailyrewardsplus.hikari.pool.HikariPool;

public final class CodahaleHealthChecker {
    public static void registerHealthChecks(HikariPool hikariPool, HikariConfig hikariConfig, HealthCheckRegistry healthCheckRegistry) {
        MetricRegistry metricRegistry;
        SortedMap sortedMap;
        Properties properties = hikariConfig.getHealthCheckProperties();
        long l = Long.parseLong(properties.getProperty("connectivityCheckTimeoutMs", String.valueOf(hikariConfig.getConnectionTimeout())));
        healthCheckRegistry.register(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "ConnectivityCheck"}), (HealthCheck)new ConnectivityHealthCheck(hikariPool, l));
        long l2 = Long.parseLong(properties.getProperty("expected99thPercentileMs", "0"));
        Object object = hikariConfig.getMetricRegistry();
        if (l2 > 0L && object instanceof MetricRegistry && !(sortedMap = (metricRegistry = (MetricRegistry)object).getTimers((string, metric) -> string.equals(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "Wait"})))).isEmpty()) {
            Timer timer = (Timer)sortedMap.entrySet().iterator().next().getValue();
            healthCheckRegistry.register(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "Connection99Percent"}), (HealthCheck)new Connection99Percent(timer, l2));
        }
    }

    private CodahaleHealthChecker() {
    }

    private static class Connection99Percent
    extends HealthCheck {
        private final Timer waitTimer;
        private final long expected99thPercentile;

        Connection99Percent(Timer timer, long l) {
            this.waitTimer = timer;
            this.expected99thPercentile = l;
        }

        protected HealthCheck.Result check() {
            long l = TimeUnit.NANOSECONDS.toMillis(Math.round(this.waitTimer.getSnapshot().get99thPercentile()));
            return l <= this.expected99thPercentile ? HealthCheck.Result.healthy() : HealthCheck.Result.unhealthy((String)"99th percentile connection wait time of %dms exceeds the threshold %dms", (Object[])new Object[]{l, this.expected99thPercentile});
        }
    }

    private static class ConnectivityHealthCheck
    extends HealthCheck {
        private final HikariPool pool;
        private final long checkTimeoutMs;

        ConnectivityHealthCheck(HikariPool hikariPool, long l) {
            this.pool = hikariPool;
            this.checkTimeoutMs = l > 0L && l != Integer.MAX_VALUE ? l : TimeUnit.SECONDS.toMillis(10L);
        }

        protected HealthCheck.Result check() {
            HealthCheck.Result result;
            block8: {
                Connection connection = this.pool.getConnection(this.checkTimeoutMs);
                try {
                    result = HealthCheck.Result.healthy();
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        return HealthCheck.Result.unhealthy((Throwable)sQLException);
                    }
                }
                connection.close();
            }
            return result;
        }
    }
}

