/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.Modules.PlayerData;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import uhfinn.dailyrewardsplus.Main;
import uhfinn.dailyrewardsplus.Modules.PlayerData.DataUser;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.CustomYMLFiles;

public class YMLHandler {
    public static void SetUp(Player player) {
        FileConfiguration fileConfiguration;
        Main.INSTANCE().debugger.debug("User-Set up call: " + player.getName() + ":" + player.getUniqueId(), 3);
        File file = new File(Main.INSTANCE().getDataFolder() + "/Data/Players");
        File file2 = new File(Main.INSTANCE().getDataFolder() + "/Data/Players/" + player.getUniqueId() + ".yml");
        FileConfiguration fileConfiguration2 = CustomYMLFiles.getCustomConfigFile("Config.yml");
        if (!file2.exists()) {
            Main.INSTANCE().debugger.debug("Setting up new users data file: " + player.getName(), 1);
            try {
                if (!file.exists()) {
                    file.mkdir();
                    Main.INSTANCE().debugger.debug("A path was not defined for the Player YML's, this has been created", 1);
                }
                file2.createNewFile();
                fileConfiguration = CustomYMLFiles.PlayerData(player, player.getUniqueId().toString());
                fileConfiguration.set("TotalRewards", (Object)0);
                fileConfiguration.set("LastReward", (Object)0L);
                fileConfiguration.set("NextReward", (Object)0L);
                fileConfiguration.set("Streaks.CurrentStreak", (Object)0);
                fileConfiguration.set("Streaks.CurrentAbsoluteStreak", (Object)0);
                fileConfiguration.set("Streaks.HighestStreak", (Object)0);
                fileConfiguration.set("MissedDays", (Object)new int[0]);
                if (fileConfiguration2.contains("PlaytimeRequirement") && fileConfiguration2.getBoolean("PlaytimeRequirement")) {
                    fileConfiguration.set("playTime", (Object)0L);
                    fileConfiguration.set("nextPlayTimeReset", (Object)0L);
                }
                fileConfiguration.set("RecentName", (Object)player.getName());
                fileConfiguration.save(file2);
                Main.INSTANCE().debugger.debug("A user data file was successfully set up for: " + player.getName() + ":" + player.getUniqueId(), 1);
            }
            catch (IOException iOException) {
                Main.INSTANCE().debugger.debug("A critical error occurred whilst initiating flat-file datastore for " + player.getName() + ":" + player.getUniqueId(), 0);
                return;
            }
        }
        if (!(fileConfiguration = CustomYMLFiles.PlayerData(player, player.getUniqueId().toString())).contains("MissedDays")) {
            try {
                fileConfiguration.set("MissedDays", (Object)new int[0]);
                fileConfiguration.save(file2);
                Main.INSTANCE().debugger.debug("Added MissedDays field to PlayerYML for " + player.getName(), 2);
            }
            catch (IOException iOException) {
                Main.INSTANCE().debugger.debug("Failed to add 'MissedDays' field to PlayerYML for " + player.getName() + ":" + player.getUniqueId(), 1);
                return;
            }
        }
        if (!fileConfiguration.contains("NextReward")) {
            try {
                fileConfiguration.set("NextReward", (Object)0L);
                fileConfiguration.save(file2);
                Main.INSTANCE().debugger.debug("Added NextReward field to PlayerYML for " + player.getName(), 2);
            }
            catch (IOException iOException) {
                Main.INSTANCE().debugger.debug("Failed to add 'NextReward' field to PlayerYML for " + player.getName() + ":" + player.getUniqueId(), 1);
                return;
            }
        }
        if (fileConfiguration2.contains("PlaytimeRequirement")) {
            if (fileConfiguration2.getBoolean("PlaytimeRequirement") && !fileConfiguration.contains("playTime")) {
                try {
                    fileConfiguration.set("playTime", (Object)0L);
                    fileConfiguration.save(file2);
                    Main.INSTANCE().debugger.debug("Added playTime field to PlayerYML for " + player.getName(), 2);
                }
                catch (IOException iOException) {
                    Main.INSTANCE().debugger.debug("Attempted to add 'playTime' field to PlayerYML for " + player.getName() + ":" + player.getUniqueId(), 1);
                    return;
                }
            }
            if (fileConfiguration2.getBoolean("PlaytimeRequirement") && !fileConfiguration.contains("nextPlayTimeReset")) {
                try {
                    fileConfiguration.set("nextPlayTimeReset", (Object)0L);
                    fileConfiguration.save(file2);
                    Main.INSTANCE().debugger.debug("Added nextPlayTimeReset field to PlayerYML for " + player.getName(), 2);
                }
                catch (IOException iOException) {
                    Main.INSTANCE().debugger.debug("Attempted to add 'nextPlayTimeReset' field to PlayerYML for " + player.getName() + ":" + player.getUniqueId(), 1);
                    return;
                }
            }
        }
        if (!fileConfiguration.contains("RecentName")) {
            try {
                fileConfiguration.set("RecentName", (Object)player.getName());
                fileConfiguration.save(file2);
                Main.INSTANCE().debugger.debug("Added RecentName field to PlayerYML for " + player.getName(), 2);
            }
            catch (IOException iOException) {
                Main.INSTANCE().debugger.debug("Failed to add 'RecentName' field to PlayerYML for " + player.getName() + ":" + player.getUniqueId(), 1);
                return;
            }
        }
    }

    public static void SetUp(String string) {
        FileConfiguration fileConfiguration;
        Main.INSTANCE().debugger.debug("User-Set up call: " + string + ":" + string, 3);
        File file = new File(Main.INSTANCE().getDataFolder() + "/Data/Players");
        File file2 = new File(Main.INSTANCE().getDataFolder() + "/Data/Players/" + string + ".yml");
        FileConfiguration fileConfiguration2 = CustomYMLFiles.getCustomConfigFile("Config.yml");
        if (!file2.exists()) {
            Main.INSTANCE().debugger.debug("Setting up new users data file: " + string, 1);
            try {
                if (!file.exists()) {
                    file.mkdir();
                    Main.INSTANCE().debugger.debug("A path was not defined for the Player YML's, this has been created", 1);
                }
                file2.createNewFile();
                fileConfiguration = CustomYMLFiles.PlayerData(null, string);
                fileConfiguration.set("TotalRewards", (Object)0);
                fileConfiguration.set("LastReward", (Object)0L);
                fileConfiguration.set("NextReward", (Object)0L);
                fileConfiguration.set("Streaks.CurrentStreak", (Object)0);
                fileConfiguration.set("Streaks.CurrentAbsoluteStreak", (Object)0);
                fileConfiguration.set("Streaks.HighestStreak", (Object)0);
                fileConfiguration.set("MissedDays", (Object)new int[0]);
                if (fileConfiguration2.contains("PlaytimeRequirement") && fileConfiguration2.getBoolean("PlaytimeRequirement")) {
                    fileConfiguration.set("playTime", (Object)0L);
                    fileConfiguration.set("nextPlayTimeReset", (Object)0L);
                }
                fileConfiguration.set("RecentName", (Object)string);
                fileConfiguration.save(file2);
                Main.INSTANCE().debugger.debug("A user data file was successfully set up for: " + string + ":" + string, 1);
            }
            catch (IOException iOException) {
                Main.INSTANCE().debugger.debug("A critical error occurred whilst initiating flat-file datastore for " + string + ":" + string, 0);
                return;
            }
        }
        if (!(fileConfiguration = CustomYMLFiles.PlayerData(null, string)).contains("MissedDays")) {
            try {
                fileConfiguration.set("MissedDays", (Object)new int[0]);
                fileConfiguration.save(file2);
            }
            catch (IOException iOException) {
                return;
            }
        }
        if (!fileConfiguration.contains("NextReward")) {
            try {
                fileConfiguration.set("NextReward", (Object)0L);
                fileConfiguration.save(file2);
            }
            catch (IOException iOException) {
                return;
            }
        }
        if (fileConfiguration2.contains("PlaytimeRequirement")) {
            if (fileConfiguration2.getBoolean("PlaytimeRequirement") && !fileConfiguration.contains("playTime")) {
                try {
                    fileConfiguration.set("playTime", (Object)0L);
                    fileConfiguration.save(file2);
                }
                catch (IOException iOException) {
                    return;
                }
            }
            if (fileConfiguration2.getBoolean("PlaytimeRequirement") && !fileConfiguration.contains("nextPlayTimeReset")) {
                try {
                    fileConfiguration.set("nextPlayTimeReset", (Object)0L);
                    fileConfiguration.save(file2);
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
        if (!fileConfiguration.contains("RecentName")) {
            try {
                fileConfiguration.set("RecentName", (Object)string);
                fileConfiguration.save(file2);
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public static void updateYML(DataUser dataUser) {
        if (dataUser != null && dataUser.getUUID() != null) {
            File file = new File(Main.INSTANCE().getDataFolder() + "/Data/Players/" + dataUser.getUUID() + ".yml");
            FileConfiguration fileConfiguration = CustomYMLFiles.PlayerData(dataUser.getP(), dataUser.getUUID());
            fileConfiguration.set("TotalRewards", (Object)dataUser.getTotalRewards());
            fileConfiguration.set("LastReward", (Object)dataUser.getLastReward());
            fileConfiguration.set("NextReward", (Object)dataUser.getNextReward());
            fileConfiguration.set("Streaks.CurrentStreak", (Object)dataUser.getCurrentStreak());
            fileConfiguration.set("Streaks.CurrentAbsoluteStreak", (Object)dataUser.getCurrentAbsoluteStreak());
            fileConfiguration.set("Streaks.HighestStreak", (Object)dataUser.getHighestStreak());
            fileConfiguration.set("MissedDays", (Object)dataUser.getMissedDays().toArray());
            fileConfiguration.set("playTime", (Object)dataUser.getPlayTime());
            fileConfiguration.set("nextPlayTimeReset", (Object)dataUser.getNextPlayTimeReset());
            fileConfiguration.set("RecentName", (Object)dataUser.getRecentName());
            try {
                fileConfiguration.save(file);
            }
            catch (IOException iOException) {
                Bukkit.getLogger().info("Error saving user data file for: " + dataUser.getUUID());
                iOException.printStackTrace();
            }
        }
    }

    public static void softUpdateYML(DataUser dataUser) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.INSTANCE(), () -> {
            if (dataUser != null && dataUser.getUUID() != null) {
                File file = new File(Main.INSTANCE().getDataFolder() + "/Data/Players/" + dataUser.getUUID() + ".yml");
                FileConfiguration fileConfiguration = CustomYMLFiles.PlayerData(dataUser.getP(), dataUser.getUUID());
                fileConfiguration.set("TotalRewards", (Object)dataUser.getTotalRewards());
                fileConfiguration.set("LastReward", (Object)dataUser.getLastReward());
                fileConfiguration.set("NextReward", (Object)dataUser.getNextReward());
                fileConfiguration.set("Streaks.CurrentStreak", (Object)dataUser.getCurrentStreak());
                fileConfiguration.set("Streaks.CurrentAbsoluteStreak", (Object)dataUser.getCurrentAbsoluteStreak());
                fileConfiguration.set("Streaks.HighestStreak", (Object)dataUser.getHighestStreak());
                fileConfiguration.set("MissedDays", (Object)dataUser.getMissedDays().toArray());
                fileConfiguration.set("playTime", (Object)dataUser.getPlayTime());
                fileConfiguration.set("nextPlayTimeReset", (Object)dataUser.getNextPlayTimeReset());
                fileConfiguration.set("RecentName", (Object)dataUser.getRecentName());
                try {
                    fileConfiguration.save(file);
                }
                catch (IOException iOException) {
                    Bukkit.getLogger().info("Error saving user data file for: " + dataUser.getUUID());
                    iOException.printStackTrace();
                }
            }
        });
    }

    public static void forceInsert(String string, int n2, long l, long l2, int n3, int n4, int n5, List<Integer> list, int n6, long l3, String string2) {
        File file = new File(Main.INSTANCE().getDataFolder() + "/Data/Players");
        File file2 = new File(Main.INSTANCE().getDataFolder() + "/Data/Players/" + string + ".yml");
        try {
            if (!file.exists()) {
                file.mkdir();
                Main.INSTANCE().debugger.debug("A path was not defined for the Player YML's, this has been created", 1);
            }
            file2.createNewFile();
            FileConfiguration fileConfiguration = CustomYMLFiles.PlayerData(null, string);
            fileConfiguration.set("TotalRewards", (Object)n2);
            fileConfiguration.set("LastReward", (Object)l);
            fileConfiguration.set("NextReward", (Object)l2);
            fileConfiguration.set("Streaks.CurrentStreak", (Object)n3);
            fileConfiguration.set("Streaks.CurrentAbsoluteStreak", (Object)n4);
            fileConfiguration.set("Streaks.HighestStreak", (Object)n5);
            fileConfiguration.set("MissedDays", (Object)list.stream().mapToInt(n -> n).toArray());
            fileConfiguration.set("playTime", (Object)n6);
            fileConfiguration.set("nextPlayTimeReset", (Object)l3);
            fileConfiguration.set("RecentName", (Object)string2);
            fileConfiguration.save(file2);
            Main.INSTANCE().debugger.debug("A user data file was successfully set up for: " + string, 1);
        }
        catch (IOException iOException) {
            Main.INSTANCE().debugger.debug("A critical error occurred whilst initiating flat-file datastore for " + string, 0);
        }
    }
}

