/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.Modules.PlayerData;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import uhfinn.dailyrewardsplus.Main;
import uhfinn.dailyrewardsplus.Modules.PlayerData.DataUser;

public class SQLHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void createUserIfNotExist(String string) {
        Connection connection = Main.INSTANCE().database.getCon();
        connection.setAutoCommit(false);
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM DailyRewardsPlus WHERE UUID=?");
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                preparedStatement = connection.prepareStatement("INSERT INTO DailyRewardsPlus VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, 0);
                preparedStatement.setLong(3, 0L);
                preparedStatement.setLong(4, 0L);
                preparedStatement.setInt(5, 0);
                preparedStatement.setInt(6, 0);
                preparedStatement.setInt(7, 0);
                preparedStatement.setString(8, "");
                preparedStatement.setInt(9, 0);
                preparedStatement.setLong(10, 0L);
                preparedStatement.setString(11, "");
                preparedStatement.execute();
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            connection.rollback();
            sQLException.printStackTrace();
        }
        finally {
            connection.setAutoCommit(true);
            connection.close();
        }
    }

    public static void updateUser(DataUser dataUser) {
        try (Connection connection = Main.INSTANCE().database.getCon();){
            PreparedStatement preparedStatement = connection.prepareStatement("UPDATE DailyRewardsPlus SET TotalRewards=?, LastReward=?, NextReward=?, CurrentStreak=?, CurrentAbsoluteStreak=?, HighestStreak=?, MissedDays=?, PlayTime=?, nextPlayTimeReset=?, RecentName=? WHERE UUID=?");
            preparedStatement.setInt(1, dataUser.getTotalRewards());
            preparedStatement.setLong(2, dataUser.getLastReward());
            preparedStatement.setLong(3, dataUser.getNextReward());
            preparedStatement.setInt(4, dataUser.getCurrentStreak());
            preparedStatement.setInt(5, dataUser.getCurrentAbsoluteStreak());
            preparedStatement.setInt(6, dataUser.getHighestStreak());
            preparedStatement.setString(7, dataUser.getMissedDaysAsString());
            preparedStatement.setInt(8, dataUser.getPlayTime());
            preparedStatement.setLong(9, dataUser.getNextPlayTimeReset());
            preparedStatement.setString(10, dataUser.getRecentName());
            preparedStatement.setString(11, dataUser.getUUID());
            preparedStatement.execute();
        }
        catch (Exception exception) {
            if (dataUser != null && dataUser.getUUID() != null) {
                Bukkit.getLogger().info("Error saving user data SQL for: " + dataUser.getUUID());
            }
            Bukkit.getLogger().info("Error saving user data SQL for: " + dataUser.getUUID());
            exception.printStackTrace();
        }
    }

    public static void softUpdateUser(DataUser dataUser) {
        if (dataUser != null) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.INSTANCE(), () -> {
                try (Connection connection = Main.INSTANCE().database.getCon();){
                    PreparedStatement preparedStatement = connection.prepareStatement("UPDATE DailyRewardsPlus SET TotalRewards=?, LastReward=?, NextReward=?, CurrentStreak=?, CurrentAbsoluteStreak=?, HighestStreak=?, MissedDays=?, PlayTime=?, nextPlayTimeReset=?, RecentName=? WHERE UUID=?");
                    preparedStatement.setInt(1, dataUser.getTotalRewards());
                    preparedStatement.setLong(2, dataUser.getLastReward());
                    preparedStatement.setLong(3, dataUser.getNextReward());
                    preparedStatement.setInt(4, dataUser.getCurrentStreak());
                    preparedStatement.setInt(5, dataUser.getCurrentAbsoluteStreak());
                    preparedStatement.setInt(6, dataUser.getHighestStreak());
                    preparedStatement.setString(7, dataUser.getMissedDaysAsString());
                    preparedStatement.setInt(8, dataUser.getPlayTime());
                    preparedStatement.setLong(9, dataUser.getNextPlayTimeReset());
                    preparedStatement.setString(10, dataUser.getRecentName());
                    preparedStatement.setString(11, dataUser.getUUID());
                    preparedStatement.execute();
                }
                catch (Exception exception) {
                    if (dataUser != null && dataUser.getUUID() != null) {
                        Bukkit.getLogger().info("Error saving user data SQL for: " + dataUser.getUUID());
                    }
                    exception.printStackTrace();
                }
            });
        }
    }

    public static void forceInsert(String string, int n, long l, long l2, int n2, int n3, int n4, String string2, int n5, long l3, String string3) {
        try (Connection connection = Main.INSTANCE().database.getCon();){
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO DailyRewardsPlus VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            preparedStatement.setLong(3, l);
            preparedStatement.setLong(4, l2);
            preparedStatement.setInt(5, n2);
            preparedStatement.setInt(6, n3);
            preparedStatement.setInt(7, n4);
            preparedStatement.setString(8, string2);
            preparedStatement.setInt(9, n5);
            preparedStatement.setLong(10, l3);
            preparedStatement.setString(11, string3);
            preparedStatement.execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void forceWipe() {
        try (Connection connection = Main.INSTANCE().database.getCon();){
            PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM DailyRewardsPlus");
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

