/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.Modules.PlayerData;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import uhfinn.dailyrewardsplus.Commands.daily;
import uhfinn.dailyrewardsplus.Main;
import uhfinn.dailyrewardsplus.Modules.EditMessages.ClickerMessage;
import uhfinn.dailyrewardsplus.Modules.PAPI.PAPIReplacement;
import uhfinn.dailyrewardsplus.Modules.TextTransformations.PlaceholderReplacement;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.CustomYMLFiles;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.YMLFiles.Config.ConfigDataPull;

public class LeaderBoardHandler {
    private static HashMap<String, Integer> playerTotalRewards = new HashMap();
    private static HashMap<String, Integer> playerCurrentAbsolute = new HashMap();
    public static HashMap<String, String> uuidToName = new HashMap();

    public static void loadInitialDataLB(Logger logger) {
        logger.info("[DailyRewards+] Accumulating player data for LeaderBoard placeholders, this task will run asynchronously.");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.INSTANCE(), () -> {
            if (ConfigDataPull.getSQLEnabled()) {
                try (Connection connection = Main.INSTANCE().database.getCon();){
                    PreparedStatement preparedStatement = connection.prepareStatement("SELECT UUID, TotalRewards, CurrentAbsoluteStreak, RecentName FROM DailyRewardsPlus");
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString("RecentName");
                        if (string == null || string.isEmpty()) continue;
                        String string2 = resultSet.getString("UUID");
                        int n = resultSet.getInt("TotalRewards");
                        int n2 = resultSet.getInt("CurrentAbsoluteStreak");
                        playerTotalRewards.put(string2, n);
                        playerCurrentAbsolute.put(string2, n2);
                        uuidToName.put(string2, resultSet.getString("RecentName"));
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            } else {
                File file = new File(Main.INSTANCE().getDataFolder() + "/Data/Players");
                if (file.exists()) {
                    for (File file2 : file.listFiles()) {
                        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file2);
                        if (!yamlConfiguration.contains("RecentName")) continue;
                        String string = file2.getName().split("[.]")[0];
                        playerTotalRewards.put(string, yamlConfiguration.getInt("TotalRewards"));
                        playerCurrentAbsolute.put(string, yamlConfiguration.getInt("Streaks.CurrentAbsoluteStreak"));
                        uuidToName.put(string, yamlConfiguration.getString("RecentName", string));
                    }
                }
            }
            logger.info("[DailyRewards+] Successfully acquired all player data for LeaderBoard.");
        });
    }

    public static void addToCache(String string, boolean bl, boolean bl2) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getPlugin(Main.class), () -> {
            block16: {
                if (!playerTotalRewards.containsKey(string) || !playerCurrentAbsolute.containsKey(string)) {
                    if (ConfigDataPull.getSQLEnabled()) {
                        try (Connection connection = Main.INSTANCE().database.getCon();){
                            String string2;
                            PreparedStatement preparedStatement = connection.prepareStatement("SELECT UUID, TotalRewards, CurrentAbsoluteStreak, RecentName FROM DailyRewardsPlus WHERE UUID = ?");
                            preparedStatement.setString(1, string);
                            ResultSet resultSet = preparedStatement.executeQuery();
                            if (!resultSet.next() || (string2 = resultSet.getString("RecentName")) == null || string2.isEmpty()) break block16;
                            uuidToName.put(string, resultSet.getString("RecentName"));
                            int n = resultSet.getInt("TotalRewards");
                            int n2 = resultSet.getInt("CurrentAbsoluteStreak");
                            playerTotalRewards.put(string, n);
                            playerCurrentAbsolute.put(string, n2);
                            if (bl) {
                                playerTotalRewards.put(string, playerTotalRewards.get(string) + 1);
                            }
                            if (bl2) {
                                playerCurrentAbsolute.put(string, playerCurrentAbsolute.get(string) + 1);
                            }
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    } else {
                        File file = new File(Main.INSTANCE().getDataFolder() + "/Data/Players/" + string + ".yml");
                        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
                        if (yamlConfiguration.contains("RecentName")) {
                            playerTotalRewards.put(string, yamlConfiguration.getInt("TotalRewards"));
                            playerCurrentAbsolute.put(string, yamlConfiguration.getInt("Streaks.CurrentAbsoluteStreak"));
                            uuidToName.put(string, yamlConfiguration.getString("RecentName"));
                            if (bl) {
                                playerTotalRewards.put(string, playerTotalRewards.get(string) + 1);
                            }
                            if (bl2) {
                                playerCurrentAbsolute.put(string, playerCurrentAbsolute.get(string) + 1);
                            }
                        }
                    }
                }
            }
        });
    }

    public static String getTotRewAtPosKEY(int n) {
        String string = LeaderBoardHandler.getKeyByPosition(playerTotalRewards, n);
        if (string == null) {
            return CustomYMLFiles.getCustomConfigFile("Config.yml").getString("NoPlayer-NameText", "No-One");
        }
        return string;
    }

    public static Integer getTotRewAtPosVAL(int n) {
        Integer n2 = LeaderBoardHandler.getValueByPosition(playerTotalRewards, n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public static String getCurAbsAtPosKEY(int n) {
        String string = LeaderBoardHandler.getKeyByPosition(playerCurrentAbsolute, n);
        if (string == null) {
            return CustomYMLFiles.getCustomConfigFile("Config.yml").getString("NoPlayer-NameText", "No-One");
        }
        return string;
    }

    public static Integer getCurAbsAtPosVAL(int n) {
        Integer n2 = LeaderBoardHandler.getValueByPosition(playerCurrentAbsolute, n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public static void incTotRew(String string) {
        if (playerTotalRewards.containsKey(string)) {
            playerTotalRewards.put(string, playerTotalRewards.get(string) + 1);
        } else {
            LeaderBoardHandler.addToCache(string, true, false);
        }
    }

    public static void incCurAbs(String string) {
        if (playerCurrentAbsolute.containsKey(string)) {
            playerCurrentAbsolute.put(string, playerCurrentAbsolute.get(string) + 1);
        } else {
            LeaderBoardHandler.addToCache(string, false, true);
        }
    }

    public static void setTotRew(String string, int n) {
        playerTotalRewards.put(string, n);
    }

    public static void setCurAbs(String string, int n) {
        playerCurrentAbsolute.put(string, n);
    }

    public static void eraseData(String string) {
        playerTotalRewards.remove(string);
        playerCurrentAbsolute.remove(string);
        uuidToName.remove(string);
    }

    public static void eraseAllData() {
        playerTotalRewards.clear();
        playerCurrentAbsolute.clear();
        uuidToName.clear();
    }

    private static String getKeyByPosition(HashMap<String, Integer> hashMap, int n) {
        if (n > hashMap.size()) {
            return null;
        }
        String string = (String)hashMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(n).map(Map.Entry::getKey).collect(Collectors.toList()).get(n - 1);
        return string;
    }

    private static Integer getValueByPosition(HashMap<String, Integer> hashMap, int n) {
        if (n > hashMap.size()) {
            return null;
        }
        Integer n2 = (Integer)hashMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(n).map(Map.Entry::getValue).collect(Collectors.toList()).get(n - 1);
        return n2;
    }

    public static void sendLeaderboardPage(int n, Player player) {
        FileConfiguration fileConfiguration = CustomYMLFiles.getCustomConfigFile("Messages.yml");
        String string = fileConfiguration.getString("Leaderboard.Header", "&b&m-----------&b< &3&lDaily&b&lRewards+ &fLeaderboard &b>&m----------");
        String string2 = fileConfiguration.getString("Leaderboard.Entry", " &6&l<pos>. &f<playername>: <streak> Day Streak");
        String string3 = fileConfiguration.getString("Leaderboard.Footer", "&b&m------------------&f <pp> &f[<page>/<pageCount>]&f <np> &b&m------------------");
        if (n >= 1 && n <= 10) {
            String[] stringArray;
            String string4;
            int n2 = (int)Math.ceil((float)playerCurrentAbsolute.size() / 10.0f);
            if (n2 > 10) {
                n2 = 10;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            ClickerMessage clickerMessage = player != null ? new ClickerMessage(PAPIReplacement.ReplacePlaceholders(player, PlaceholderReplacement.replace(string, player))) : new ClickerMessage(string);
            int n3 = (n - 1) * 10 + 1;
            int n4 = 0;
            for (int i = n3; i < n3 + 10; ++i) {
                string4 = LeaderBoardHandler.getKeyByPosition(playerCurrentAbsolute, i);
                if (string4 == null) continue;
                stringArray = LeaderBoardHandler.getCurAbsAtPosKEY(i);
                if (uuidToName.containsKey(stringArray)) {
                    String[] stringArray2 = uuidToName.get(stringArray);
                    if (stringArray2 == null) continue;
                    Integer n5 = LeaderBoardHandler.getCurAbsAtPosVAL(i);
                    clickerMessage.then("\n" + string2.replaceAll("(?i)<pos>", Integer.toString(i)).replaceAll("(?i)<playername>", (String)stringArray2).replaceAll("(?i)<streak>", Integer.toString(n5)));
                    ++n4;
                    continue;
                }
                Main.INSTANCE().debugger.debug("Couldn't convert UUID to name; " + (String)stringArray + "; no cache record found", 2);
            }
            if (n4 == 0) {
                clickerMessage.then("\n&7&oOops... No leaderboard entries have loaded yet!\nAttempt rejoining the game and check back.");
            }
            clickerMessage.then("\n");
            String string5 = Integer.toString(n);
            if (string5.length() == 1) {
                string5 = "0" + string5;
            }
            if ((string4 = Integer.toString(n2)).length() == 1) {
                string4 = "0" + string4;
            }
            for (String string6 : stringArray = string3.split("<pp>")) {
                String[] stringArray3 = string6.split("<np>");
                for (String string7 : stringArray3) {
                    clickerMessage.then(PAPIReplacement.ReplacePlaceholders(player, string7.replaceAll("(?i)<page>", string5).replaceAll("(?i)<pageCount>", string4)));
                    if (string7.equals(stringArray3[stringArray3.length - 1])) continue;
                    String string8 = "&f";
                    if (n == n2 || n == 10) {
                        string8 = "&7";
                    }
                    clickerMessage.then(string8 + "->");
                    if (!string8.equals("&f")) continue;
                    clickerMessage.runCommand("/daily top " + (n + 1));
                }
                if (string6.equals(stringArray[stringArray.length - 1])) continue;
                Object object = "&f";
                if (n == 1) {
                    object = "&7";
                }
                clickerMessage.then((String)object + "<-");
                if (!((String)object).equals("&f")) continue;
                clickerMessage.runCommand("/daily top " + (n - 1));
            }
            if (player != null) {
                clickerMessage.send(player);
            } else {
                daily.sendMessage(null, "\n" + clickerMessage);
            }
        }
    }
}

