/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.Modules.PlayerData;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import uhfinn.dailyrewardsplus.Main;
import uhfinn.dailyrewardsplus.Modules.PlayerData.LeaderBoardHandler;
import uhfinn.dailyrewardsplus.Modules.PlayerData.SQLHandler;
import uhfinn.dailyrewardsplus.Modules.PlayerData.YMLHandler;
import uhfinn.dailyrewardsplus.Modules.Time.getTimeValues;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.CustomYMLFiles;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.YMLFiles.Config.ConfigDataPull;

public class DataUser {
    private Player p;
    private String UUID;
    private int TotalRewards;
    private long LastReward;
    private long NextReward;
    private int CurrentStreak;
    private int CurrentAbsoluteStreak;
    private int HighestStreak;
    private List<Integer> MissedDays;
    private int PlayTime;
    private long nextPlayTimeReset;
    private String RecentName;

    public DataUser(Player player, boolean bl) {
        this.p = player;
        this.UUID = player.getUniqueId().toString();
        if (bl) {
            try (Connection connection = Main.INSTANCE().database.getCon();){
                SQLHandler.createUserIfNotExist(player.getUniqueId().toString());
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM DailyRewardsPlus WHERE UUID=?");
                preparedStatement.setString(1, player.getUniqueId().toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                resultSet.next();
                this.TotalRewards = resultSet.getInt("TotalRewards");
                this.LastReward = resultSet.getLong("LastReward");
                this.NextReward = resultSet.getLong("NextReward");
                this.CurrentStreak = resultSet.getInt("CurrentStreak");
                this.CurrentAbsoluteStreak = resultSet.getInt("CurrentAbsoluteStreak");
                this.HighestStreak = resultSet.getInt("HighestStreak");
                this.MissedDays = DataUser.stringToIntList(resultSet.getString("MissedDays"));
                this.PlayTime = resultSet.getInt("PlayTime");
                this.nextPlayTimeReset = resultSet.getLong("nextPlayTimeReset");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            YMLHandler.SetUp(player);
            FileConfiguration fileConfiguration = CustomYMLFiles.PlayerData(player, player.getUniqueId().toString());
            this.TotalRewards = fileConfiguration.getInt("TotalRewards");
            this.LastReward = fileConfiguration.getLong("LastReward");
            this.NextReward = fileConfiguration.getLong("NextReward");
            this.CurrentStreak = fileConfiguration.getInt("Streaks.CurrentStreak");
            this.CurrentAbsoluteStreak = fileConfiguration.getInt("Streaks.CurrentAbsoluteStreak");
            this.HighestStreak = fileConfiguration.getInt("Streaks.HighestStreak");
            this.MissedDays = fileConfiguration.getIntegerList("MissedDays");
            this.PlayTime = fileConfiguration.getInt("playTime");
            this.nextPlayTimeReset = fileConfiguration.getLong("nextPlayTimeReset");
        }
        this.RecentName = player.getName();
    }

    public static List<Integer> stringToIntList(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (!string.equals("")) {
            if (!string.contains(":")) {
                arrayList.add(Integer.parseInt(string));
            } else {
                String[] stringArray;
                for (String string2 : stringArray = string.split(":")) {
                    arrayList.add(Integer.parseInt(string2));
                }
            }
        }
        return arrayList;
    }

    public Player getP() {
        return this.p;
    }

    public String getUUID() {
        return this.UUID;
    }

    public int getTotalRewards() {
        return this.TotalRewards;
    }

    public long getLastReward() {
        return this.LastReward;
    }

    public long getNextReward() {
        return this.NextReward;
    }

    public int getCurrentStreak() {
        return this.CurrentStreak;
    }

    public int getCurrentAbsoluteStreak() {
        return this.CurrentAbsoluteStreak;
    }

    public int getHighestStreak() {
        return this.HighestStreak;
    }

    public List<Integer> getMissedDays() {
        return this.MissedDays;
    }

    public String getMissedDaysAsString() {
        if (this.MissedDays == null) {
            return "";
        }
        return this.MissedDays.stream().map(Object::toString).collect(Collectors.joining(":"));
    }

    public int getPlayTime() {
        return this.PlayTime;
    }

    public long getNextPlayTimeReset() {
        return this.nextPlayTimeReset;
    }

    public String getRecentName() {
        return this.RecentName;
    }

    public void AddOne(boolean bl) {
        if (bl) {
            ++this.TotalRewards;
            LeaderBoardHandler.incTotRew(this.UUID);
        }
        ++this.CurrentStreak;
        ++this.CurrentAbsoluteStreak;
        LeaderBoardHandler.incCurAbs(this.UUID);
        Main.INSTANCE().debugger.debug("Added Day (1|addTotal:" + bl + ") for " + this.getUUID(), 2);
    }

    public void ResetWhenStreakCompletedFalse() {
        int n = ConfigDataPull.getStreakLimit();
        this.CurrentStreak = n - 1;
        ++this.TotalRewards;
        ++this.CurrentAbsoluteStreak;
        LeaderBoardHandler.incTotRew(this.UUID);
        LeaderBoardHandler.incCurAbs(this.UUID);
        Main.INSTANCE().debugger.debug("Soft loop back reset (ResetWhenStreakCompletedFalse) for " + this.getUUID(), 2);
    }

    public void AddOneLoopStreak() {
        ++this.TotalRewards;
        this.CurrentStreak = 1;
        ++this.CurrentAbsoluteStreak;
        LeaderBoardHandler.incTotRew(this.UUID);
        LeaderBoardHandler.incCurAbs(this.UUID);
        this.ResetMissedDays();
    }

    public void AddMissedDay(int n) {
        List<Integer> list = this.getMissedDays();
        list.add(n);
        this.MissedDays = list;
        Main.INSTANCE().debugger.debug("Added Missed Day (" + n + ") for " + this.getUUID(), 2);
    }

    public void RemoveMissedDay(int n) {
        List<Integer> list = this.getMissedDays();
        if (list.contains(n)) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != n) continue;
                list.remove(i);
            }
            this.MissedDays = list;
            Main.INSTANCE().debugger.debug("Removed Missed Day (" + n + ") for " + this.getUUID(), 2);
        }
    }

    public void LoopStreak() {
        this.CurrentStreak = 0;
        Main.INSTANCE().debugger.debug("Looped Streak for " + this.getUUID(), 2);
        this.ResetMissedDays();
    }

    public void SetStreak(int n) {
        this.CurrentStreak = n;
        this.CurrentAbsoluteStreak = n;
        LeaderBoardHandler.setCurAbs(this.UUID, n);
        Main.INSTANCE().debugger.debug("Updated Streak (" + n + ") for " + this.getUUID(), 2);
    }

    public void SetTime(Long l) {
        this.LastReward = l;
        Main.INSTANCE().debugger.debug("Updated LastReward (" + l + ") for " + this.getUUID(), 2);
    }

    public void SetNextTime(Long l) {
        this.NextReward = l;
        Main.INSTANCE().debugger.debug("Updated NextReward (" + l + ") for " + this.getUUID(), 2);
    }

    public void ResetStreak() {
        this.CurrentStreak = 0;
        if (this.CurrentAbsoluteStreak > this.HighestStreak) {
            this.HighestStreak = this.CurrentAbsoluteStreak;
        }
        this.CurrentAbsoluteStreak = 0;
        LeaderBoardHandler.setCurAbs(this.UUID, 0);
        Main.INSTANCE().debugger.debug("Reset streak for " + this.getUUID(), 2);
        this.ResetMissedDays();
    }

    public int ResetStreakM() {
        FileConfiguration fileConfiguration = CustomYMLFiles.getCustomConfigFile("Config.yml");
        if (fileConfiguration.getBoolean("SkipMissedDays")) {
            int n = ConfigDataPull.getStreakLimit();
            long l = getTimeValues.getTime();
            long l2 = l - this.NextReward;
            long l3 = 86400000L;
            long l4 = l2 / 86400000L;
            long l5 = (long)Math.floor(l4);
            this.SetTime(getTimeValues.getTime() - 86400000L);
            this.SetNextTime(getTimeValues.getTime() - 1L);
            int n2 = 0;
            while ((long)n2 < l5) {
                if (this.CurrentStreak == 0) {
                    return 0;
                }
                if (this.CurrentStreak >= n - 1) {
                    if (fileConfiguration.getBoolean("ResetWhenStreakCompleted")) {
                        this.LoopStreak();
                        this.ResetMissedDays();
                        break;
                    }
                    this.ResetWhenStreakCompletedFalse();
                    break;
                }
                this.AddOne(false);
                this.AddMissedDay(this.CurrentStreak);
                ++n2;
            }
            return this.CurrentStreak;
        }
        this.ResetStreak();
        return 0;
    }

    public void ResetStreakAddOne() {
        if (this.CurrentAbsoluteStreak > this.HighestStreak) {
            this.HighestStreak = this.CurrentAbsoluteStreak;
        }
        this.CurrentStreak = 1;
        this.CurrentAbsoluteStreak = 1;
        ++this.TotalRewards;
        LeaderBoardHandler.incTotRew(this.UUID);
        LeaderBoardHandler.setCurAbs(this.UUID, 1);
        this.ResetMissedDays();
    }

    public void ResetMissedDays() {
        this.MissedDays = new ArrayList<Integer>();
        Main.INSTANCE().debugger.debug("Reset MissedDays for " + this.getUUID(), 2);
    }

    public void addPlayTime(int n) {
        this.PlayTime += n;
        Main.INSTANCE().debugger.debug("Updated PlayTime (+" + n + ") for " + this.getUUID(), 2);
    }

    public void setPlayTime(int n) {
        this.PlayTime = n;
        Main.INSTANCE().debugger.debug("Updated PlayTime (" + n + ") for " + this.getUUID(), 2);
    }

    public void updatePlayTimeReset() {
        this.nextPlayTimeReset = getTimeValues.getNextTime();
        this.PlayTime = 0;
        Main.INSTANCE().debugger.debug("Updated Next PlayTime Reset (" + this.nextPlayTimeReset + ") for " + this.getUUID(), 2);
    }
}

