/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.Modules.PlayerData;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import uhfinn.dailyrewardsplus.Commands.daily;
import uhfinn.dailyrewardsplus.Main;
import uhfinn.dailyrewardsplus.Modules.MySQL.Database;
import uhfinn.dailyrewardsplus.Modules.PlayerData.DataUser;
import uhfinn.dailyrewardsplus.Modules.PlayerData.LeaderBoardHandler;
import uhfinn.dailyrewardsplus.Modules.PlayerData.SQLHandler;
import uhfinn.dailyrewardsplus.Modules.PlayerData.YMLHandler;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.CustomYMLFiles;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.YMLFiles.Config.ConfigDataPull;

public class DataFactory {
    private static HashMap<Player, DataUser> playerDataPairs = new HashMap();
    private static HashMap<Player, Integer> playerGuiUpdates = new HashMap();

    public static void addGuiUpdate(Player player, Integer n) {
        if (n != null) {
            playerGuiUpdates.put(player, n);
        }
    }

    public static void endGuiUpdate(Player player) {
        if (playerGuiUpdates.containsKey(player)) {
            int n = playerGuiUpdates.get(player);
            playerGuiUpdates.remove(player);
            Bukkit.getScheduler().cancelTask(n);
        }
    }

    public static DataUser getPlayerData(Player player) {
        if (!playerDataPairs.containsKey(player)) {
            playerDataPairs.put(player, new DataUser(player, ConfigDataPull.getSQLEnabled()));
        }
        return playerDataPairs.get(player);
    }

    public static void initUser(Player player, String string) {
        if (player == null) {
            if (ConfigDataPull.getSQLEnabled()) {
                try {
                    SQLHandler.createUserIfNotExist(string);
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            } else {
                YMLHandler.SetUp(string);
            }
        } else {
            playerDataPairs.put(player, new DataUser(player, ConfigDataPull.getSQLEnabled()));
        }
        LeaderBoardHandler.addToCache(string, false, false);
    }

    public static void updateDatabase(Player player, boolean bl) {
        if (ConfigDataPull.getSQLEnabled()) {
            if (bl) {
                SQLHandler.softUpdateUser(playerDataPairs.get(player));
            } else {
                SQLHandler.updateUser(playerDataPairs.get(player));
            }
        } else if (bl) {
            YMLHandler.softUpdateYML(playerDataPairs.get(player));
        } else {
            YMLHandler.updateYML(playerDataPairs.get(player));
        }
    }

    public static void closeUser(Player player) {
        DataFactory.updateDatabase(player, true);
        playerDataPairs.remove(player);
    }

    public static boolean HasYmlData(String string) {
        File file = new File(Main.INSTANCE().getDataFolder() + "/Data/Players/" + string + ".yml");
        return file.exists();
    }

    public static int eraseAllData() {
        int n = 0;
        if (ConfigDataPull.getSQLEnabled()) {
            try (Connection connection = Main.INSTANCE().database.getCon();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT(*) FROM DailyRewardsPlus");
                ResultSet resultSet = preparedStatement.executeQuery();
                resultSet.next();
                n = resultSet.getInt(1);
                preparedStatement = connection.prepareStatement("DELETE FROM DailyRewardsPlus");
                preparedStatement.execute();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else {
            File file = new File(Main.INSTANCE().getDataFolder() + "/Data/Players");
            for (File file2 : file.listFiles()) {
                file2.delete();
                ++n;
            }
        }
        playerDataPairs = new HashMap();
        LeaderBoardHandler.eraseAllData();
        return n;
    }

    public static void erasePlayerData(Player player) {
        if (ConfigDataPull.getSQLEnabled()) {
            try (Connection connection = Main.INSTANCE().database.getCon();){
                PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM DailyRewardsPlus WHERE UUID=?");
                preparedStatement.setString(1, player.getUniqueId().toString());
                preparedStatement.execute();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else {
            File file = new File(Main.INSTANCE().getDataFolder() + "/Data/Players/" + player.getUniqueId() + ".yml");
            file.delete();
        }
        LeaderBoardHandler.eraseData(player.getUniqueId().toString());
        playerDataPairs.remove(player);
    }

    public static boolean flatToSQL(Player player) {
        try {
            if (Main.INSTANCE().database == null) {
                Main.INSTANCE().database = new Database(CustomYMLFiles.getCustomConfigFile("Config.yml"));
            } else {
                Main.INSTANCE().database.reloadDetails();
            }
            if (Main.INSTANCE().database.ds != null && Main.INSTANCE().database.ds.isRunning()) {
                Main.INSTANCE().database.connect();
            }
            SQLHandler.forceWipe();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.INSTANCE(), () -> {
                File file = new File(Main.INSTANCE().getDataFolder() + "/Data/Players");
                for (File file2 : file.listFiles()) {
                    YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file2);
                    String string = yamlConfiguration.getIntegerList("MissedDays").stream().map(Object::toString).collect(Collectors.joining(":"));
                    SQLHandler.forceInsert(file2.getName().split("[.]")[0], yamlConfiguration.getInt("TotalRewards"), yamlConfiguration.getLong("LastReward"), yamlConfiguration.getLong("NextReward"), yamlConfiguration.getInt("Streaks.CurrentStreak"), yamlConfiguration.getInt("Streaks.CurrentAbsoluteStreak"), yamlConfiguration.getInt("Streaks.HighestStreak"), string, yamlConfiguration.getInt("playTime"), yamlConfiguration.getLong("nextPlayTimeReset"), yamlConfiguration.getString("RecentName"));
                }
                daily.sendMessage(player, "All flat-file entries have been converted to SQL\nIt is highly suggested that you restart your server to avoid data issues.");
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            daily.sendMessage(player, "&f[DailyRewards+] &c&oOops... &cAn error occurred whilst transferring data, this could be for a number of reasons.\n&fPlease ensure that you have entered valid SQL credentials in the Config.yml and reloaded.\nIf issues persist, please contact DailyRewards+ support.");
            return false;
        }
        return true;
    }

    public static boolean sqlToFlat(Player player) {
        try {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.INSTANCE(), () -> {
                try (Connection connection = Main.INSTANCE().database.getCon();){
                    if (Main.INSTANCE().database == null) {
                        Main.INSTANCE().database = new Database(CustomYMLFiles.getCustomConfigFile("Config.yml"));
                    } else {
                        Main.INSTANCE().database.reloadDetails();
                    }
                    if (Main.INSTANCE().database.ds != null && Main.INSTANCE().database.ds.isRunning()) {
                        Main.INSTANCE().database.connect();
                    }
                    PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM DailyRewardsPlus");
                    ResultSet resultSet = preparedStatement.executeQuery();
                    File file = new File(Main.INSTANCE().getDataFolder() + "/Data/Players");
                    for (File file2 : file.listFiles()) {
                        file2.delete();
                    }
                    while (resultSet.next()) {
                        YMLHandler.forceInsert(resultSet.getString("UUID"), resultSet.getInt("TotalRewards"), resultSet.getLong("LastReward"), resultSet.getLong("NextReward"), resultSet.getInt("CurrentStreak"), resultSet.getInt("CurrentAbsoluteStreak"), resultSet.getInt("HighestStreak"), DataUser.stringToIntList(resultSet.getString("MissedDays")), resultSet.getInt("PlayTime"), resultSet.getLong("nextPlayTimeReset"), resultSet.getString("RecentName"));
                    }
                    daily.sendMessage(player, "All SQL entries have been converted to flat-file\nIt is highly suggested that you restart your server to avoid data issues.");
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    daily.sendMessage(player, "&f[DailyRewards+] &c&oOops... &cAn error occurred whilst transferring data, this could be for a number of reasons.\n&fPlease ensure that you have entered valid SQL credentials in the Config.yml and reloaded.\nIf issues persist, please contact DailyRewards+ support.");
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }
}

