/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.Modules.PAPI;

import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import uhfinn.dailyrewardsplus.Modules.PlayerData.DataFactory;
import uhfinn.dailyrewardsplus.Modules.PlayerData.LeaderBoardHandler;
import uhfinn.dailyrewardsplus.Modules.TextTransformations.Hex;
import uhfinn.dailyrewardsplus.Modules.TextTransformations.PlaceholderData;
import uhfinn.dailyrewardsplus.Modules.TextTransformations.PlaceholderReplacement;
import uhfinn.dailyrewardsplus.Modules.Time.playTimeHandling;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.CustomYMLFiles;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.YMLFiles.Rewards.GetReward;

public class Placeholders
extends PlaceholderExpansion {
    private final Plugin plugin;

    public Placeholders(Plugin plugin) {
        this.plugin = plugin;
    }

    public String getAuthor() {
        return "ItsUhFinn";
    }

    public String getIdentifier() {
        return "daily";
    }

    public String getVersion() {
        return "1.0.0";
    }

    public boolean persist() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String onRequest(OfflinePlayer offlinePlayer, String string) {
        String[] stringArray;
        if (string.equalsIgnoreCase("remaining_time")) {
            Player player = offlinePlayer.getPlayer();
            String string2 = PlaceholderData.nextRewardTime(player);
            if (string2 == null) return Hex.hexTranslate("&c[DailyRewards+] " + player.getName() + " has not claimed a reward yet!");
            return PlaceholderData.nextRewardTime(player);
        }
        if (string.equalsIgnoreCase("remaining_time_compressed")) {
            Player player = offlinePlayer.getPlayer();
            String string3 = PlaceholderData.nextRewardTimeCompressed(player);
            if (string3 == null) return Hex.hexTranslate("&c[DailyRewards+] " + player.getName() + " has not claimed a reward yet!");
            return PlaceholderData.nextRewardTimeCompressed(player);
        }
        if (string.equalsIgnoreCase("remaining_playtime") && offlinePlayer.isOnline() && (stringArray = offlinePlayer.getPlayer()) != null) {
            playTimeHandling.updatePlayer((Player)stringArray);
            FileConfiguration fileConfiguration = CustomYMLFiles.getCustomConfigFile("Config.yml");
            float f = (float)fileConfiguration.getInt("PlaytimeRequired", 10) * 60.0f;
            if (!fileConfiguration.getBoolean("PlaytimeRequirement", false)) {
                f = 0.0f;
            }
            int n = DataFactory.getPlayerData((Player)stringArray).getPlayTime();
            return PlaceholderReplacement.playtimeReplacement("<playTimeRemaining>", ((int)Math.ceil(f) - n) * 1000);
        }
        if (string.equalsIgnoreCase("total_rewards")) {
            if (!offlinePlayer.isOnline()) return "0";
            return Integer.toString(DataFactory.getPlayerData(offlinePlayer.getPlayer()).getTotalRewards());
        }
        if (string.equalsIgnoreCase("reward_streak")) {
            if (!offlinePlayer.isOnline()) return "0";
            return Integer.toString(DataFactory.getPlayerData(offlinePlayer.getPlayer()).getCurrentStreak());
        }
        if (string.equalsIgnoreCase("total_streak")) {
            if (!offlinePlayer.isOnline()) return "0";
            return Integer.toString(DataFactory.getPlayerData(offlinePlayer.getPlayer()).getCurrentAbsoluteStreak());
        }
        if (string.equalsIgnoreCase("highest_streak")) {
            if (!offlinePlayer.isOnline()) return "0";
            return Integer.toString(DataFactory.getPlayerData(offlinePlayer.getPlayer()).getHighestStreak());
        }
        if (string.equalsIgnoreCase("reward_day")) {
            if (!offlinePlayer.isOnline()) return "0";
            return Integer.toString(DataFactory.getPlayerData(offlinePlayer.getPlayer()).getCurrentStreak());
        }
        if (!string.contains("_")) return null;
        stringArray = string.split("_");
        if (stringArray.length == 4) {
            if (!stringArray[0].equalsIgnoreCase("leaderboard")) return null;
            try {
                String string4 = stringArray[2];
                int n = Integer.parseInt(stringArray[3]);
                if (stringArray[1].equalsIgnoreCase("totalrewards")) {
                    if (string4.equalsIgnoreCase("name")) {
                        String string5 = LeaderBoardHandler.getTotRewAtPosKEY(n);
                        if (!string5.equals(CustomYMLFiles.getCustomConfigFile("Config.yml").getString("NoPlayer-NameText", "No-One"))) return Bukkit.getOfflinePlayer((UUID)UUID.fromString(string5)).getName();
                        return string5;
                    }
                    if (!string4.equalsIgnoreCase("value")) return null;
                    return Integer.toString(LeaderBoardHandler.getTotRewAtPosVAL(n));
                }
                if (!stringArray[1].equalsIgnoreCase("currentstreak")) return null;
                if (string4.equalsIgnoreCase("name")) {
                    String string6 = LeaderBoardHandler.getCurAbsAtPosKEY(n);
                    if (!string6.equals(CustomYMLFiles.getCustomConfigFile("Config.yml").getString("NoPlayer-NameText", "No-One"))) return Bukkit.getOfflinePlayer((UUID)UUID.fromString(string6)).getName();
                    return string6;
                }
                if (!string4.equalsIgnoreCase("value")) return null;
                return Integer.toString(LeaderBoardHandler.getCurAbsAtPosVAL(n));
            }
            catch (Exception exception) {
                return Hex.hexTranslate("&c&oOops... &f" + stringArray[3] + "&c was not recognised as a valid number");
            }
        } else {
            if (stringArray.length != 3 || !stringArray[0].equalsIgnoreCase("rewards")) return null;
            if (stringArray[1].equalsIgnoreCase("name")) {
                try {
                    int n = Integer.parseInt(stringArray[2]);
                    if (n >= 1) return GetReward.name(n);
                    return Hex.hexTranslate("&c&oOops... &cInvalid day number in placeholder");
                }
                catch (Exception exception) {
                    return Hex.hexTranslate("&c&oOops... &cInvalid day number in placeholder");
                }
            }
            if (!stringArray[1].equalsIgnoreCase("icon")) return null;
            try {
                int n = Integer.parseInt(stringArray[2]);
                if (n >= 1) return GetReward.icon(n).name();
                return Hex.hexTranslate("&c&oOops... &cInvalid day number in placeholder");
            }
            catch (Exception exception) {
                return Hex.hexTranslate("&c&oOops... &cInvalid day number in placeholder");
            }
        }
    }
}

