/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.Modules.MySQL;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.configuration.file.FileConfiguration;
import uhfinn.dailyrewardsplus.Main;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.CustomYMLFiles;
import uhfinn.dailyrewardsplus.hikari.HikariConfig;
import uhfinn.dailyrewardsplus.hikari.HikariDataSource;

public class Database {
    private String host;
    private String port;
    private String database;
    private String username;
    private String password;
    public HikariDataSource ds;

    public Database(FileConfiguration fileConfiguration) {
        this.host = fileConfiguration.getString("MySQL-Login.Host");
        this.port = fileConfiguration.getString("MySQL-Login.Port");
        this.database = fileConfiguration.getString("MySQL-Login.Database");
        this.username = fileConfiguration.getString("MySQL-Login.Username");
        this.password = fileConfiguration.getString("MySQL-Login.Password");
    }

    public void connect() {
        Main.INSTANCE().getLogger().info("[DailyRewards+] Establishing MySQL Connection Pool");
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName("com.mysql.cj.jdbc.Driver");
        hikariConfig.setJdbcUrl("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?testConnectOnCheckout=true&idleConnectionTestPeriod=3600&allowReconnect=true&autoReconnect=true");
        hikariConfig.setUsername(this.username);
        hikariConfig.setPassword(this.password);
        hikariConfig.setIdleTimeout(0L);
        this.ds = new HikariDataSource(hikariConfig);
        this.setup();
    }

    public void adjust(String string, String string2, String string3, String string4, String string5) {
        this.host = string;
        this.port = string2;
        this.database = string3;
        this.username = string4;
        this.password = string5;
    }

    public void reloadDetails() {
        FileConfiguration fileConfiguration = CustomYMLFiles.getCustomConfigFile("Config.yml");
        this.host = fileConfiguration.getString("MySQL-Login.Host");
        this.port = fileConfiguration.getString("MySQL-Login.Port");
        this.database = fileConfiguration.getString("MySQL-Login.Database");
        this.username = fileConfiguration.getString("MySQL-Login.Username");
        this.password = fileConfiguration.getString("MySQL-Login.Password");
    }

    public void setup() {
        block12: {
            try (Connection connection = this.getCon();){
                PreparedStatement preparedStatement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS DailyRewardsPlus(UUID varchar(256) PRIMARY KEY, TotalRewards int(10), LastReward bigint, NextReward bigint, CurrentStreak int(10), CurrentAbsoluteStreak int(10), HighestStreak int(10), MissedDays varchar(1024), PlayTime int(16), nextPlayTimeReset bigint, RecentName varchar(64))");
                preparedStatement.execute();
                preparedStatement = connection.prepareStatement("SELECT COUNT(*) FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'DailyRewardsPlus' AND COLUMN_NAME = 'RecentName'");
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next() || resultSet.getInt(1) != 0) break block12;
                try (PreparedStatement preparedStatement2 = connection.prepareStatement("ALTER TABLE DailyRewardsPlus ADD COLUMN RecentName VARCHAR(64)");){
                    preparedStatement2.execute();
                }
            }
        }
    }

    public Connection getCon() {
        try {
            if (this.ds != null) {
                Connection connection = this.ds.getConnection();
                if (connection != null) {
                    return connection;
                }
                throw new SQLException("Can't acquire SQL connection from the pool");
            }
            throw new SQLException("Can't acquire SQL connection from the pool as ds is null");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }
}

