/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.Modules;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import uhfinn.dailyrewardsplus.Main;
import uhfinn.dailyrewardsplus.Modules.TextTransformations.Hex;
import uhfinn.dailyrewardsplus.Modules.Time.getTimeValues;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.YMLFiles.Config.ConfigDataPull;

public class Debugger {
    Logger logger = Bukkit.getLogger();
    boolean active = false;
    int level = 0;
    String tmpFileName;
    File debugFile;
    FileWriter debugWriter;

    public Debugger() {
        File[] fileArray;
        File file = new File(Main.INSTANCE().getDataFolder() + "/Data/DebugLogs/tmp");
        if (file.exists() && file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length != 0) {
            File fileArray2 = null;
            long l = 0L;
            for (File fileArray3 : fileArray) {
                if (fileArray2 == null) {
                    fileArray2 = fileArray3;
                    continue;
                }
                try {
                    long exception = Long.parseLong(fileArray3.getName().split("-")[1]);
                    if (exception <= l) continue;
                    fileArray2 = fileArray3;
                    l = exception;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int n = 0;
            long l3 = 0L;
            for (File iOException : fileArray) {
                if (iOException == fileArray2) continue;
                try {
                    l3 += iOException.length();
                    Files.delete(iOException.toPath());
                    ++n;
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            if (n != 0) {
                this.logger.info(ConfigDataPull.soutPrefix() + " Removed " + n + " expired files [" + Math.round((float)l3 / 1024.0f) + "kb] from the tmp debug folder.");
            }
            double d = Math.round((float)fileArray2.length() / 1024.0f);
            try {
                this.active = true;
                this.level = Integer.parseInt(fileArray2.getName().split("\\[")[1].split("]")[0]);
                this.tmpFileName = fileArray2.getName();
                this.debugFile = fileArray2;
                this.debugWriter = new FileWriter(fileArray2, true);
                this.logger.info(ConfigDataPull.soutPrefix() + " Successfully loaded active debug log, this debugger will continue running normally at level " + this.level + ".\nPlease note: The size of this debug file is currently " + d + "kb. If you wish to stop debugging, run the command '/daily debug stop' or '/daily debug save'");
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                    Files.delete(fileArray2.toPath());
                    this.logger.info(ConfigDataPull.soutPrefix() + " An error occurred whilst loading an old active debugger.\nThis debug file [" + d + "kb] was corrupted and thus removed from temporary storage");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public String startLog(int n) {
        if (this.active) {
            return Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&c&oOops... &cA debugger is already active, please run &f/daily debug stop &cor &f/daily debug save &cbefore starting a new one!");
        }
        this.active = true;
        this.level = n;
        try {
            this.tmpFileName = "/Data/DebugLogs/tmp/[" + n + "]-" + getTimeValues.getTime() + "-#.txt";
            this.debugFile = new File(Main.INSTANCE().getDataFolder() + this.tmpFileName);
            new File(Main.INSTANCE().getDataFolder() + "/Data/DebugLogs/tmp").mkdirs();
            if (this.debugFile.createNewFile()) {
                this.debugWriter = new FileWriter(Main.INSTANCE().getDataFolder() + this.tmpFileName);
                this.logger.info(ConfigDataPull.soutPrefix() + " Instantiated debug logger; [." + this.tmpFileName + "]");
                return Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&aThe debugger is now running at recording level &f" + n + "/3&a.\nTo stop the debugger, please run &f/daily debug stop &aor &f/daily debug save");
            }
            return Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&c&oOops... &cYour server is likely running behind, or you are attempting to instantiate debuggers too quickly, please try again later.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&c&oOops... &cAn error occurred while initiating the debugger, please try again later or contact the plugin developer! &f&o[IOException]");
        }
    }

    public String stopLog() {
        if (this.active) {
            try {
                double d = Math.round((float)this.debugFile.length() / 1024.0f);
                this.safeShutdown();
                this.active = false;
                this.level = 0;
                Files.delete(this.debugFile.toPath());
                this.tmpFileName = null;
                return Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&aThe debugger stopped recording and deleted all active data &f[" + d + "kb]&a!");
            }
            catch (IOException iOException) {
                return Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&c&oOops... &cThe debugger failed to stop, please try again later or forcefully remove the file.");
            }
        }
        return Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&c&oOops... &cThe debugger is not currently running, use the command &f/daily debug start [level] &c to start one!");
    }

    public String saveLog(Player player) {
        if (this.active) {
            String string = "CONSOLE";
            if (player != null) {
                string = player.getName();
            }
            this.debug("Debugger Disabled by " + string, 0);
            this.safeShutdown();
            this.active = false;
            double d = Math.ceil((float)this.debugFile.length() / 1024.0f);
            String string2 = "[" + this.level + "]-" + Long.parseLong(this.debugFile.getName().split("-")[1]) + "-" + getTimeValues.getTime() + ".txt";
            try {
                Files.move(this.debugFile.toPath(), Paths.get(Main.INSTANCE().getDataFolder() + "/Data/DebugLogs/" + string2, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                this.logger.info(ConfigDataPull.soutPrefix() + " The debugger stopped recording and saved all debug data [" + d + "kb]!\n-> ./plugins/DailyRewardsPlus/Data/DebugLogs/" + string2);
            }
            catch (IOException iOException) {
                this.logger.info(ConfigDataPull.soutPrefix() + " Oops... The debugger failed to save the temporary file, try again later or forcefully stop the debug.");
                return Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&c&oOops... &cThe debugger failed to save the temporary file, try again later or forcefully stop the debug.");
            }
            File file = new File(Main.INSTANCE().getDataFolder() + "/Data/DebugLogs/tmp");
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    file2.delete();
                }
            }
            return Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&aThe debugger stopped recording and saved all debug data &f[" + d + "kb]&a!");
        }
        return Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&c&oOops... &cThe debugger is not currently running, use the command &f/daily debug start [level] &c to start one!");
    }

    public boolean debug(String string, int n) {
        if (this.active && n <= this.level) {
            try {
                this.debugWriter.write(getTimeValues.getTimeString() + " [" + n + "]: " + string + "\n");
                this.debugWriter.flush();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void safeShutdown() {
        if (this.active) {
            try {
                this.debugWriter.close();
            }
            catch (IOException iOException) {
                this.logger.info(ConfigDataPull.soutPrefix() + " An error occurred whilst safely closing the debug writer. Some debug data may be corrupted.");
            }
        }
    }
}

