/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import uhfinn.dailyrewardsplus.Commands.TabCompleters.dailyTab;
import uhfinn.dailyrewardsplus.Commands.daily;
import uhfinn.dailyrewardsplus.CrossCompatibility.VersionDetector;
import uhfinn.dailyrewardsplus.Listeners.BreakDailyChest;
import uhfinn.dailyrewardsplus.Listeners.DamageEvent;
import uhfinn.dailyrewardsplus.Listeners.PickUpItem;
import uhfinn.dailyrewardsplus.Listeners.PlayerJoin;
import uhfinn.dailyrewardsplus.Listeners.PlayerLeave;
import uhfinn.dailyrewardsplus.Listeners.PlayerMove;
import uhfinn.dailyrewardsplus.Listeners.PlayerOpenRewardChest;
import uhfinn.dailyrewardsplus.Listeners.UpdateChecker;
import uhfinn.dailyrewardsplus.Listeners.guiInteractions;
import uhfinn.dailyrewardsplus.Modules.Debugger;
import uhfinn.dailyrewardsplus.Modules.MySQL.Database;
import uhfinn.dailyrewardsplus.Modules.PAPI.PAPIReplacement;
import uhfinn.dailyrewardsplus.Modules.PAPI.Placeholders;
import uhfinn.dailyrewardsplus.Modules.PlayerData.LeaderBoardHandler;
import uhfinn.dailyrewardsplus.Modules.Time.playTimeHandling;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.CustomYMLFiles;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.PluginData.Cleaner;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.YMLFiles.Config.CheckConfigs;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.YMLFiles.Config.ConfigDataPull;
import uhfinn.dailyrewardsplus.bstats.bukkit.Metrics;

public class Main
extends JavaPlugin {
    private static Main _instance;
    Logger logger = Bukkit.getLogger();
    Cleaner cleaner;
    public Debugger debugger;
    public VersionDetector versionDetector;
    public Database database;

    public static Main INSTANCE() {
        return _instance;
    }

    public void onEnable() {
        File file;
        File file2;
        Main.loadConfig0();
        _instance = this;
        this.logger.info("[DailyRewards+] Starting DailyRewards+!");
        this.debugger = new Debugger();
        File file3 = new File(Main.INSTANCE().getDataFolder() + "/Config.yml");
        if (!file3.exists()) {
            this.saveResource("Config.yml", false);
            this.logger.info("[DailyRewards+] Generated Config.yml File");
        }
        if (!(file2 = new File(Main.INSTANCE().getDataFolder() + "/Messages.yml")).exists()) {
            this.saveResource("Messages.yml", false);
            this.logger.info("[DailyRewards+] Generated Messages.yml File");
        }
        if (!(file = new File(Main.INSTANCE().getDataFolder() + "/Rewards.yml")).exists()) {
            this.saveResource("Rewards.yml", false);
            this.logger.info("[DailyRewards+] Generated Rewards.yml File");
        }
        CustomYMLFiles.Reload();
        if (!CheckConfigs.validConfig()) {
            this.logger.warning("\n\n!~~!             !~~!\n!~~!   WARNING   !~~!\n!~~!             !~~!\n[DailyRewards+] You MUST update your config file in order to continue using DailyRewards+\nTo do this please delete your old Config.yml and restart the server!\n!~~!             !~~!\n!~~!   WARNING   !~~!\n!~~!             !~~!\nNote: This is a one time occurrence on this version due to a large plugin update\nDisabling Plugin...\n");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (ConfigDataPull.getSQLEnabled()) {
            this.database = new Database(CustomYMLFiles.getCustomConfigFile("Config.yml"));
            try {
                this.database.connect();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                this.logger.warning("\n\n!~~!             !~~!\n!~~!   WARNING   !~~!\n!~~!             !~~!\n[DailyRewards+] Encountered a fatal error whilst attempting to load the SQL server\nPlease check that your SQL credentials are correct.\nDisabling plugin...");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        this.addListener(new PlayerOpenRewardChest());
        this.addListener(new PlayerJoin());
        this.addListener(new PlayerLeave());
        this.addListener(new PickUpItem());
        this.addListener(new BreakDailyChest());
        this.addListener(new guiInteractions());
        this.addListener(new UpdateChecker());
        this.addListener(new DamageEvent());
        this.addListener(new PlayerMove());
        this.getCommand("daily").setExecutor((CommandExecutor)new daily());
        this.getCommand("daily").setTabCompleter((TabCompleter)new dailyTab());
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            PAPIReplacement.enabled = true;
            new Placeholders((Plugin)this).register();
            this.logger.info("[DailyRewards+] Detected Placeholder API. Successfully enabled plugin support.");
        }
        this.cleaner = new Cleaner();
        if (CustomYMLFiles.getCustomConfigFile("Config.yml").getBoolean("CleanUnusedData")) {
            this.logger.info("[DailyRewards+] Cleaning up...");
            int n = this.cleaner.cleanAll();
            if (n > 0) {
                this.logger.info("[DailyRewards+] Successfully cleaned " + n + " redundant item(s) of data!");
            }
        }
        LeaderBoardHandler.loadInitialDataLB(this.logger);
        ConfigDataPull.recalcLimAndPages();
        playTimeHandling.playTimeUpdaterLoop();
        Metrics metrics = new Metrics(this, 21571);
        this.versionDetector = new VersionDetector();
        this.logger.info("[DailyRewards+] Detected version group as " + (this.versionDetector.is1_20_5p() ? "V1.20.5+" : "V1.13-V1.20.4") + "[" + this.versionDetector.vCode + "]. Applying necessary settings.");
        this.logger.info("[DailyRewards+] Has started successfully!");
        this.debugger.debug("", 0);
        this.debugger.debug("DailyRewards+ Started Successfully!", 0);
    }

    public void onDisable() {
        this.debugger.debug("Server Shutting Down...", 0);
        if (ConfigDataPull.getSQLEnabled() && this.database.ds != null && this.database.ds.isRunning()) {
            this.database.ds.close();
            this.logger.info("[DailyRewards+] Closed Database Connection.");
        }
        if (this.cleaner != null) {
            CustomYMLFiles.Reload();
            if (CustomYMLFiles.getCustomConfigFile("Config.yml").getBoolean("CleanUnusedData")) {
                this.logger.info("[DailyRewards+] Cleaning up...");
                int n = this.cleaner.cleanAll();
                if (n > 0) {
                    this.logger.info("[DailyRewards+] Successfully cleaned " + n + " redundant item(s) of data!");
                }
            }
        }
        this.debugger.safeShutdown();
    }

    public void addListener(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=%%__USER__%%&resource_id=%%__RESOURCE__%%&nonce=%%__NONCE__%%").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

