/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.Listeners;

import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.TileState;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import uhfinn.dailyrewardsplus.Main;
import uhfinn.dailyrewardsplus.Modules.ChestEffects;
import uhfinn.dailyrewardsplus.Modules.PAPI.PAPIReplacement;
import uhfinn.dailyrewardsplus.Modules.PlayerData.DataFactory;
import uhfinn.dailyrewardsplus.Modules.PlayerData.DataUser;
import uhfinn.dailyrewardsplus.Modules.RewardGUI.GUIModular;
import uhfinn.dailyrewardsplus.Modules.TextTransformations.Hex;
import uhfinn.dailyrewardsplus.Modules.TextTransformations.PlaceholderReplacement;
import uhfinn.dailyrewardsplus.Modules.Time.RewardChecking;
import uhfinn.dailyrewardsplus.Modules.Time.getTimeValues;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.CustomYMLFiles;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.YMLFiles.Config.ConfigDataPull;

public class PlayerOpenRewardChest
implements Listener {
    @EventHandler
    public void onOpenChest(PlayerInteractEvent playerInteractEvent) {
        TileState tileState;
        PersistentDataContainer persistentDataContainer;
        Block block;
        if (playerInteractEvent.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        FileConfiguration fileConfiguration = CustomYMLFiles.getCustomConfigFile("Config.yml");
        Player player = playerInteractEvent.getPlayer();
        if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK && ((block = playerInteractEvent.getClickedBlock()).getType() == Material.CHEST || block.getType() == Material.TRAPPED_CHEST || block.getType() == Material.ENDER_CHEST) && (persistentDataContainer = (tileState = (TileState)block.getState()).getPersistentDataContainer()).has(new NamespacedKey((Plugin)Main.INSTANCE(), "dailyrewardchest"), PersistentDataType.INTEGER)) {
            playerInteractEvent.setCancelled(true);
            Main.INSTANCE().debugger.debug(player.getName() + " Clicked a daily reward chest, cancelled open", 3);
            FileConfiguration fileConfiguration2 = CustomYMLFiles.getCustomConfigFile("Messages.yml");
            if (player.hasPermission("daily.chest.use") || player.hasPermission("daily.*") || player.hasPermission("daily.chest.*") || player.isOp()) {
                Main.INSTANCE().debugger.debug(player.getName() + " clicked a daily reward chest and has permission to open said chest", 3);
                FileConfiguration fileConfiguration3 = CustomYMLFiles.getCustomConfigFile("Messages.yml");
                if ((Integer)persistentDataContainer.get(new NamespacedKey((Plugin)Main.INSTANCE(), "inUse"), PersistentDataType.INTEGER) == 0) {
                    Main.INSTANCE().debugger.debug(player.getName() + " attempted to open a reward chest, the chest is ready for them", 2);
                    DataUser dataUser = DataFactory.getPlayerData(player);
                    int n = ConfigDataPull.getStreakLimit();
                    Long l = getTimeValues.getTime();
                    int n2 = 1;
                    if (!fileConfiguration.getString("DailyRewardAnimation").equalsIgnoreCase("none")) {
                        if (RewardChecking.ready(player)) {
                            Main.INSTANCE().debugger.debug("Daily reward is ready to claim", 3);
                            if (RewardChecking.checkPlayTimeValidity(player, true)) {
                                Main.INSTANCE().debugger.debug("Player passes playtime checks", 3);
                                if (dataUser.getCurrentStreak() >= n) {
                                    if (!fileConfiguration.getBoolean("ResetWhenStreakCompleted")) {
                                        dataUser.ResetWhenStreakCompletedFalse();
                                        n2 = n;
                                        Main.INSTANCE().debugger.debug(player.getName() + "'s Daily Reward streak was reset due to completion", 1);
                                    }
                                } else {
                                    dataUser.AddOne(true);
                                    n2 = dataUser.getCurrentStreak();
                                    Main.INSTANCE().debugger.debug(player.getName() + "'s Daily Reward streak was incremented by 1 from a daily chest", 1);
                                }
                                dataUser.SetTime(l);
                                getTimeValues.setNextTime(player);
                                Collection collection = block.getWorld().getNearbyEntities(block.getLocation(), 1.0, 1.5, 1.0);
                                for (Object object : collection) {
                                    if (object.getType() != EntityType.ARMOR_STAND) continue;
                                    ArmorStand armorStand = (ArmorStand)object;
                                    String string = ConfigDataPull.FloatingText();
                                    if (fileConfiguration.getBoolean("FloatingTextAbove")) {
                                        if (string == armorStand.getCustomName()) continue;
                                        armorStand.setCustomName(Hex.hexTranslate(string));
                                        armorStand.setCustomNameVisible(true);
                                        continue;
                                    }
                                    armorStand.setCustomNameVisible(false);
                                }
                                Object object = fileConfiguration.getString("DailyRewardAnimation");
                                if (object != null) {
                                    object = ((String)object).toLowerCase(Locale.ROOT);
                                    Main.INSTANCE().debugger.debug("Initiated Daily Reward Animation:" + (String)object + " for " + player.getName(), 2);
                                    switch (object) {
                                        case "gui": {
                                            ChestEffects.GUI(block, player, fileConfiguration, fileConfiguration3, tileState, persistentDataContainer, n2);
                                            break;
                                        }
                                        case "firework": {
                                            ChestEffects.Firework(block, player, fileConfiguration, fileConfiguration3, tileState, persistentDataContainer, n2);
                                            break;
                                        }
                                        case "lightning": {
                                            ChestEffects.Lightning(block, player, fileConfiguration, fileConfiguration3, tileState, persistentDataContainer, n2);
                                            break;
                                        }
                                        case "christmas": {
                                            ChestEffects.Christmas(block, player, fileConfiguration, fileConfiguration3, tileState, persistentDataContainer, n2);
                                            break;
                                        }
                                        default: {
                                            ChestEffects.popOut(block, player, fileConfiguration, fileConfiguration3, tileState, persistentDataContainer, n2);
                                            break;
                                        }
                                    }
                                } else {
                                    ChestEffects.popOut(block, player, fileConfiguration, fileConfiguration3, tileState, persistentDataContainer, n2);
                                }
                                DataFactory.updateDatabase(player, true);
                            }
                        } else {
                            player.sendMessage(Hex.hexTranslate(ConfigDataPull.PluginPrefix() + PAPIReplacement.ReplacePlaceholders(player, PlaceholderReplacement.replace(Objects.requireNonNull(fileConfiguration3.getString("RewardNotReady")), player))));
                        }
                    } else {
                        GUIModular.runGUI(player, null, true);
                    }
                } else {
                    player.sendMessage(Hex.hexTranslate(ConfigDataPull.PluginPrefix() + PAPIReplacement.ReplacePlaceholders(player, PlaceholderReplacement.replace(Objects.requireNonNull(fileConfiguration3.getString("ChestInUse")), player))));
                }
            } else {
                player.sendMessage(Hex.hexTranslate(ConfigDataPull.PluginPrefix() + PAPIReplacement.ReplacePlaceholders(player, PlaceholderReplacement.replace(Objects.requireNonNull(fileConfiguration2.getString("NoPermission")), player))));
            }
        }
    }
}

