/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.Listeners;

import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import uhfinn.dailyrewardsplus.Listeners.PlayerLeave;
import uhfinn.dailyrewardsplus.Main;
import uhfinn.dailyrewardsplus.Modules.PAPI.PAPIReplacement;
import uhfinn.dailyrewardsplus.Modules.PlayerData.DataFactory;
import uhfinn.dailyrewardsplus.Modules.PlayerData.DataUser;
import uhfinn.dailyrewardsplus.Modules.RewardGUI.GUIModular;
import uhfinn.dailyrewardsplus.Modules.TextTransformations.Hex;
import uhfinn.dailyrewardsplus.Modules.TextTransformations.PlaceholderReplacement;
import uhfinn.dailyrewardsplus.Modules.Time.RewardChecking;
import uhfinn.dailyrewardsplus.Modules.Time.getTimeValues;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.CustomYMLFiles;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.YMLFiles.Config.ConfigDataPull;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.YMLFiles.Rewards.GetReward;

public class PlayerJoin
implements Listener {
    @EventHandler
    public void PlayerSetUp(PlayerJoinEvent playerJoinEvent) {
        Main.INSTANCE().debugger.debug(playerJoinEvent.getPlayer().getName() + " joined", 2);
        Player player = playerJoinEvent.getPlayer();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.INSTANCE(), () -> DataFactory.initUser(player, player.getUniqueId().toString()));
    }

    @EventHandler
    public void PlayerReminder(PlayerJoinEvent playerJoinEvent) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.INSTANCE(), () -> {
            FileConfiguration fileConfiguration = CustomYMLFiles.getCustomConfigFile("Config.yml");
            Player player = playerJoinEvent.getPlayer();
            Long[] longArray = new Long[]{100L};
            if (fileConfiguration.getBoolean("RewardAutoClaim") && (player.hasPermission("daily.claim") || player.hasPermission("daily.*") || player.isOp())) {
                if (RewardChecking.ready(player)) {
                    Main.INSTANCE().debugger.debug("Firing reward auto claim event for " + player.getName() + ", type:join", 2);
                    PlayerJoin.serveAutoReward(player);
                }
            } else if (fileConfiguration.getBoolean("RewardInstantPopup") && (player.hasPermission("daily.claim") || player.hasPermission("daily.*") || player.isOp())) {
                Main.INSTANCE().debugger.debug("Initiated 20 tick countdown for reward popup for " + player.getName(), 3);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.INSTANCE(), () -> {
                    Main.INSTANCE().debugger.debug("Reward popup processed for " + player.getName(), 3);
                    Long l = getTimeValues.getTime();
                    if (l > DataFactory.getPlayerData(player).getNextReward()) {
                        longArray[0] = (long)fileConfiguration.getInt("RewardReminderCooldown") * 20L;
                        GUIModular.runGUI(player, null, true);
                    }
                }, 20L);
            }
            int n = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Main.INSTANCE(), () -> {
                FileConfiguration fileConfiguration = CustomYMLFiles.getCustomConfigFile("Messages.yml");
                FileConfiguration fileConfiguration2 = CustomYMLFiles.getCustomConfigFile("Config.yml");
                if (RewardChecking.ready(player) && RewardChecking.checkPlayTimeValidity(player, false)) {
                    if (fileConfiguration2.getBoolean("RewardAutoClaim") && (player.hasPermission("daily.claim") || player.hasPermission("daily.*") || player.isOp())) {
                        Main.INSTANCE().debugger.debug("Firing reward auto claim event for " + player.getName() + ", type:online", 2);
                        PlayerJoin.serveAutoReward(player);
                    } else if (fileConfiguration2.contains("DailyRewardReminderEnabled") && fileConfiguration2.getBoolean("DailyRewardReminderEnabled")) {
                        String string = player.getWorld().getName();
                        List<String> list = ConfigDataPull.getBlacklistedRewardReminderWorlds();
                        if (!list.contains(string)) {
                            if (fileConfiguration.contains("RewardReminderMessage")) {
                                String string2 = PAPIReplacement.ReplacePlaceholders(player, fileConfiguration.getString("RewardReminderMessage"));
                                if (string2 != null) {
                                    TextComponent textComponent = new TextComponent(TextComponent.fromLegacyText((String)Hex.hexTranslate(PlaceholderReplacement.replace(ConfigDataPull.PluginPrefix() + string2, player))));
                                    if (fileConfiguration2.contains("DailyRewardReminderClickable")) {
                                        if (fileConfiguration2.getBoolean("DailyRewardReminderClickable")) {
                                            textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/daily"));
                                        }
                                    } else {
                                        textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/daily"));
                                    }
                                    player.spigot().sendMessage((BaseComponent)textComponent);
                                    Main.INSTANCE().debugger.debug("Sent a reward reminder message to " + player.getName(), 2);
                                } else {
                                    player.spigot().sendMessage((BaseComponent)PlayerJoin.generateDefaultMessage());
                                }
                            } else {
                                player.spigot().sendMessage((BaseComponent)PlayerJoin.generateDefaultMessage());
                            }
                        }
                    }
                }
            }, longArray[0].longValue(), (long)fileConfiguration.getInt("DailyRewardClaimReminder") * 20L);
            PlayerLeave.activeRewardReminders.put(player, n);
        });
    }

    private static void serveAutoReward(Player player) {
        FileConfiguration fileConfiguration = CustomYMLFiles.getCustomConfigFile("Config.yml");
        Main.INSTANCE().debugger.debug("AutoClaim event fired for " + player.getName(), 1);
        if (RewardChecking.checkPlayTimeValidity(player, false)) {
            int n = ConfigDataPull.getStreakLimit();
            DataUser dataUser = DataFactory.getPlayerData(player);
            if (dataUser.getCurrentStreak() >= n && !fileConfiguration.getBoolean("ResetWhenStreakCompleted")) {
                dataUser.ResetWhenStreakCompletedFalse();
                Main.INSTANCE().debugger.debug(player.getName() + "'s Daily Reward streak was reset due to completion", 1);
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.INSTANCE(), () -> {
                ConsoleCommandSender consoleCommandSender = Bukkit.getServer().getConsoleSender();
                List<String> list = GetReward.command(dataUser.getCurrentStreak() + 1);
                for (String string : list) {
                    if (string == null || string.equals("") || string.equals(" ")) continue;
                    String string2 = Hex.hexTranslate(PlaceholderReplacement.replace(string, player));
                    Bukkit.dispatchCommand((CommandSender)consoleCommandSender, (String)string2);
                    Main.INSTANCE().debugger.debug("Fired command: /" + string2, 3);
                }
                player.sendMessage(Hex.hexTranslate(ConfigDataPull.PluginPrefix() + PAPIReplacement.ReplacePlaceholders(player, PlaceholderReplacement.replace(CustomYMLFiles.getCustomConfigFile("Messages.yml").getString("RewardClaim"), player))));
                dataUser.AddOne(true);
                dataUser.SetTime(getTimeValues.getTime());
                getTimeValues.setNextTime(player);
                DataFactory.updateDatabase(player, true);
                Main.INSTANCE().debugger.debug("Fired " + list.size() + "x Command's to " + player.getName() + " due to auto-claim", 1);
            }, 50L);
        }
    }

    private static TextComponent generateDefaultMessage() {
        TextComponent textComponent = new TextComponent(TextComponent.fromLegacyText((String)Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&aYou have a Daily Reward waiting to be claimed!\n&a&nClick Here&a to claim your Daily Reward!")));
        textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/daily"));
        return textComponent;
    }
}

