/*
 * Decompiled with CFR 0.152.
 */
package uhfinn.dailyrewardsplus.Listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.TileState;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import uhfinn.dailyrewardsplus.CrossCompatibility.nativeBridgeV1_20_5;
import uhfinn.dailyrewardsplus.Main;
import uhfinn.dailyrewardsplus.Modules.Animations;
import uhfinn.dailyrewardsplus.Modules.PAPI.PAPIReplacement;
import uhfinn.dailyrewardsplus.Modules.TextTransformations.Hex;
import uhfinn.dailyrewardsplus.Modules.TextTransformations.PlaceholderReplacement;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.CustomYMLFiles;
import uhfinn.dailyrewardsplus.Modules.YmlManipulation.YMLFiles.Config.ConfigDataPull;

public class BreakDailyChest
implements Listener {
    public static List<Location> nonBreakable = new ArrayList<Location>();

    @EventHandler
    public void BreakChest(BlockBreakEvent blockBreakEvent) {
        TileState tileState;
        PersistentDataContainer persistentDataContainer;
        Player player = blockBreakEvent.getPlayer();
        Block block = blockBreakEvent.getBlock();
        if (nonBreakable.contains(block.getLocation())) {
            if ((player.isOp() || player.hasPermission("daily.admin") || player.hasPermission("daily.*")) && player.isSneaking()) {
                nonBreakable.remove(block.getLocation());
                Main.INSTANCE().debugger.debug(player.getName() + " forcefully removed a DRP defined nonBreakable due to permissions and sneaking", 1);
            } else {
                blockBreakEvent.setCancelled(true);
            }
        }
        if ((block.getType() == Material.CHEST || block.getType() == Material.TRAPPED_CHEST) && (persistentDataContainer = (tileState = (TileState)block.getState()).getPersistentDataContainer()).has(new NamespacedKey((Plugin)Main.INSTANCE(), "dailyrewardchest"), PersistentDataType.INTEGER) && (Integer)persistentDataContainer.get(new NamespacedKey((Plugin)Main.INSTANCE(), "dailyrewardchest"), PersistentDataType.INTEGER) == 1) {
            FileConfiguration fileConfiguration = CustomYMLFiles.getCustomConfigFile("Messages.yml");
            if (player.hasPermission("daily.chest.remove") || player.hasPermission("daily.chest.*") || player.hasPermission("daily.*") || player.hasPermission("daily.admin") || player.isOp()) {
                blockBreakEvent.setDropItems(false);
                if (player.isSneaking()) {
                    Main.INSTANCE().debugger.debug(player.getName() + " is sneaking whilst breaking a DRP chest. This chest should be considered broken", 1);
                    if ((Integer)persistentDataContainer.get(new NamespacedKey((Plugin)Main.INSTANCE(), "inUse"), PersistentDataType.INTEGER) == 0) {
                        Collection collection = block.getWorld().getNearbyEntities(block.getLocation(), 1.0, 1.5, 1.0);
                        for (Entity entity : collection) {
                            if (entity.getType() != EntityType.ARMOR_STAND) continue;
                            entity.remove();
                        }
                        player.sendMessage(Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&aYou have removed the DailyReward+ Chest at X:" + block.getLocation().getX() + ", Y:" + block.getLocation().getY() + ", Z:" + block.getLocation().getZ() + ", In world: " + block.getWorld().getName()));
                    } else {
                        Collection collection = block.getWorld().getNearbyEntities(block.getLocation(), 1.0, 1.75, 1.0);
                        for (Entity entity : collection) {
                            PersistentDataContainer persistentDataContainer2;
                            if (entity.getType() == EntityType.ARMOR_STAND) {
                                entity.remove();
                                continue;
                            }
                            if (entity.getType() != nativeBridgeV1_20_5.cEntityType.getItem() || !(persistentDataContainer2 = entity.getPersistentDataContainer()).has(new NamespacedKey((Plugin)Main.INSTANCE(), "noPickupDRP"), PersistentDataType.INTEGER)) continue;
                            entity.remove();
                        }
                        player.sendMessage(Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&aYou have removed the DailyReward+ Chest at X:" + block.getLocation().getX() + ", Y:" + block.getLocation().getY() + ", Z:" + block.getLocation().getZ() + ", In world: " + block.getWorld().getName()));
                    }
                } else {
                    Main.INSTANCE().debugger.debug(player.getName() + " attempted to break a daily reward chest", 3);
                    if ((Integer)persistentDataContainer.get(new NamespacedKey((Plugin)Main.INSTANCE(), "inUse"), PersistentDataType.INTEGER) == 0) {
                        Main.INSTANCE().debugger.debug(player.getName() + " just broke a daily reward chest'", 2);
                        Collection collection = block.getWorld().getNearbyEntities(block.getLocation(), 1.0, 1.5, 1.0);
                        int n = 0;
                        for (Entity entity : collection) {
                            if (entity.getType() != EntityType.ARMOR_STAND) continue;
                            entity.remove();
                            ++n;
                        }
                        Main.INSTANCE().debugger.debug("Despawned " + n + "x armor stands near the DRP chest", 2);
                        player.sendMessage(Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&aYou have removed the DailyReward+ Chest at X:" + block.getLocation().getX() + ", Y:" + block.getLocation().getY() + ", Z:" + block.getLocation().getZ() + ", In world: " + block.getWorld().getName()));
                    } else {
                        Main.INSTANCE().debugger.debug(player.getName() + " attempted to break a daily reward chest, it was in use.", 2);
                        blockBreakEvent.setCancelled(true);
                        player.sendMessage(Hex.hexTranslate(ConfigDataPull.PluginPrefix() + "&c&oOops... &cThis daily rewards chest is in use, please wait a few seconds before breaking it | If this is a bug and you need to remove it, break the container while crouching; We don't recommend doing this unless you are experiencing a bug as it could throw some errors into the console!"));
                        Animations.ChestAnimation(block, false);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.INSTANCE(), () -> {
                            if ((Integer)persistentDataContainer.get(new NamespacedKey((Plugin)Main.INSTANCE(), "inUse"), PersistentDataType.INTEGER) == 1) {
                                Animations.ChestAnimation(block, true);
                                Main.INSTANCE().debugger.debug("Re-parsed chest animation due to chest attempted break", 3);
                            }
                        }, 5L);
                    }
                }
            } else {
                player.sendMessage(Hex.hexTranslate(ConfigDataPull.PluginPrefix() + PAPIReplacement.ReplacePlaceholders(player, PlaceholderReplacement.replace(Objects.requireNonNull(fileConfiguration.getString("NoPermission")), player))));
                blockBreakEvent.setCancelled(true);
            }
        }
    }
}

